package com.artfess.device.monitor.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.monitor.manager.DeviceDataWaterManager;
import com.artfess.device.monitor.model.DeviceDataWater;
import com.artfess.device.monitor.vo.WaterStatisticVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 实时监控-水位监控（DEVICE_DATA_WATER） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-07-26
 */

@Slf4j
@RestController
@Api(tags = "设施数据-水位监控")
@RequestMapping("/data/water/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceDataWaterController extends BaseController<DeviceDataWaterManager, DeviceDataWater> {

    @PostMapping("/statistic")
    @ApiOperation("积水设备统计")
    public CommonResult<WaterStatisticVo> statistic(@ApiParam(name = "dto", value = "参数") @RequestBody StatisticsDto dto){
        log.info("积水设备统计请求参数：{}", dto);
        WaterStatisticVo result = baseService.statistic(dto);
        log.info("积水设备统计响应结果：{}", result);
        return CommonResult.success(result, "操作成功.");

    }

}
