package com.artfess.device.base.vo;

import com.artfess.device.base.model.DeviceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 设备分组关联vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-18
 */
@Data
@ApiModel(value="设备分组关联vo")
public class DeviceGroupVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备分组id")
    private String groupId;


    @ApiModelProperty(value = "设备id")
    private List<String> deviceIds;

    @ApiModelProperty(value = "设备信息")
    private List<DeviceInfo> deviceList;

}
