package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 设备告警配置详情
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@TableName("DEVICE_WARN_CONF_DETAILS")
@ApiModel(value="DeviceWarnConfDetails对象", description="设备告警配置详情")
public class DeviceWarnConfDetails extends BaseModel<DeviceWarnConfDetails> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "设备告警配置ID")
    @TableField("device_warn_conf_id_")
    private String deviceWarnConfId;

    @NotBlank(message = "请选择告警数据类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警数据类型（1：物模型属性，2：物模型事件）")
    @TableField("warn_type_")
    private String warnType;

    @NotBlank(message = "请选择告警参数名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警参数名称")
    @TableField("warn_key_")
    private String warnKey;

    @NotBlank(message = "请选择告警条件",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警条件（=，!=，<，>，<=，>=）")
    @TableField("warn_condition_")
    private String warnCondition;

    @NotBlank(message = "请输入告警值",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警值")
    @TableField("warn_value_")
    private String warnValue;

    @ApiModelProperty(value = "告警名称")
    @TableField(exist = false)
    private String warnName;

    @ApiModelProperty(value = "状态 （1：启用，0：禁用）")
    @TableField(exist = false)
    private String status;

    @ApiModelProperty(value = "物模型属性（事件）标识")
    @TableField("METADATA_CODE_")
    private String metadataCode;

    @ApiModelProperty(value = "告警间关联类型(and，or)")
    @TableField("WARN_RELATION_")
    private String warnRelation;

}
