/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.monitor.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.utils.BizUtils;
import com.artfess.device.monitor.dao.DeviceDataWaterDao;
import com.artfess.device.monitor.manager.DeviceDataWaterManager;
import com.artfess.device.monitor.model.DeviceDataWater;
import com.artfess.device.monitor.vo.WaterStatisticVo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceDataWaterManagerImpl
extends BaseManagerImpl<DeviceDataWaterDao, DeviceDataWater>
implements DeviceDataWaterManager {
    @Autowired
    private SysDictionaryManager sdm;

    @Override
    public CommonResult findByDeviceId(String productType, QueryFilter<DeviceDataWater> queryFilter) {
        HashMap data = Maps.newHashMap();
        data.put("productType", productType);
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceDataWater> result = ((DeviceDataWaterDao)this.baseMapper).query((IPage<DeviceDataWater>)this.convert2IPage(pageBean), (Wrapper<DeviceDataWater>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        data.put("data", new PageList(result));
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @Transactional(readOnly=true)
    public PageList<DeviceDataWater> query(QueryFilter<DeviceDataWater> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<DeviceDataWater> result = ((DeviceDataWaterDao)this.baseMapper).query((IPage<DeviceDataWater>)this.convert2IPage(pageBean), (Wrapper<DeviceDataWater>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }

    @Override
    public WaterStatisticVo statistic(StatisticsDto dto) {
        List rqlx = this.sdm.queryDictListItemsByCode("rqlx");
        dto.setDateType(BizUtils.getDicValueByCode(rqlx, dto.getDateType()));
        if (StringUtil.isEmpty((String)dto.getDateType())) {
            dto.setDateType("%Y-%m-%d");
        }
        if (StringUtil.isEmpty((String)dto.getTime())) {
            dto.setTime(DateUtils.formatDate());
        }
        return ((DeviceDataWaterDao)this.baseMapper).statistic(dto).stream().max(Comparator.comparing(WaterStatisticVo::getWaterLevel)).orElse(new WaterStatisticVo());
    }
}

