/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceBaseCompanyManager;
import com.artfess.device.base.manager.DeviceBaseParamsConfManager;
import com.artfess.device.base.manager.DeviceBaseUserManager;
import com.artfess.device.base.model.DeviceBaseCompany;
import com.artfess.device.base.model.DeviceBaseUser;
import com.artfess.device.base.vo.CompanyAndUserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u8bbe\u5907-\u5355\u4f4d\u7ba1\u7406"})
@RequestMapping(value={"/device/base/company/"})
@ApiGroup(group={"device_biz"})
public class DeviceBaseCompanyController
extends BaseController<DeviceBaseCompanyManager, DeviceBaseCompany> {
    private static final Logger log = LoggerFactory.getLogger(DeviceBaseCompanyController.class);
    @Autowired
    private DeviceBaseParamsConfManager deviceBaseParamsConfManager;
    @Autowired
    private DeviceBaseUserManager deviceBaseUserManager;

    @PostMapping(value={"/findAll"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5355\u4f4d\u5217\u8868\uff08\u4e0d\u5206\u9875\uff09")
    public List<DeviceBaseCompany> findAll(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody DeviceBaseCompany company) {
        return ((DeviceBaseCompanyManager)this.baseService).findAll(company);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        List<DeviceBaseUser> list = this.deviceBaseUserManager.findByCompanyIds(Arrays.asList(id));
        if (!CollectionUtils.isEmpty(list)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION.getCode(), "\u8be5\u5355\u4f4d\u4e0b\u8fd8\u6709\u4eba\u5458\uff0c\u8bf7\u5148\u5220\u9664\u4eba\u5458");
        }
        boolean result = ((DeviceBaseCompanyManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        List<DeviceBaseUser> list = this.deviceBaseUserManager.findByCompanyIds(Arrays.asList(ids));
        if (!CollectionUtils.isEmpty(list)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION.getCode(), "\u8be5\u5355\u4f4d\u4e0b\u8fd8\u6709\u4eba\u5458\uff0c\u8bf7\u5148\u5220\u9664\u4eba\u5458");
        }
        boolean result = ((DeviceBaseCompanyManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) DeviceBaseCompany t) {
        boolean result = ((DeviceBaseCompanyManager)this.baseService).save((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        this.deviceBaseParamsConfManager.saveParamsValue(t.getParamsValueList(), t.getId());
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) DeviceBaseCompany t) {
        boolean result = ((DeviceBaseCompanyManager)this.baseService).updateById((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        this.deviceBaseParamsConfManager.saveParamsValue(t.getParamsValueList(), t.getId());
        return new CommonResult();
    }

    @PostMapping(value={"/getCompanyAndUser"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5355\u4f4d\u4eba\u54582\u7ea7\u4e0b\u62c9", response=CompanyAndUserVo.class)
    public List<CompanyAndUserVo> getCompanyAndUser(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody DeviceBaseCompany company) {
        return ((DeviceBaseCompanyManager)this.baseService).getCompanyAndUser(company);
    }
}

