/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.third.service.impl;

import com.artfess.base.conf.DingdingConfig;
import com.artfess.base.dingding.exception.InvokeDingTalkException;
import com.artfess.base.dingding.utils.AccessTokenUtil;
import com.artfess.third.service.DingdingService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.request.OapiV2UserGetuserinfoRequest;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.dingtalk.api.response.OapiV2UserGetuserinfoResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DingdingServiceImpl
implements DingdingService {
    @Autowired
    private DingdingConfig dingdingConfig;

    @Override
    public OapiV2UserGetResponse.UserGetResponse getUserInfo(String authCode) {
        String accessToken = AccessTokenUtil.getAccessToken((String)this.dingdingConfig.getAppKey(), (String)this.dingdingConfig.getAppSecret());
        String userId = this.getUserId(authCode, accessToken);
        return this.getOapiV2UserGetResponseByUserId(userId, accessToken);
    }

    private String getUserId(String authCode, String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/getuserinfo");
        OapiV2UserGetuserinfoRequest req = new OapiV2UserGetuserinfoRequest();
        req.setCode(authCode);
        try {
            OapiV2UserGetuserinfoResponse oapiV2UserGetuserinfoResponse = (OapiV2UserGetuserinfoResponse)client.execute((TaobaoRequest)req, accessToken);
            if (oapiV2UserGetuserinfoResponse.isSuccess()) {
                OapiV2UserGetuserinfoResponse.UserGetByCodeResponse userGetByCodeResponse = oapiV2UserGetuserinfoResponse.getResult();
                return userGetByCodeResponse.getUserid();
            }
            throw new InvokeDingTalkException(oapiV2UserGetuserinfoResponse.getErrorCode(), oapiV2UserGetuserinfoResponse.getErrmsg());
        }
        catch (ApiException e) {
            e.printStackTrace();
            throw new InvokeDingTalkException(e.getErrCode(), e.getErrMsg());
        }
    }

    private OapiV2UserGetResponse.UserGetResponse getOapiV2UserGetResponseByUserId(String userId, String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
        OapiV2UserGetRequest req = new OapiV2UserGetRequest();
        req.setUserid(userId);
        req.setLanguage("zh_CN");
        try {
            OapiV2UserGetResponse oapiV2UserGetResponse = (OapiV2UserGetResponse)client.execute((TaobaoRequest)req, accessToken);
            if (oapiV2UserGetResponse.isSuccess()) {
                return oapiV2UserGetResponse.getResult();
            }
            throw new InvokeDingTalkException(oapiV2UserGetResponse.getErrorCode(), oapiV2UserGetResponse.getErrmsg());
        }
        catch (ApiException e) {
            e.printStackTrace();
            throw new InvokeDingTalkException(e.getErrCode(), e.getErrMsg());
        }
    }
}

