/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceGroupInfoDao;
import com.artfess.device.base.dao.DeviceRelationGroupDao;
import com.artfess.device.base.manager.DeviceGroupInfoManager;
import com.artfess.device.base.model.DeviceGroupInfo;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceRelationGroup;
import com.artfess.device.base.vo.DeviceGroupVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DeviceGroupInfoManagerImpl
extends BaseManagerImpl<DeviceGroupInfoDao, DeviceGroupInfo>
implements DeviceGroupInfoManager {
    @Resource
    private DeviceRelationGroupDao deviceRelationGroupDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindDevice(DeviceGroupVo t) {
        Assert.hasText((String)t.getGroupId(), (String)"\u8bf7\u9009\u62e9\u8981\u7ed1\u5b9a\u7684\u8bbe\u5907\u5206\u7ec4");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"group_id_", (Object)t.getGroupId());
        this.deviceRelationGroupDao.delete((Wrapper)queryWrapper);
        t.getDeviceIds().forEach(deviceId -> {
            DeviceRelationGroup deviceRelationGroup = new DeviceRelationGroup();
            deviceRelationGroup.setDeviceId((String)deviceId);
            deviceRelationGroup.setGroupId(t.getGroupId());
            this.deviceRelationGroupDao.insert((Object)deviceRelationGroup);
        });
    }

    @Override
    public DeviceGroupVo getDeviceList(DeviceGroupVo t) {
        List<DeviceInfo> list = this.deviceRelationGroupDao.getDeviceList(t.getGroupId());
        t.setDeviceList(list);
        return t;
    }
}

