/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ProductTypeEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceInfoManager;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.vo.DeviceCountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u8bbe\u5907-\u8bbe\u5907\u7ba1\u7406"})
@RequestMapping(value={"/device/info/"})
@ApiGroup(group={"device_biz"})
public class DeviceInfoController
extends BaseController<DeviceInfoManager, DeviceInfo> {
    private static final Logger log = LoggerFactory.getLogger(DeviceInfoController.class);

    @PostMapping(value={"/findAll"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u5217\u8868")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u8bbe\u5907\u5217\u8868")
    public CommonResult<String> findAll(@ApiParam(name="model", value="\u83b7\u53d6\u8bbe\u5907\u5217\u8868") @RequestBody DeviceInfo entity) {
        log.info("\u83b7\u53d6\u8bbe\u5907\u5217\u8868\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<DeviceInfo> list = ((DeviceInfoManager)this.baseService).findAll(entity);
        return CommonResult.success(list, null);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) DeviceInfo t) {
        String id = ((DeviceInfoManager)this.baseService).createInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) DeviceInfo t) {
        String id = ((DeviceInfoManager)this.baseService).updateInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getDeviceInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u7edf\u8ba1\u60c5\u51b5", notes="0 \u5168\u90e8\u8bbe\u5907; -1 \u62a5\u5e9f; 1 \u6b63\u5e38; 2 \u6545\u969c; 3 \u62a5\u8b66; 9 \u5176\u4ed6; 10 \u5df2\u7981\u7528; 11 \u5df2\u542f\u7528")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u8bbe\u5907\u7edf\u8ba1\u60c5\u51b5")
    public CommonResult<String> getDeviceInfo(@ApiParam(name="productId", value="\u4ea7\u54c1ID") @RequestParam String productId) {
        DeviceCountVo data = ((DeviceInfoManager)this.baseService).getDeviceInfo(productId);
        return CommonResult.success((Object)data, null);
    }

    @PostMapping(value={"/modifyEnabled"})
    @ApiOperation(value="\u542f\u7981\u7528\u8bbe\u5907")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.UPDATE, description="\u542f\u7981\u7528\u8bbe\u5907")
    public CommonResult<String> modifyEnabled(@ApiParam(name="model", value="\u8bbe\u5907") @RequestBody DeviceInfo entity) {
        log.info("\u542f\u7981\u7528\u8bbe\u5907\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        boolean b = ((DeviceInfoManager)this.baseService).modifyEnabled(entity);
        log.info("\u542f\u7981\u7528\u8bbe\u5907\u54cd\u5e94\u7ed3\u679c:{}", (Object)b);
        if (!b) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public DeviceInfo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((DeviceInfoManager)this.baseService).findById(id);
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u8bbe\u5907\u8be6\u60c5")
    public DeviceInfo detail(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((DeviceInfoManager)this.baseService).detail(id);
    }

    @PostMapping(value={"/findByProductType"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8def\u969c\u8bbe\u5907\u5206\u9875\u4fe1\u606f")
    public PageList<DeviceInfo> findByProductType(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceInfo> queryFilter) {
        List querys = queryFilter.getQuerys();
        QueryField queryField = new QueryField();
        queryField.setProperty("t.code_");
        queryField.setValue((Object)ProductTypeEnum.barricade.getCode());
        queryField.setOperation(QueryOP.EQUAL);
        querys.add(queryField);
        return ((DeviceInfoManager)this.baseService).findByProductType(queryFilter);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<DeviceInfo> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceInfo> queryFilter) {
        return ((DeviceInfoManager)this.baseService).findByPage(queryFilter);
    }

    @PostMapping(value={"failureEquipment"})
    @ApiOperation(value="\u6545\u969c\u8bbe\u5907", notes="\u5305\u62ec\u8bbe\u5907\u548c\u89c6\u9891\u70b9\u4f4d")
    public PageList<DeviceInfo> failureEquipment(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceInfo> queryFilter) {
        return ((DeviceInfoManager)this.baseService).failureEquipment(queryFilter);
    }
}

