/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.constants.TenantConstant;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.TenantUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.security.util.AuthorCheck;
import com.artfess.uc.dao.TenantManageDao;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.PwdStrategy;
import com.artfess.uc.model.TenantManage;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="tenantManageManager")
public class TenantManageManagerImpl
extends BaseManagerImpl<TenantManageDao, TenantManage>
implements TenantManageManager {
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    UserManager userManager;
    @Autowired
    UserDao userDao;
    @Autowired
    PwdStrategyManager pwdStrategyManager;
    @Autowired
    SaaSConfig saaSConfig;
    @Autowired
    private AuthorCheck authorCheck;

    @GlobalTransactional
    public void create(TenantManage t) {
        t.setUpdateTime(DateUtil.getCurrentDate());
        super.create((Model)t);
        this.initTenantAdminAndGuest(t.getId());
        TenantUtil.initData((String)t.getId(), (List)TenantConstant.INIT_UC_DATA_TABLE_NAMES);
        try {
            CommonResult initData = this.systemConfigFeignService.initData(t.getId());
            if (!initData.getState().booleanValue()) {
                throw new BaseException("\u521b\u5efa\u79df\u6237\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u521b\u5efa\u79df\u6237\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void initTenantAdminAndGuest(String tenantId) {
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            PwdStrategy strategy = this.pwdStrategyManager.getDefault();
            String defaultPswd = "123456";
            if (strategy != null) {
                defaultPswd = strategy.getInitPwd();
            }
            User tenantAdmin = new User();
            tenantAdmin.setAccount("admin");
            tenantAdmin.setFullname("\u8d85\u7ea7\u7ba1\u7406\u5458");
            tenantAdmin.setStatus(1);
            tenantAdmin.setId(UniqueIdUtil.getSuid());
            tenantAdmin.setCreateTime(LocalDateTime.now());
            tenantAdmin.setFrom("restful");
            tenantAdmin.setPassword(this.passwordEncoder.encode((CharSequence)defaultPswd));
            tenantAdmin.setPwdCreateTime(LocalDateTime.now());
            tenantAdmin.setUserType(0);
            tenantAdmin.setLockedStatus(1);
            tenantAdmin.setTenantId(tenantId);
            this.userManager.create((Model)tenantAdmin);
            User tenantGuest = new User();
            tenantGuest.setAccount("guest");
            tenantGuest.setFullname("\u6e38\u5ba2\u8d26\u53f7");
            tenantGuest.setStatus(1);
            tenantGuest.setId(UniqueIdUtil.getSuid());
            tenantGuest.setCreateTime(LocalDateTime.now());
            tenantGuest.setFrom("restful");
            tenantGuest.setPassword(this.passwordEncoder.encode((CharSequence)defaultPswd));
            tenantGuest.setPwdCreateTime(LocalDateTime.now());
            tenantAdmin.setUserType(2);
            tenantAdmin.setLockedStatus(1);
            tenantGuest.setTenantId(tenantId);
            this.userManager.create((Model)tenantGuest);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public TenantManage getByCode(String code) {
        return ((TenantManageDao)this.baseMapper).getByCode(code);
    }

    @Override
    public List<TenantManage> getByTypeId(String typeId) {
        return ((TenantManageDao)this.baseMapper).getByTypeId(typeId);
    }

    @Override
    @Transactional
    public void deleteByTypeId(String typeId) {
        ((TenantManageDao)this.baseMapper).deleteByTypeId(typeId);
    }

    @Override
    public TenantManage getByDomain(String domain) {
        return ((TenantManageDao)this.baseMapper).getByDomain(domain);
    }

    @Override
    public PageList queryWithType(QueryFilter queryFilter) {
        IPage page = this.convert2IPage(queryFilter.getPageBean());
        return new PageList(((TenantManageDao)this.baseMapper).queryWithType((IPage<TenantManage>)page, (Wrapper<TenantManage>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Override
    public List<TenantManage> getByStatus(String typeId, String status) {
        return ((TenantManageDao)this.baseMapper).getByStatus(typeId, status);
    }

    @Override
    @Transactional
    public void setThreeAdmin(Integer isPartThree, String tenantId) throws Exception {
        User audit;
        User secadmin;
        User sysadmin;
        Assert.notNull((Object)isPartThree, (String)"\u5f00\u542f\u6216\u5173\u95ed\u4e09\u5458\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TenantManage tenantManage = (TenantManage)((Object)((TenantManageDao)this.baseMapper).selectById((Serializable)((Object)tenantId)));
        if (tenantManage != null && isPartThree == 0) {
            tenantManage.setIsPartThree(0);
            sysadmin = this.userManager.getByAccount("sysadmin");
            secadmin = this.userManager.getByAccount("secadmin");
            audit = this.userManager.getByAccount("audit");
            if (BeanUtils.isNotEmpty((Object)sysadmin)) {
                this.userManager.remove((Serializable)((Object)sysadmin.getId()));
            }
            if (BeanUtils.isNotEmpty((Object)secadmin)) {
                this.userManager.remove((Serializable)((Object)secadmin.getId()));
            }
            if (BeanUtils.isNotEmpty((Object)audit)) {
                this.userManager.remove((Serializable)((Object)audit.getId()));
            }
        }
        if (tenantManage != null && isPartThree == 1) {
            User sys;
            String defaultPswd;
            PwdStrategy strategy2;
            Throwable throwable;
            MultiTenantIgnoreResult setThreadLocalIgnore;
            tenantManage.setIsPartThree(1);
            sysadmin = this.userDao.getAllDataByAccount("sysadmin");
            secadmin = this.userDao.getAllDataByAccount("secadmin");
            audit = this.userDao.getAllDataByAccount("audit");
            if (BeanUtils.isNotEmpty((Object)sysadmin)) {
                this.userDao.restoreDeletedUser(sysadmin.getId());
            } else {
                try {
                    setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();
                    throwable = null;
                    try {
                        strategy2 = this.pwdStrategyManager.getDefault();
                        defaultPswd = "123456";
                        if (strategy2 != null) {
                            defaultPswd = strategy2.getInitPwd();
                        }
                        sys = new User();
                        sys.setAccount("sysadmin");
                        sys.setFullname("\u7cfb\u7edf\u7ba1\u7406\u5458");
                        sys.setStatus(1);
                        sys.setId(UniqueIdUtil.getSuid());
                        sys.setCreateTime(LocalDateTime.now());
                        sys.setFrom("restful");
                        sys.setPassword(this.passwordEncoder.encode((CharSequence)defaultPswd));
                        sys.setPwdCreateTime(LocalDateTime.now());
                        sys.setUserType(1);
                        sys.setLockedStatus(1);
                        if (this.saaSConfig.isEnable()) {
                            sys.setTenantId(tenantId);
                        }
                        this.userManager.create((Model)sys);
                    }
                    catch (Throwable strategy2) {
                        throwable = strategy2;
                        throw strategy2;
                    }
                    finally {
                        if (setThreadLocalIgnore != null) {
                            if (throwable != null) {
                                try {
                                    setThreadLocalIgnore.close();
                                }
                                catch (Throwable strategy2) {
                                    throwable.addSuppressed(strategy2);
                                }
                            } else {
                                setThreadLocalIgnore.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
            if (BeanUtils.isNotEmpty((Object)secadmin)) {
                this.userDao.restoreDeletedUser(secadmin.getId());
            } else {
                try {
                    setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();
                    throwable = null;
                    try {
                        strategy2 = this.pwdStrategyManager.getDefault();
                        defaultPswd = "123456";
                        if (strategy2 != null) {
                            defaultPswd = strategy2.getInitPwd();
                        }
                        sys = new User();
                        sys.setAccount("secadmin");
                        sys.setFullname("\u7cfb\u7edf\u5b89\u5168\u5458");
                        sys.setStatus(1);
                        sys.setId(UniqueIdUtil.getSuid());
                        sys.setCreateTime(LocalDateTime.now());
                        sys.setFrom("restful");
                        sys.setPassword(this.passwordEncoder.encode((CharSequence)defaultPswd));
                        sys.setPwdCreateTime(LocalDateTime.now());
                        sys.setUserType(1);
                        sys.setLockedStatus(1);
                        if (this.saaSConfig.isEnable()) {
                            sys.setTenantId(tenantId);
                        }
                        this.userManager.create((Model)sys);
                    }
                    catch (Throwable strategy3) {
                        throwable = strategy3;
                        throw strategy3;
                    }
                    finally {
                        if (setThreadLocalIgnore != null) {
                            if (throwable != null) {
                                try {
                                    setThreadLocalIgnore.close();
                                }
                                catch (Throwable strategy3) {
                                    throwable.addSuppressed(strategy3);
                                }
                            } else {
                                setThreadLocalIgnore.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
            if (BeanUtils.isNotEmpty((Object)audit)) {
                this.userDao.restoreDeletedUser(audit.getId());
            } else {
                try {
                    setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();
                    throwable = null;
                    try {
                        strategy2 = this.pwdStrategyManager.getDefault();
                        defaultPswd = "123456";
                        if (strategy2 != null) {
                            defaultPswd = strategy2.getInitPwd();
                        }
                        sys = new User();
                        sys.setAccount("audit");
                        sys.setFullname("\u65e5\u5fd7\u5ba1\u8ba1\u5458");
                        sys.setStatus(1);
                        sys.setId(UniqueIdUtil.getSuid());
                        sys.setCreateTime(LocalDateTime.now());
                        sys.setFrom("restful");
                        sys.setPassword(this.passwordEncoder.encode((CharSequence)defaultPswd));
                        sys.setPwdCreateTime(LocalDateTime.now());
                        sys.setUserType(1);
                        sys.setLockedStatus(1);
                        if (this.saaSConfig.isEnable()) {
                            sys.setTenantId(tenantId);
                        }
                        this.userManager.create((Model)sys);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (setThreadLocalIgnore != null) {
                            if (throwable != null) {
                                try {
                                    setThreadLocalIgnore.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                setThreadLocalIgnore.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
        }
        ((TenantManageDao)this.baseMapper).updateById((Object)tenantManage);
    }
}

