/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.dao.TenantAuthDao;
import com.artfess.uc.manager.TenantAuthManager;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.manager.TenantTypeManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.TenantAuth;
import com.artfess.uc.model.User;
import com.artfess.uc.params.tenant.TenantAuthAddObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tenantAuthManager")
public class TenantAuthManagerImpl
extends BaseManagerImpl<TenantAuthDao, TenantAuth>
implements TenantAuthManager {
    @Resource
    TenantTypeManager tenantTypeManager;
    @Resource
    TenantManageManager tenantManager;
    @Resource
    UserManager userManager;

    @Override
    public List<TenantAuth> getByTypeAndTenantId(String typeId, String tenantId) {
        return ((TenantAuthDao)this.baseMapper).getByTypeAndTenantId(typeId, tenantId);
    }

    @Override
    @Transactional
    public void deleteByTypeId(String typeId) {
        ((TenantAuthDao)this.baseMapper).deleteByTypeId(typeId);
    }

    @Override
    @Transactional
    public void deleteByTenantId(String tenantId) {
        ((TenantAuthDao)this.baseMapper).deleteByTenantId(tenantId);
    }

    @Override
    @Transactional
    public CommonResult<String> saveTenantAuth(TenantAuthAddObject authAddObject) throws Exception {
        if (StringUtil.isEmpty((String)authAddObject.getTypeId())) {
            return new CommonResult(false, "\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u79df\u6237\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtil.isEmpty((String)authAddObject.getAccounts())) {
            return new CommonResult(false, "\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (BeanUtils.isEmpty((Object)this.tenantTypeManager.get((Serializable)((Object)authAddObject.getTypeId())))) {
            return new CommonResult(false, "\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u79df\u6237\u7c7b\u578bid\u3010" + authAddObject.getTypeId() + "\u3011\u4e0d\u5b58\u5728\u3002");
        }
        if (StringUtil.isNotEmpty((String)authAddObject.getTenantId()) && BeanUtils.isEmpty((Object)this.tenantManager.get((Serializable)((Object)authAddObject.getTenantId())))) {
            return new CommonResult(false, "\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u79df\u6237id\u3010" + authAddObject.getTenantId() + "\u3011\u4e0d\u5b58\u5728\u3002");
        }
        String[] accounts = authAddObject.getAccounts().split(",");
        ArrayList<TenantAuth> auths = new ArrayList<TenantAuth>();
        for (String account : accounts) {
            User u = this.userManager.getByAccount(account);
            if (BeanUtils.isEmpty((Object)u)) {
                return new CommonResult(false, "\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\u4e0d\u5b58\u5728\u3002");
            }
            List<TenantAuth> oldAuths = ((TenantAuthDao)this.baseMapper).getByUserId(authAddObject.getTypeId(), StringUtil.isNotEmpty((String)authAddObject.getTenantId()) ? authAddObject.getTenantId() : null, u.getUserId());
            if (!BeanUtils.isEmpty(oldAuths)) continue;
            TenantAuth auth = new TenantAuth();
            auth.setTypeId(authAddObject.getTypeId());
            auth.setUserId(u.getId());
            auth.setUserName(u.getFullname());
            auth.setTenantId(StringUtil.isNotEmpty((String)authAddObject.getTenantId()) ? authAddObject.getTenantId() : "");
            auths.add(auth);
        }
        if (!BeanUtils.isNotEmpty(auths)) {
            return new CommonResult(true, "\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u64cd\u4f5c\u6210\u529f\uff0c\u4f46\u672a\u6dfb\u52a0\u4efb\u4f55\u7ba1\u7406\u5458\u6570\u636e\u3002");
        }
        super.saveBatch(auths);
        return new CommonResult(true, "\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u6210\u529f\u3002");
    }

    @Override
    @Transactional
    public CommonResult<String> removeTenantAuth(String typeId, String tenantId, String userIds) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return new CommonResult(false, "\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u79df\u6237\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtil.isEmpty((String)userIds)) {
            return new CommonResult(false, "\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (BeanUtils.isEmpty((Object)this.tenantTypeManager.get((Serializable)((Object)typeId)))) {
            return new CommonResult(false, "\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u79df\u6237\u7c7b\u578bid\u3010" + typeId + "\u3011\u4e0d\u5b58\u5728\u3002");
        }
        if (StringUtil.isNotEmpty((String)tenantId) && BeanUtils.isEmpty((Object)this.tenantManager.get((Serializable)((Object)tenantId)))) {
            return new CommonResult(false, "\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u79df\u6237id\u3010" + tenantId + "\u3011\u4e0d\u5b58\u5728\u3002");
        }
        String[] ids = userIds.split(",");
        ArrayList<String> auths = new ArrayList<String>();
        for (String userId : ids) {
            List<TenantAuth> oldAuths = ((TenantAuthDao)this.baseMapper).getByUserId(typeId, tenantId, userId);
            if (!BeanUtils.isNotEmpty(oldAuths)) continue;
            for (TenantAuth tenantAuth : oldAuths) {
                auths.add(tenantAuth.getId());
            }
        }
        if (!BeanUtils.isNotEmpty(auths)) {
            return new CommonResult(true, "\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u64cd\u4f5c\u6210\u529f\uff0c\u4f46\u672a\u5220\u9664\u4efb\u4f55\u7ba1\u7406\u5458\u6570\u636e\u3002");
        }
        super.removeByIds(auths);
        return new CommonResult(true, "\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u6210\u529f\u3002");
    }

    @Override
    public List<TenantAuth> getByUserId(String typeId, String tenantId, String userId) {
        return ((TenantAuthDao)this.baseMapper).getByUserId(typeId, tenantId, userId);
    }

    @Override
    public PageList<TenantAuth> queryByTypeAndTenantId(QueryFilter queryFilter) {
        this.copyQuerysInParams(queryFilter);
        PageBean pageBean = queryFilter.getPageBean();
        if (BeanUtils.isEmpty((Object)pageBean)) {
            pageBean = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE, Boolean.valueOf(false));
        }
        IPage<TenantAuth> query = ((TenantAuthDao)this.baseMapper).queryByTypeAndTenantId((IPage<TenantAuth>)this.convert2IPage(pageBean), (Wrapper<TenantAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(query);
    }

    @Override
    @Transactional
    public void delByUserId(@Param(value="userId") String userId) {
        ((TenantAuthDao)this.baseMapper).delByUserId(userId);
    }
}

