/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.duty.manager.impl;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.json.JSONUtil;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.duty.dao.CmgtDutyTeamDao;
import com.artfess.manage.duty.dao.CmgtDutyTeamMemberDao;
import com.artfess.manage.duty.manager.CmgtDutyTeamManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyTeamDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CmgtDutyTeamManagerImpl
extends BaseManagerImpl<CmgtDutyTeamDao, CmgtDutyTeam>
implements CmgtDutyTeamManager {
    @Resource
    CmgtDutyTeamDao cmgtDutyTeamDao;
    @Resource
    CmgtDutyTeamMemberDao cmgtDutyTeamMemberDao;
    @Resource
    ManageCommonService manageCommonService;
    @Resource
    CmgtDutyTeamDtoMapper cmgtDutyTeamDtoMapper;

    @Override
    public List<CmgtDutyTeam> findAllTeam() {
        return this.cmgtDutyTeamDao.selectByMap(new HashMap());
    }

    @Override
    public PageList<CmgtDutyTeamDto> pageQuery(QueryFilter<CmgtDutyTeam> queryFilter) {
        PageList result = this.query(queryFilter);
        PageList r = new PageList(result.getRows().stream().map(e -> {
            CmgtDutyTeamDto t = (CmgtDutyTeamDto)((Object)((Object)this.cmgtDutyTeamDtoMapper.toDto(e)));
            return t;
        }).collect(Collectors.toList()));
        r.setPageSize(result.getPageSize());
        r.setPageSize(result.getPage());
        return r;
    }

    @Override
    public List<Tree<String>> findOrgTeamTreeData() {
        ArrayList r = new ArrayList();
        this.manageCommonService.getAllOrgTreeNodeList().forEach(o -> {
            o.setExtra((Map)JSONUtil.createObj().putOpt("dataType", (Object)"ORG"));
            r.add(o);
            r.addAll(this.findByOrgId((String)o.getId()).stream().map(team -> {
                TreeNode k = new TreeNode((Object)team.getId(), o.getId(), team.getName(), (Comparable)Integer.valueOf(team.getSn() != null ? team.getSn() : 999));
                k.setExtra((Map)JSONUtil.createObj().putOpt("dataType", (Object)"TEAM"));
                return k;
            }).collect(Collectors.toList()));
        });
        List trees = TreeUtil.build(r, (Object)"96240625-934F-490B-8AA6-0BC775B18468");
        return trees;
    }

    @Override
    public List<CmgtDutyTeam> findByOrgId(String orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_id_", (Object)orgId);
        return this.cmgtDutyTeamDao.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<CmgtDutyTeamMember> findTeamMemberByOrgId(String orgId) {
        if (StringUtil.isEmpty((String)orgId)) {
            return this.cmgtDutyTeamMemberDao.selectList(null);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ORG_ID_", (Object)orgId);
        return this.cmgtDutyTeamMemberDao.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<CmgtDutyTeamMember> findTeamMemberByTeamId(String teamId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"TEAM_ID_", new Object[]{teamId});
        return this.cmgtDutyTeamMemberDao.selectList((Wrapper)queryWrapper).stream().map(t -> t).collect(Collectors.toList());
    }
}

