/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.safty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.utils.BizUtils;
import com.artfess.manage.safty.dao.CmgtSaftyDangerUnitDao;
import com.artfess.manage.safty.manager.CmgtSaftyDangerUnitManager;
import com.artfess.manage.safty.model.CmgtSaftyDangerUnit;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="cmgtSaftyDangerUnitService")
public class CmgtSaftyDangerUnitManagerImpl
extends BaseManagerImpl<CmgtSaftyDangerUnitDao, CmgtSaftyDangerUnit>
implements CmgtSaftyDangerUnitManager {
    @Resource
    private SysDictionaryManager sdm;

    public PageList<CmgtSaftyDangerUnit> query(QueryFilter<CmgtSaftyDangerUnit> queryFilter) {
        return super.query(queryFilter);
    }

    public boolean save(CmgtSaftyDangerUnit entity) {
        if (entity.getSn() == null) {
            entity.setSn(this.count() + 1);
        }
        return super.save((Object)entity);
    }

    public boolean updateById(CmgtSaftyDangerUnit entity) {
        return super.updateById((Object)entity);
    }

    public void removeByIds(String ... ids) {
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public boolean importExcelData(MultipartFile excel) throws Exception {
        ExcelUtils excelUtil = new ExcelUtils(CmgtSaftyDangerUnit.class);
        List list = excelUtil.importExcel(null, excel.getInputStream());
        list.stream().filter(unit -> unit.getUnitName() != null && !unit.getUnitName().isEmpty());
        List zhgl_dwlx = this.sdm.queryDictListItemsByCode("zhgl-dwlx");
        List jxcspq = this.sdm.queryDictListItemsByCode("jxcspq");
        List jxcslx = this.sdm.queryDictListItemsByCode("jxcslx");
        List fxjb = this.sdm.queryDictListItemsByCode("fxjb");
        List zddwjb = this.sdm.queryDictListItemsByCode("zddwjb");
        list.forEach(l -> {
            l.setType(BizUtils.getDicCodeByValue((List)zhgl_dwlx, (String)l.getType()));
            l.setSmallPlaceArea(BizUtils.getDicCodeByValue((List)jxcspq, (String)l.getSmallPlaceArea()));
            l.setSmallPlaceType(BizUtils.getDicCodeByValue((List)jxcslx, (String)l.getSmallPlaceType()));
            l.setRiskLevel(BizUtils.getDicCodeByValue((List)fxjb, (String)l.getRiskLevel()));
            l.setEmphasisLevel(BizUtils.getDicCodeByValue((List)zddwjb, (String)l.getEmphasisLevel()));
            if (StringUtil.isNotEmpty((String)l.getFuelType())) {
                l.setFuelType(l.getType().replace("\u3001", ","));
            }
            if (null == l.getName()) {
                l.setName("");
            }
            if (null == l.getPhone()) {
                l.setPhone("");
            }
        });
        return this.saveBatch(list);
    }
}

