/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.safty.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.manage.safty.manager.CmgtSaftyDangerUnitManager;
import com.artfess.manage.safty.model.CmgtSaftyDangerUnit;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u5b89\u5168\u9690\u60a3\u6392\u67e5\u5bf9\u8c61"})
@RequestMapping(value={"/manager/cmgtSaftyDangerUnit"})
@ApiGroup(group={"manager_biz"})
public class CmgtSaftyDangerUnitController
extends BaseController<CmgtSaftyDangerUnitManager, CmgtSaftyDangerUnit> {
    private static final Logger log = LoggerFactory.getLogger(CmgtSaftyDangerUnitController.class);

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtSaftyDangerUnit t) {
        boolean result = ((CmgtSaftyDangerUnitManager)this.baseService).save((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u521b\u5efa\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult(t.getId());
    }

    @PutMapping(value={"/updateById"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) CmgtSaftyDangerUnit t) {
        boolean result = ((CmgtSaftyDangerUnitManager)this.baseService).updateById((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult(t.getId());
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((CmgtSaftyDangerUnitManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @ApiOperation(value="\u57fa\u7840\u6570\u636e\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) {
        try {
            boolean result = ((CmgtSaftyDangerUnitManager)this.baseService).importExcelData(file);
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()));
            }
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }
}

