/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.manager.impl;

import com.artfess.base.enums.CodePrefix;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialOrderDao;
import com.artfess.manage.material.manager.CmgtMaterialOrderDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialOrderManager;
import com.artfess.manage.material.manager.CmgtMaterialOrderSupplierManager;
import com.artfess.manage.material.model.CmgtMaterialOrder;
import com.artfess.redis.util.CodeCreatorUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CmgtMaterialOrderManagerImpl
extends BaseManagerImpl<CmgtMaterialOrderDao, CmgtMaterialOrder>
implements CmgtMaterialOrderManager {
    @Autowired
    private CmgtMaterialOrderDetailManager orderDetailManager;
    @Autowired
    private CmgtMaterialOrderSupplierManager supplierManager;
    @Resource
    private CodeCreatorUtil codeCreatorUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(CmgtMaterialOrder t) {
        t.setStatus("1");
        String code = this.codeCreatorUtil.createCodeYYYYMMDD(CodePrefix.ORDER, 12);
        t.setCode(code);
        int insert = ((CmgtMaterialOrderDao)this.baseMapper).insert((Object)t);
        if (insert > 0) {
            this.processDetailList(t);
            return true;
        }
        return false;
    }

    private void processDetailList(CmgtMaterialOrder t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_id_", (Object)t.getId());
        this.orderDetailManager.remove((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(t.getDetailList())) {
            return;
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"order_id_", (Object)t.getId());
        this.supplierManager.remove((Wrapper)query);
        t.getDetailList().forEach(detail -> detail.setOrderId(t.getId()));
        this.orderDetailManager.saveOrUpdateBatch(t.getDetailList());
        if (!CollectionUtils.isEmpty(t.getSupplierList())) {
            t.getSupplierList().forEach(supplier -> supplier.setOrderId(t.getId()));
            this.supplierManager.saveOrUpdateBatch(t.getSupplierList());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(CmgtMaterialOrder t) {
        CmgtMaterialOrder order = (CmgtMaterialOrder)((Object)((CmgtMaterialOrderDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == order) {
            throw new BaseException("\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        }
        t.setCode(order.getCode());
        t.setStatus(order.getStatus());
        int insert = ((CmgtMaterialOrderDao)this.baseMapper).updateById((Object)t);
        if (insert > 0) {
            this.processDetailList(t);
            return true;
        }
        return false;
    }

    @Override
    public CmgtMaterialOrder findById(String id) {
        CmgtMaterialOrder cmgtMaterialOrder = (CmgtMaterialOrder)((Object)((CmgtMaterialOrderDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null == cmgtMaterialOrder) {
            return new CmgtMaterialOrder();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_id_", (Object)id);
        List orderDetails = this.orderDetailManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        cmgtMaterialOrder.setDetailList(orderDetails);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"order_id_", (Object)id);
        List cmgtMaterialOrderSuppliers = this.supplierManager.getBaseMapper().selectList((Wrapper)query);
        cmgtMaterialOrder.setSupplierList(cmgtMaterialOrderSuppliers);
        return cmgtMaterialOrder;
    }
}

