/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.monitor.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.monitor.manager.DeviceDataWaterManager;
import com.artfess.device.monitor.model.DeviceDataWater;
import com.artfess.device.monitor.vo.WaterStatisticVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u6570\u636e-\u6c34\u4f4d\u76d1\u63a7"})
@RequestMapping(value={"/data/water/"})
@ApiGroup(group={"device_biz"})
public class DeviceDataWaterController
extends BaseController<DeviceDataWaterManager, DeviceDataWater> {
    private static final Logger log = LoggerFactory.getLogger(DeviceDataWaterController.class);

    @PostMapping(value={"/statistic"})
    @ApiOperation(value="\u79ef\u6c34\u8bbe\u5907\u7edf\u8ba1")
    public CommonResult<WaterStatisticVo> statistic(@ApiParam(name="dto", value="\u53c2\u6570") @RequestBody StatisticsDto dto) {
        log.info("\u79ef\u6c34\u8bbe\u5907\u7edf\u8ba1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)dto);
        WaterStatisticVo result = ((DeviceDataWaterManager)this.baseService).statistic(dto);
        log.info("\u79ef\u6c34\u8bbe\u5907\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return CommonResult.success((Object)result, (String)"\u64cd\u4f5c\u6210\u529f.");
    }
}

