/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.duty.controller;

import cn.hutool.core.lang.tree.Tree;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.manage.duty.manager.CmgtDutyTeamManager;
import com.artfess.manage.duty.manager.CmgtDutyTeamMemberManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberDto;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u52e4\u52a1\u961f\u5458\u4fe1\u606f-\u52e4\u52a1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/manager/duty/member"})
@ApiGroup(group={"manager_biz"})
public class CmgtDutyTeamMemberController
extends BaseController<CmgtDutyTeamMemberManager, CmgtDutyTeamMember> {
    private static final Logger log = LoggerFactory.getLogger(CmgtDutyTeamMemberController.class);
    @Autowired
    private CmgtDutyTeamManager cmgtDutyTeamManager;
    @Autowired
    private CmgtDutyTeamMemberManager cmgtDutyTeamMemberManager;

    @PostMapping(value={"/query/team"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5c0f\u7ec4\u4fe1\u606f")
    public CommonResult<String> query() {
        List<Tree<String>> list = this.cmgtDutyTeamManager.findOrgTeamTreeData();
        return CommonResult.success(list, null);
    }

    @PostMapping(value={"/pageQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public PageList<CmgtDutyTeamMemberDto> pageQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<CmgtDutyTeamMember> queryFilter) {
        return this.cmgtDutyTeamMemberManager.pageQuery(queryFilter);
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtDutyTeamMemberDto t) {
        String result;
        if (StringUtil.isEmpty((String)t.getCode())) {
            t.setCode(PinyinUtil.getPinyinToLowerCase((String)t.getName()));
        }
        if ((result = this.cmgtDutyTeamMemberManager.create(t)) == null) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u521b\u5efa\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult(result);
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> update(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtDutyTeamMemberDto t) {
        String result;
        if (StringUtil.isEmpty((String)t.getCode())) {
            t.setCode(PinyinUtil.getPinyinToLowerCase((String)t.getName()));
        }
        if ((result = this.cmgtDutyTeamMemberManager.update(t)) == null) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult(result);
    }
}

