/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.job;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.job.api.IJobLogService;
import com.artfess.job.model.BaseJob;
import com.artfess.job.model.SysJobLog;
import com.artfess.manage.base.dao.CmgtBasePositionDao;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleGpsinfoManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.duty.model.CmgtDutyJob;
import com.artfess.manage.dwd.dao.DwdSjBusDepartedDao;
import com.artfess.manage.dwd.dao.DwdSjCqEventDao;
import com.artfess.manage.dwd.dao.DwdSjFestivalHolidayDao;
import com.artfess.manage.dwd.dao.DwdSjStationArrivedDao;
import com.artfess.manage.dwd.manager.DwdSjWeatherForcastMiManager;
import com.artfess.manage.dwd.model.DwdSjBusDeparted;
import com.artfess.manage.dwd.model.DwdSjCqEvent;
import com.artfess.manage.dwd.model.DwdSjFestivalHoliday;
import com.artfess.manage.dwd.model.DwdSjStationArrived;
import com.artfess.manage.utils.GeoUtils;
import com.artfess.manage.utils.SignUtils;
import com.artfess.rocketmq.producer.RocketMQProducer;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmgtDataCenterPullSyncJob
extends BaseJob {
    private static final Logger log = LoggerFactory.getLogger(CmgtDataCenterPullSyncJob.class);
    @Resource
    private CmgtDutyWorkarrangeManager cmgtDutyWorkarrangeManager;
    @Resource
    private CmgtDutyVehicleGpsinfoManager cmgtDutyVehicleGpsinfoManager;
    @Resource
    private CmgtDutyJobDao cmgtDutyJobDao;
    @Resource
    private RocketMQProducer rocketMQProducer;
    protected Logger logger = LoggerFactory.getLogger(CmgtDataCenterPullSyncJob.class);
    @Resource
    private DwdSjWeatherForcastMiManager dwdSjWeatherForcastMiManager;
    @Resource
    private CmgtBasePositionDao cmgtBasePositionDao;
    @Resource
    private DwdSjStationArrivedDao dwdSjStationArrivedDao;
    @Resource
    private DwdSjBusDepartedDao dwdSjBusDepartedDao;
    @Resource
    private DwdSjCqEventDao dwdSjCqEventDao;
    @Resource
    private DwdSjFestivalHolidayDao dwdSjFestivalHolidayDao;
    private static boolean finishSyncHoliday = false;

    private void addOperLog(String jobName, String trigName, LocalDateTime startTime, LocalDateTime endTime, long runTime, String content, Integer state) {
        IJobLogService logService = (IJobLogService)AppUtil.getBean(IJobLogService.class);
        SysJobLog jobLog = new SysJobLog(jobName, trigName, startTime, endTime, content, state, Long.valueOf(runTime));
        String id = UniqueIdUtil.getSuid();
        jobLog.setId(id);
        logService.createLog(jobLog);
    }

    public void executeJob(JobExecutionContext context) {
        long startTime = System.currentTimeMillis();
        LocalDateTime strStartTime = LocalDateTime.now();
        for (int k = -1; k > -1000; --k) {
            this.syncDwdSjEventData(k);
            this.syncStationArrivedData(k);
            this.syncDwdSjBusDeparted(k);
        }
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        this.logger.info("CmgtDataCenterPullSyncJob:   " + jobDataMap);
        long runTime = (System.currentTimeMillis() - startTime) / 1000L;
        this.addOperLog(context.getJobDetail().getKey().getName(), "CmgtDataCenterPullSyncJob", strStartTime, LocalDateTime.now(), runTime, "\u4e2d\u53f0\u6570\u636e\u540c\u6b65\u62c9\u53d6", SysJobLog.STATE_YES);
        log.info(new Date() + "======end=====jobDataMap===syncHoliday=========");
    }

    @Transactional
    private void syncStationArrivedData(Integer k) {
        if (k == null) {
            k = -1;
        }
        String dataTime = DateUtil.format((Date)DateUtil.offsetDay((Date)DateUtil.date(), (int)k), (String)"yyyy-MM-dd");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.between((Object)"date_time_", (Object)(dataTime + " 00:00:00"), (Object)(dataTime + " 23:59:59"));
        int count = this.dwdSjStationArrivedDao.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            return;
        }
        String reqParam = "{\"param\":{\"date_time_start\":\"" + dataTime + " 00:00:00\",\"date_time_end\":\"" + dataTime + " 23:59:59\"}}";
        String APPID = "b8fff05a_bf88_4391_8967_fa19364c";
        String APPKEY = "38553d72d3a0480eb0aad7e9cfe4a48a";
        String APPURL = "http://222.180.171.219/api/oapigw/api/oapisvc/automicApi/7fe4711997514f07b6726f9926dca53a";
        try {
            JSONArray list;
            String timestamp = System.currentTimeMillis() + "";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("timestamp", timestamp);
            map.put("appid", APPID);
            StringBuilder signBuilder = new StringBuilder().append("appid=").append(APPID).append("&").append(reqParam).append("&").append("timestamp=").append(timestamp).append("&").append("key=").append(APPKEY);
            map.put("sign", SignUtils.HMACSHA256(signBuilder.toString(), APPKEY));
            HttpResponse r = ((HttpRequest)HttpUtil.createPost((String)APPURL).contentType("application/json").addHeaders(map)).body(reqParam).execute();
            JSONObject result = JSONUtil.parseObj((String)r.body());
            if (result.getInt((Object)"code") == 200 && (list = result.getJSONObject((Object)"data").getJSONArray((Object)"list")).size() > 0) {
                list.forEach(item -> {
                    DwdSjStationArrived arrived = (DwdSjStationArrived)((Object)((Object)JSONUtil.toBean((JSONObject)((JSONObject)item), DwdSjStationArrived.class)));
                    this.dwdSjStationArrivedDao.insert((Object)arrived);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    private void syncDwdSjBusDeparted(Integer k) {
        if (k == null) {
            k = -1;
        }
        String dataTime = DateUtil.format((Date)DateUtil.offsetDay((Date)DateUtil.date(), (int)k), (String)"yyyy-MM-dd");
        String reqParam = "{\"param\":{\"departure_date_start\":\"" + dataTime + " 00:00:00\",\"departure_date_end\":\"" + dataTime + " 23:59:59\"}}";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.between((Object)"departure_date", (Object)(dataTime + " 00:00:00"), (Object)(dataTime + " 23:59:59"));
        int count = this.dwdSjBusDepartedDao.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            return;
        }
        String APPID = "b8fff05a_bf88_4391_8967_fa19364c";
        String APPKEY = "38553d72d3a0480eb0aad7e9cfe4a48a";
        String APPURL = "http://222.180.171.219/api/oapigw/api/oapisvc/automicApi/0533b85a9cbe4994ad99f3ea95b786ff";
        try {
            JSONArray list;
            String timestamp = System.currentTimeMillis() + "";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("timestamp", timestamp);
            map.put("appid", APPID);
            StringBuilder signBuilder = new StringBuilder().append("appid=").append(APPID).append("&").append(reqParam).append("&").append("timestamp=").append(timestamp).append("&").append("key=").append(APPKEY);
            map.put("sign", SignUtils.HMACSHA256(signBuilder.toString(), APPKEY));
            HttpResponse r = ((HttpRequest)HttpUtil.createPost((String)APPURL).contentType("application/json").addHeaders(map)).body(reqParam).execute();
            JSONObject result = JSONUtil.parseObj((String)r.body());
            System.out.println("=====syncDwdSjBusDeparted===result=============" + result);
            if (result.getInt((Object)"code") == 200 && (list = result.getJSONObject((Object)"data").getJSONArray((Object)"list")).size() > 0) {
                list.forEach(item -> {
                    DwdSjBusDeparted departed = (DwdSjBusDeparted)((Object)((Object)JSONUtil.toBean((JSONObject)((JSONObject)item), DwdSjBusDeparted.class)));
                    this.dwdSjBusDepartedDao.insert((Object)departed);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    private void syncDwdSjEventData(Integer k) {
        if (k == null) {
            k = -1;
        }
        String dataTime = DateUtil.format((Date)DateUtil.offsetDay((Date)DateUtil.date(), (int)k), (String)"yyyy-MM-dd");
        String reqParam = "{\"startTime\":\"" + dataTime + " 00:00:00\",\"endTime\":\"" + dataTime + " 23:59:59\"}";
        String APPID = "b8fff05a_bf88_4391_8967_fa19364c";
        String APPKEY = "38553d72d3a0480eb0aad7e9cfe4a48a";
        String APPURL = "http://222.180.171.219/api/oapigw/api/oapisvc/v1/aggapi/ab910d51287f445187b0cd2de850429b";
        try {
            JSONArray list;
            String timestamp = System.currentTimeMillis() + "";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("timestamp", timestamp);
            map.put("appid", APPID);
            StringBuilder signBuilder = new StringBuilder().append("appid=").append(APPID).append("&").append(reqParam).append("&").append("timestamp=").append(timestamp).append("&").append("key=").append(APPKEY);
            map.put("sign", SignUtils.HMACSHA256(signBuilder.toString(), APPKEY));
            HttpResponse r = ((HttpRequest)HttpUtil.createPost((String)APPURL).contentType("application/json").addHeaders(map)).body(reqParam).execute();
            JSONObject result = JSONUtil.parseObj((String)r.body());
            System.out.println(reqParam + "====" + k + "=syncDwdSjEventData===result=============" + result);
            List jobs = this.cmgtDutyJobDao.selectList(null);
            if (result.getInt((Object)"code") == 200 && (list = result.getJSONObject((Object)"data").getJSONArray((Object)"list")).size() > 0) {
                list.forEach(item -> {
                    int count;
                    JSONObject oitem = (JSONObject)item;
                    if (oitem.get((Object)"handleUserList") != null) {
                        System.out.println(oitem.get((Object)"handleUserList") + "====k=syncDwdSjEventData===handleUserList1111=============" + result);
                    }
                    if ((count = this.dwdSjCqEventDao.selectCount((Wrapper)new QueryWrapper().eq((Object)"event_id", (Object)oitem.getStr((Object)"eventId"))).intValue()) == 0) {
                        DwdSjCqEvent sjCqEvent = (DwdSjCqEvent)((Object)((Object)JSONUtil.toBean((JSONObject)oitem, DwdSjCqEvent.class)));
                        if (sjCqEvent.getLnglat() != null) {
                            for (CmgtDutyJob j : jobs) {
                                if (!GeoUtils.pointInPolygon(sjCqEvent.getLnglat(), j.getArea())) continue;
                                sjCqEvent.setDutyJobId(j.getId());
                            }
                        }
                        if (sjCqEvent.getDutyJobId() == null && StringUtil.isNotEmpty((String)sjCqEvent.getRegionId())) {
                            if (sjCqEvent.getRegionId().indexOf("CQBZ_BGC_F1_011") >= 0) {
                                sjCqEvent.setDutyJobId("1569950581555073024");
                            } else if (sjCqEvent.getRegionId().indexOf("CQBZ_TL") >= 0) {
                                sjCqEvent.setDutyJobId("1568250985745354752");
                            } else if (sjCqEvent.getRegionId().indexOf("CQBZ") >= 0) {
                                sjCqEvent.setDutyJobId("1568213830826332160");
                            }
                        } else {
                            sjCqEvent.setDutyJobId("1569950465930694656");
                        }
                        this.dwdSjCqEventDao.insert((Object)sjCqEvent);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    private void syncHoliday() {
        if (finishSyncHoliday) {
            return;
        }
        finishSyncHoliday = true;
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("key", "b9bd81f0d27995863f2104a68259a02a");
                this.put("type", 1);
            }
        };
        int currentYear = Calendar.getInstance().get(1);
        for (int i = 0; i < 3; ++i) {
            param.put("date", currentYear - i);
            String url = "http://api.tianapi.com/jiejiari/index";
            String response = HttpUtil.get((String)url, (Map)param);
            JSONObject resObj = JSONUtil.parseObj((String)response);
            System.out.println(new Date() + "===========jobDataMap===syncHoliday===resObj======" + resObj);
            int code = (Integer)resObj.get((Object)"code");
            if (code != 200) continue;
            JSONArray newslist = (JSONArray)resObj.get((Object)"newslist");
            for (Object listObj : newslist) {
                JSONObject obj = (JSONObject)listObj;
                String holidays = (String)obj.get((Object)"vacation");
                String[] holidayArray = holidays.split("\\|");
                for (int k = 0; k < holidayArray.length; ++k) {
                    int count = this.dwdSjFestivalHolidayDao.selectCount((Wrapper)new QueryWrapper().eq((Object)"vacation_date_", (Object)holidayArray[k]));
                    System.out.println(new Date() + "===========jobDataMap===syncHoliday===resObj====count==" + count);
                    if (count != 0) continue;
                    DwdSjFestivalHoliday h = new DwdSjFestivalHoliday();
                    h.setVacationDate(holidayArray[k]);
                    h.setContent(obj.toStringPretty());
                    h.setHoliday(obj.getStr((Object)"holiday"));
                    h.setName(obj.getStr((Object)"name"));
                    h.setTip(obj.getStr((Object)"tip"));
                    h.setRest(obj.getStr((Object)"rest"));
                    h.setSn(k);
                    this.dwdSjFestivalHolidayDao.insert((Object)h);
                }
            }
        }
    }
}

