/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.EnableStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dao.DeviceWarnConfDao;
import com.artfess.device.base.manager.DeviceWarnConfDetailsManager;
import com.artfess.device.base.manager.DeviceWarnConfManager;
import com.artfess.device.base.model.DeviceWarnConf;
import com.artfess.device.base.model.DeviceWarnConfDetails;
import com.artfess.redis.util.RedisUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DeviceWarnConfManagerImpl
extends BaseManagerImpl<DeviceWarnConfDao, DeviceWarnConf>
implements DeviceWarnConfManager {
    @Autowired
    private DeviceWarnConfDetailsManager detailsManager;
    @Autowired
    private RedisUtil redisUtil;

    public PageList<DeviceWarnConf> query(QueryFilter<DeviceWarnConf> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceWarnConf> result = ((DeviceWarnConfDao)this.baseMapper).queryPage((IPage<DeviceWarnConf>)this.convert2IPage(pageBean), (Wrapper<DeviceWarnConf>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List detailsList = this.detailsManager.list();
        result.getRecords().forEach(r -> {
            ArrayList<DeviceWarnConfDetails> details = new ArrayList<DeviceWarnConfDetails>();
            detailsList.forEach(d -> {
                if (r.getId().equals(d.getDeviceWarnConfId())) {
                    details.add((DeviceWarnConfDetails)((Object)((Object)d)));
                }
            });
            r.setDetails(details);
        });
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"sys:cache:warn"}, allEntries=true)
    public String createInfo(DeviceWarnConf t) {
        this.vaild(t);
        int i = ((DeviceWarnConfDao)this.baseMapper).insert((Object)t);
        if (i > 0) {
            this.redisUtil.delLike("sys:cache:warn:");
            this.processDetails(t.getId(), t.getDetails());
            return t.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"sys:cache:warn"}, allEntries=true)
    public String updateInfo(DeviceWarnConf t) {
        this.vaild(t);
        int i = ((DeviceWarnConfDao)this.baseMapper).updateById((Object)t);
        if (i > 0) {
            this.redisUtil.delLike("sys:cache:warn:");
            this.processDetails(t.getId(), t.getDetails());
            return t.getId();
        }
        return null;
    }

    @Override
    public DeviceWarnConf findById(String id) {
        DeviceWarnConf entity = (DeviceWarnConf)((Object)this.getById((Serializable)((Object)id)));
        if (null == entity) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"device_warn_conf_id_", (Object)id);
        List deviceWarnConfs = this.detailsManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        entity.setDetails(deviceWarnConfs);
        return entity;
    }

    @Override
    public boolean modifyEnabled(DeviceWarnConf t) {
        DeviceWarnConf entity = (DeviceWarnConf)((Object)this.getById((Serializable)((Object)t.getId())));
        if (null == entity) {
            return false;
        }
        entity.setStatus(EnableStatusEnum.Y.getType().equals(entity.getStatus()) ? EnableStatusEnum.N.getType() : EnableStatusEnum.Y.getType());
        entity.setUpdateTime(LocalDateTime.now());
        boolean b = this.saveOrUpdate((Object)entity);
        return b;
    }

    private void processDetails(String id, List<DeviceWarnConfDetails> list) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"device_warn_conf_id_", (Object)id);
        this.detailsManager.getBaseMapper().delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(details -> {
            details.setDeviceWarnConfId(id);
            this.detailsManager.getBaseMapper().insert((Object)details);
        });
    }

    public void vaild(DeviceWarnConf t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)t.getId())) {
            queryWrapper.ne((Object)"id_", (Object)t.getId());
        }
        ((QueryWrapper)queryWrapper.eq((Object)"warn_name_", (Object)t.getWarnName())).eq((Object)"product_conf_id_", (Object)t.getProductConfId());
        List functions = ((DeviceWarnConfDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)functions)) {
            throw new IllegalArgumentException("\u9884\u8b66\u540d\u79f0\u5df2\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
    }
}

