/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.def.graph.ilog;

import com.artfess.activiti.def.graph.ilog.Link;
import com.artfess.activiti.def.graph.ilog.OrthogonalType;
import com.artfess.activiti.def.graph.ilog.Point;
import com.artfess.activiti.def.graph.ilog.Port;
import com.artfess.activiti.def.graph.ilog.PortType;
import com.artfess.activiti.def.graph.ilog.Shape;
import com.artfess.activiti.def.graph.ilog.ShapeType;
import com.artfess.base.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformUtil {
    public static int Offset = 24;
    public static int minLen = 4;
    protected static Logger logger = LoggerFactory.getLogger(TransformUtil.class);

    private static List<Point> calcLinkPoints(Link link) {
        ArrayList<Point> points = new ArrayList();
        switch (link.getShapeType()) {
            case STRAIGHT: {
                points = TransformUtil.calcStraightLinkPoints(link);
                break;
            }
            case FREE: {
                points = TransformUtil.calcFreeLinkPoints(link);
                break;
            }
            case OBLIQUE: {
                points = TransformUtil.calcOrthogonalLinkPoints(link);
                break;
            }
            case ORTHOGONAL: {
                points = TransformUtil.calcOrthogonalLinkPoints(link);
                break;
            }
            default: {
                points = TransformUtil.calcOrthogonalLinkPoints(link);
            }
        }
        return points;
    }

    private static List<Point> calcOrthogonalLinkPoints(Link link) {
        ArrayList<Point> points = new ArrayList<Point>();
        Shape startNode = link.getStartNode();
        Shape endNode = link.getEndNode();
        Port startPort = link.getStartPort();
        Port endPort = link.getEndPort();
        OrthogonalType type = TransformUtil.calcOrthogonalLinkRelativPosition(startNode, endNode, startPort, endPort);
        switch (type) {
            case TopTop: {
                logger.info("Top Top");
                points = TransformUtil.caculateTopTop(startNode, endNode, startPort, endPort);
                break;
            }
            case TopLeft: {
                logger.info("Top Left");
                points = TransformUtil.caculateTopLeft(startNode, endNode, startPort, endPort);
                break;
            }
            case TopRight: {
                logger.info("Top Right");
                points = TransformUtil.caculateTopRight(startNode, endNode, startPort, endPort);
                break;
            }
            case TopBottom: {
                logger.info("Top Bottom");
                points = TransformUtil.caculateTopBottom(startNode, endNode, startPort, endPort);
                break;
            }
            case LeftTop: {
                logger.info(" Left Top ");
                points = TransformUtil.caculateLeftTop(startNode, endNode, startPort, endPort);
                break;
            }
            case LeftLeft: {
                logger.info(" Left Left ");
                points = TransformUtil.caculateLeftLeft(startNode, endNode, startPort, endPort);
                break;
            }
            case LeftRight: {
                logger.info(" Left Right ");
                points = TransformUtil.caculateLeftRight(startNode, endNode, startPort, endPort);
                break;
            }
            case LeftBottom: {
                logger.info(" Left Bottom ");
                points = TransformUtil.caculateLeftBottom(startNode, endNode, startPort, endPort);
                break;
            }
            case RightTop: {
                logger.info(" Right Top ");
                points = TransformUtil.caculateRightTop(startNode, endNode, startPort, endPort);
                break;
            }
            case RightLeft: {
                logger.info(" Right Left ");
                points = TransformUtil.caculateRightLeft(startNode, endNode, startPort, endPort);
                break;
            }
            case RightRight: {
                logger.info(" Right Right ");
                points = TransformUtil.caculateRightRight(startNode, endNode, startPort, endPort);
                break;
            }
            case RightBottom: {
                logger.info(" Right Bottom ");
                points = TransformUtil.caculateRightBottom(startNode, endNode, startPort, endPort);
                break;
            }
            case BottomTop: {
                logger.info(" Bottom Top ");
                points = TransformUtil.caculateBottomTop(startNode, endNode, startPort, endPort);
                break;
            }
            case BottomLeft: {
                logger.info(" Bottom Left ");
                points = TransformUtil.caculateBottomLeft(startNode, endNode, startPort, endPort);
                break;
            }
            case BottomRight: {
                logger.info(" Bottom Right ");
                points = TransformUtil.caculateBottomRight(startNode, endNode, startPort, endPort);
                break;
            }
            case BottomBottom: {
                logger.info(" Bottom Bottom ");
                points = TransformUtil.caculateBottomBottom(startNode, endNode, startPort, endPort);
            }
        }
        return points;
    }

    private static OrthogonalType calcOrthogonalLinkRelativPosition(Shape source, Shape target, Port startPort, Port endPort) {
        double startx = (double)source.getX() + (double)source.getW() * startPort.getX() + startPort.getHorizontalOffset();
        double starty = (double)source.getY() + (double)source.getH() * startPort.getY() + startPort.getVerticalOffset();
        Point start = new Point((float)startx, (float)starty);
        double endx = (double)target.getX() + (double)target.getW() * endPort.getX() + endPort.getHorizontalOffset();
        double endy = (double)target.getY() + (double)target.getH() * endPort.getY() + endPort.getVerticalOffset();
        Point end = new Point((float)endx, (float)endy);
        Point splt = new Point(source.getX(), source.getY());
        Point sprt = new Point(source.getX() + source.getW(), source.getY());
        Point sprb = new Point(source.getX() + source.getW(), source.getY() + source.getH());
        Point splb = new Point(source.getX(), source.getY() + source.getH());
        Point spc = new Point(source.getX() + source.getW() / 2.0f, source.getY() + source.getH() / 2.0f);
        Point tplt = new Point(target.getX(), target.getY());
        Point tprt = new Point(target.getX() + target.getW(), target.getY());
        Point tprb = new Point(target.getX() + target.getW(), target.getY() + target.getH());
        Point tplb = new Point(target.getX(), target.getY() + target.getH());
        Point tpc = new Point(target.getX() + target.getW() / 2.0f, target.getY() + target.getH() / 2.0f);
        if (TransformUtil.isInsideTriangle(splt, sprt, spc, start)) {
            if (TransformUtil.isInsideTriangle(tplt, tprt, tpc, end)) {
                return OrthogonalType.TopTop;
            }
            if (TransformUtil.isInsideTriangle(tprt, tprb, tpc, end)) {
                return OrthogonalType.TopRight;
            }
            if (TransformUtil.isInsideTriangle(tprb, tplb, tpc, end)) {
                return OrthogonalType.TopBottom;
            }
            if (TransformUtil.isInsideTriangle(tplb, tplt, tpc, end)) {
                return OrthogonalType.TopLeft;
            }
        } else if (TransformUtil.isInsideTriangle(sprt, sprb, spc, start)) {
            if (TransformUtil.isInsideTriangle(tplt, tprt, tpc, end)) {
                return OrthogonalType.RightTop;
            }
            if (TransformUtil.isInsideTriangle(tprt, tprb, tpc, end)) {
                return OrthogonalType.RightRight;
            }
            if (TransformUtil.isInsideTriangle(tprb, tplb, tpc, end)) {
                return OrthogonalType.RightBottom;
            }
            if (TransformUtil.isInsideTriangle(tplb, tplt, tpc, end)) {
                return OrthogonalType.RightLeft;
            }
        } else if (TransformUtil.isInsideTriangle(sprb, splb, spc, start)) {
            if (TransformUtil.isInsideTriangle(tplt, tprt, tpc, end)) {
                return OrthogonalType.BottomTop;
            }
            if (TransformUtil.isInsideTriangle(tprt, tprb, tpc, end)) {
                return OrthogonalType.BottomRight;
            }
            if (TransformUtil.isInsideTriangle(tprb, tplb, tpc, end)) {
                return OrthogonalType.BottomBottom;
            }
            if (TransformUtil.isInsideTriangle(tplb, tplt, tpc, end)) {
                return OrthogonalType.BottomLeft;
            }
        } else if (TransformUtil.isInsideTriangle(splb, splt, spc, start)) {
            if (TransformUtil.isInsideTriangle(tplt, tprt, tpc, end)) {
                return OrthogonalType.LeftTop;
            }
            if (TransformUtil.isInsideTriangle(tprt, tprb, tpc, end)) {
                return OrthogonalType.LeftRight;
            }
            if (TransformUtil.isInsideTriangle(tprb, tplb, tpc, end)) {
                return OrthogonalType.LeftBottom;
            }
            if (TransformUtil.isInsideTriangle(tplb, tplt, tpc, end)) {
                return OrthogonalType.LeftLeft;
            }
        }
        return OrthogonalType.RightLeft;
    }

    private static boolean isInsideTriangle(Point A, Point B, Point C, Point P) {
        float ab = (A.getX() - P.getX()) * (B.getY() - P.getY()) - (B.getX() - P.getX()) * (A.getY() - P.getY());
        float bc = (B.getX() - P.getX()) * (C.getY() - P.getY()) - (C.getX() - P.getX()) * (B.getY() - P.getY());
        float ca = (C.getX() - P.getX()) * (A.getY() - P.getY()) - (A.getX() - P.getX()) * (C.getY() - P.getY());
        return (ab >= 0.0f && bc >= 0.0f || ab <= 0.0f && bc <= 0.0f) && (bc >= 0.0f && ca >= 0.0f || bc <= 0.0f && ca <= 0.0f);
    }

    private static List<Point> calcStraightLinkPoints(Link link) {
        link.getIntermediatePoints().clear();
        return TransformUtil.calcFreeLinkPoints(link);
    }

    private static List<Point> calcFreeLinkPoints(Link link) {
        ArrayList<Point> points = new ArrayList<Point>();
        Shape startNode = link.getStartNode();
        Shape endNode = link.getEndNode();
        Port startPort = link.getStartPort();
        Port endPort = link.getEndPort();
        List<Point> intermediatePoints = link.getIntermediatePoints();
        double firstX = (double)startNode.getX() + (double)startNode.getW() * startPort.getX() + startPort.getHorizontalOffset();
        double firstY = (double)startNode.getY() + (double)startNode.getH() * startPort.getY() + startPort.getVerticalOffset();
        Point first = new Point((float)firstX, (float)firstY);
        double lastX = (double)endNode.getX() + (double)endNode.getW() * endPort.getX() + endPort.getHorizontalOffset();
        double lastY = (double)endNode.getY() + (double)endNode.getH() * endPort.getY() + endPort.getVerticalOffset();
        Point last = new Point((float)lastX, (float)lastY);
        Point temp1 = intermediatePoints.size() > 0 ? intermediatePoints.get(0) : last;
        Point temp2 = intermediatePoints.size() > 0 ? intermediatePoints.get(intermediatePoints.size() - 1) : first;
        Point temp3 = null;
        Point temp4 = null;
        temp3 = TransformUtil.handleOverlap(startNode, first, temp1);
        temp4 = TransformUtil.handleOverlap(endNode, last, temp2);
        points.add(temp3 == null ? first : temp3);
        points.addAll(intermediatePoints);
        points.add(temp4 == null ? last : temp4);
        return points;
    }

    private static Point handleOverlap(Shape shape, Point p1, Point p2) {
        Point a = new Point(shape.getX(), shape.getY());
        Point b = new Point(shape.getX() + shape.getW(), shape.getY());
        Point c = new Point(shape.getX() + shape.getW(), shape.getY() + shape.getH());
        Point d = new Point(shape.getX(), shape.getY() + shape.getH());
        Point[] cps = new Point[4];
        if (!TransformUtil.isInsideLine(a, b, p1)) {
            cps[0] = TransformUtil.getCrosspoint(p1, p2, a, b);
        }
        if (!TransformUtil.isInsideLine(b, c, p1)) {
            cps[1] = TransformUtil.getCrosspoint(p1, p2, b, c);
        }
        if (!TransformUtil.isInsideLine(c, d, p1)) {
            cps[2] = TransformUtil.getCrosspoint(p1, p2, c, d);
        }
        if (!TransformUtil.isInsideLine(d, a, p1)) {
            cps[3] = TransformUtil.getCrosspoint(p1, p2, d, a);
        }
        for (Point p : cps) {
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private static boolean isInsideLine(Point p1, Point p2, Point p) {
        double x = p.getX();
        double y = p.getY();
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        if (Double.compare(x1, x2) == 0) {
            return Double.compare(x, x2) == 0;
        }
        if (Double.compare(y1, y2) == 0) {
            return Double.compare(y, y2) == 0;
        }
        double s1 = x - x1;
        double s2 = x1 - x2;
        double t1 = y - y1;
        double t2 = y1 - y2;
        return Double.compare(s1 / s2, t1 / t2) == 0;
    }

    private static Point getCrosspoint(Point a, Point b, Point c, Point d) {
        float ax = a.getX();
        float ay = a.getY();
        float bx = b.getX();
        float by = b.getY();
        float cx = c.getX();
        float cy = c.getY();
        float dx = d.getX();
        float dy = d.getY();
        if (Math.abs(by - ay) + Math.abs(bx - ax) + Math.abs(dy - cy) + Math.abs(dx - cx) == 0.0f) {
            if (cx - ax + (cy - ay) == 0.0f) {
                return new Point(ax, ay);
            }
            return null;
        }
        if (Math.abs(by - ay) + Math.abs(bx - ax) == 0.0f) {
            if ((ax - dx) * (cy - dy) - (ay - dy) * (cx - dx) == 0.0f) {
                return new Point(ax, ay);
            }
            return null;
        }
        if (Math.abs(dy - cy) + Math.abs(dx - cx) == 0.0f) {
            if ((dx - bx) * (ay - by) - (dy - by) * (ax - bx) == 0.0f) {
                return new Point(cx, cy);
            }
            return null;
        }
        if ((by - ay) * (cx - dx) - (bx - ax) * (cy - dy) == 0.0f) {
            return null;
        }
        float x = ((bx - ax) * (cx - dx) * (cy - ay) - cx * (bx - ax) * (cy - dy) + ax * (by - ay) * (cx - dx)) / ((by - ay) * (cx - dx) - (bx - ax) * (cy - dy));
        float y = ((by - ay) * (cy - dy) * (cx - ax) - cy * (by - ay) * (cx - dx) + ay * (bx - ax) * (cy - dy)) / ((bx - ax) * (cy - dy) - (by - ay) * (cx - dx));
        if ((x - ax) * (x - bx) <= 0.0f && (x - cx) * (x - dx) <= 0.0f && (y - ay) * (y - by) <= 0.0f && (y - cy) * (y - dy) <= 0.0f) {
            return new Point(x, y);
        }
        return null;
    }

    public static String add(String para1, String para2) {
        double d1 = 0.0;
        double d2 = 0.0;
        if (StringUtil.isNotEmpty((String)para1)) {
            d1 = Double.parseDouble(para1);
        }
        if (StringUtil.isNotEmpty((String)para2)) {
            d2 = Double.parseDouble(para2);
        }
        return String.valueOf(d1 += d2);
    }

    public static String bold(String str) {
        return "<b>" + str + "</b>";
    }

    public static double nan2Zero(String str) {
        if (StringUtil.isEmpty((String)str) || str.equalsIgnoreCase("NaN")) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public static void display(String str) {
        logger.info(str);
    }

    public static int splitLength(String str, String regex) {
        int len = str.split(regex).length;
        return len;
    }

    public static String accumulate(String childrenY, String parentY) {
        double retVal = 0.0;
        if (!StringUtil.isEmpty((String)childrenY)) {
            String[] childrenY_;
            for (String y : childrenY_ = childrenY.split(",")) {
                retVal += TransformUtil.nan2Zero(y);
            }
        }
        if (StringUtil.isNotEmpty((String)parentY)) {
            retVal += TransformUtil.nan2Zero(parentY);
        }
        return String.valueOf(retVal);
    }

    public static String min(String para1, String para2) {
        double d1 = 0.0;
        double d2 = 0.0;
        if (StringUtil.isNotEmpty((String)para1)) {
            d1 = Double.parseDouble(para1);
        }
        if (StringUtil.isNotEmpty((String)para2)) {
            d2 = Double.parseDouble(para2);
        }
        if (d1 < d2) {
            return String.valueOf(d1);
        }
        return String.valueOf(d2);
    }

    public static String max(String para1, String para2) {
        Integer d1 = 0;
        Integer d2 = 0;
        if (StringUtil.isNotEmpty((String)para1)) {
            d1 = Integer.parseInt(para1);
        }
        if (StringUtil.isNotEmpty((String)para2)) {
            d2 = Integer.parseInt(para2);
        }
        if (d1 > d2) {
            return String.valueOf(d1);
        }
        return String.valueOf(d2);
    }

    public static String calc(String shapeType, String fName, String fX, String fY, String fW, String fH, String sPortType, String sPortX, String sPortY, String sPortHOffset, String sPortVOffset, String tName, String tX, String tY, String tW, String tH, String tPortType, String tPortX, String tPortY, String tPortHOffset, String tPortVOffset, String points) {
        sPortX = "".equals(sPortX) || sPortX == null ? "0.5" : sPortX;
        sPortY = "".equals(sPortY) || sPortY == null ? "0.5" : sPortY;
        tPortX = "".equals(tPortX) || tPortX == null ? "0.5" : tPortX;
        tPortY = "".equals(tPortY) || tPortY == null ? "0.5" : tPortY;
        Link link = new Link();
        if (ShapeType.FREE.getText().equalsIgnoreCase(shapeType)) {
            link.setShapeType(ShapeType.FREE);
        } else if (ShapeType.STRAIGHT.getText().equalsIgnoreCase(shapeType)) {
            link.setShapeType(ShapeType.STRAIGHT);
        } else if (ShapeType.OBLIQUE.getText().equalsIgnoreCase(shapeType)) {
            link.setShapeType(ShapeType.OBLIQUE);
        } else {
            link.setShapeType(ShapeType.ORTHOGONAL);
        }
        float startX = (float)TransformUtil.nan2Zero(fX);
        float startY = (float)TransformUtil.nan2Zero(fY);
        float startW = (float)TransformUtil.nan2Zero(fW);
        float startH = (float)TransformUtil.nan2Zero(fH);
        Shape startShape = new Shape(fName, startX, startY, startW, startH);
        float endX = (float)TransformUtil.nan2Zero(tX);
        float endY = (float)TransformUtil.nan2Zero(tY);
        float endW = (float)TransformUtil.nan2Zero(tW);
        float endH = (float)TransformUtil.nan2Zero(tH);
        Shape endShape = new Shape(tName, endX, endY, endW, endH);
        PortType startPortType = PortType.NODE_PART_REFERENCE.getText().equalsIgnoreCase(sPortType) ? PortType.NODE_PART_REFERENCE : (PortType.AUTOMATIC_SIDE.getText().equalsIgnoreCase(sPortType) ? PortType.AUTOMATIC_SIDE : PortType.POSITION);
        float startPortX = (float)TransformUtil.nan2Zero(sPortX);
        float startPortY = (float)TransformUtil.nan2Zero(sPortY);
        float startPortVOffset = (float)TransformUtil.nan2Zero(sPortVOffset);
        float startPortHOffset = (float)TransformUtil.nan2Zero(sPortHOffset);
        Port startPort = new Port(startPortType, startPortX, startPortY, startPortHOffset, startPortVOffset, null, false);
        PortType endPortType = PortType.NODE_PART_REFERENCE.getText().equalsIgnoreCase(tPortType) ? PortType.NODE_PART_REFERENCE : (PortType.AUTOMATIC_SIDE.getText().equalsIgnoreCase(tPortType) ? PortType.AUTOMATIC_SIDE : PortType.POSITION);
        float endPortX = (float)TransformUtil.nan2Zero(tPortX);
        float endPortY = (float)TransformUtil.nan2Zero(tPortY);
        float endPortVOffset = (float)TransformUtil.nan2Zero(tPortVOffset);
        float endPortHOffset = (float)TransformUtil.nan2Zero(tPortHOffset);
        Port endPort = new Port(endPortType, endPortX, endPortY, endPortHOffset, endPortVOffset, null, false);
        ArrayList<Point> intermediatePoints = new ArrayList<Point>();
        if (points != null && !"".equals(points)) {
            String[] pointAry;
            for (String p : pointAry = points.split(",")) {
                String[] point = p.split(":");
                double x = TransformUtil.nan2Zero(point[0]);
                double y = TransformUtil.nan2Zero(point[1]);
                intermediatePoints.add(new Point((float)x, (float)y));
            }
        }
        link.setStartNode(startShape);
        link.setEndNode(endShape);
        link.setStartPort(startPort);
        link.setEndPort(endPort);
        link.setIntermediatePoints(intermediatePoints);
        List<Point> linkPoints = TransformUtil.calcLinkPoints(link);
        return TransformUtil.getPointXml(linkPoints);
    }

    public static List<Point> caculatePoints(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = null;
        block0 : switch (fromShape.getDirectory()) {
            case Top: {
                switch (toShape.getDirectory()) {
                    case Top: {
                        logger.info("Top Top");
                        list = TransformUtil.caculateTopTop(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Left: {
                        logger.info("Top Left");
                        list = TransformUtil.caculateTopLeft(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Right: {
                        logger.info("Top Right");
                        list = TransformUtil.caculateTopRight(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Bottom: {
                        logger.info("Top Bottom");
                        list = TransformUtil.caculateTopBottom(fromShape, toShape, fromPort, toPort);
                    }
                }
                break;
            }
            case Left: {
                switch (toShape.getDirectory()) {
                    case Top: {
                        logger.info(" Left Top ");
                        list = TransformUtil.caculateLeftTop(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Left: {
                        logger.info(" Left Left ");
                        list = TransformUtil.caculateLeftLeft(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Right: {
                        logger.info(" Left Right ");
                        list = TransformUtil.caculateLeftRight(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Bottom: {
                        logger.info(" Left Bottom ");
                        list = TransformUtil.caculateLeftBottom(fromShape, toShape, fromPort, toPort);
                    }
                }
                break;
            }
            case Right: {
                switch (toShape.getDirectory()) {
                    case Top: {
                        logger.info(" Right Top ");
                        list = TransformUtil.caculateRightTop(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Left: {
                        logger.info(" Right Left ");
                        list = TransformUtil.caculateRightLeft(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Right: {
                        logger.info(" Right Right ");
                        list = TransformUtil.caculateRightRight(fromShape, toShape, fromPort, toPort);
                        break;
                    }
                    case Bottom: {
                        logger.info(" Right Bottom ");
                        list = TransformUtil.caculateRightBottom(fromShape, toShape, fromPort, toPort);
                    }
                }
                break;
            }
            case Bottom: {
                switch (toShape.getDirectory()) {
                    case Top: {
                        logger.info(" Bottom Top ");
                        list = TransformUtil.caculateBottomTop(fromShape, toShape, fromPort, toPort);
                        break block0;
                    }
                    case Left: {
                        logger.info(" Bottom Left ");
                        list = TransformUtil.caculateBottomLeft(fromShape, toShape, fromPort, toPort);
                        break block0;
                    }
                    case Right: {
                        logger.info(" Bottom Right ");
                        list = TransformUtil.caculateBottomRight(fromShape, toShape, fromPort, toPort);
                        break block0;
                    }
                    case Bottom: {
                        logger.info(" Bottom Bottom ");
                        list = TransformUtil.caculateBottomBottom(fromShape, toShape, fromPort, toPort);
                    }
                }
            }
        }
        return list;
    }

    public static String caculate(Shape fromShape, Shape toShape) {
        return null;
    }

    public static ArrayList<Point> caculateTopTop(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getBottomRightY() + (float)minLen < fromShape.getY() - (float)minLen) {
            if (toShape.getX() - (float)minLen > fromX || toShape.getBottomRightX() + (float)minLen < fromX) {
                float tmpy = toShape.getY() - (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(toX, tmpy);
                Point p4 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
            } else {
                float tmpx = 0.0f;
                float tmpy = (fromShape.getY() + toShape.getBottomRightY()) / 2.0f;
                tmpx = toX <= fromX ? toShape.getBottomRightX() + (float)Offset : toShape.getX() - (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(tmpx, toY - (float)Offset);
                Point p5 = new Point(toX, toY - (float)Offset);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            }
        } else if (toShape.getY() - (float)minLen < fromShape.getBottomRightY() + (float)minLen) {
            float tmpy = toShape.getY() - (float)Offset;
            tmpy = toShape.getY() < fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(toX, tmpy);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        } else if (fromShape.getX() - (float)minLen > toX || fromShape.getBottomRightX() + (float)minLen < toX) {
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, fromY - (float)Offset);
            Point p3 = new Point(toX, fromY - (float)Offset);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        } else {
            float tmpy = (fromShape.getBottomRightY() + toShape.getY()) / 2.0f;
            float tmpx = 0.0f;
            tmpx = fromX <= toX ? fromShape.getBottomRightX() + (float)Offset : fromShape.getX() - (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, fromY - (float)Offset);
            Point p3 = new Point(tmpx, fromY - (float)Offset);
            Point p4 = new Point(tmpx, tmpy);
            Point p5 = new Point(toX, tmpy);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        }
        return list;
    }

    public static ArrayList<Point> caculateTopRight(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (fromX >= toX - (float)minLen) {
            if (toY < fromY - (float)minLen) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, toY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else if (toX + (float)minLen < fromShape.getX() - (float)minLen) {
                float tmpx = (fromShape.getX() + toX) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, fromY - (float)Offset);
                Point p3 = new Point(tmpx, fromY - (float)Offset);
                Point p4 = new Point(tmpx, toY);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            } else {
                float tmpy = 0.0f;
                tmpy = toShape.getY() < fromY ? toShape.getY() - (float)Offset : fromY - (float)Offset;
                float tmpx = fromShape.getBottomRightX() + (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(tmpx, toY);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (toShape.getBottomRightY() + (float)minLen < fromY - (float)minLen) {
            float tmpy = (fromY + toShape.getBottomRightY()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(toX + (float)Offset, tmpy);
            Point p4 = new Point(toX + (float)Offset, toY);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        } else {
            float tmpy = 0.0f;
            float tmpx = 0.0f;
            Point p1 = new Point(fromX, fromY);
            tmpx = toX + (float)Offset >= fromShape.getBottomRightX() + (float)Offset ? toX + (float)Offset : fromShape.getBottomRightX() + (float)Offset;
            tmpy = toShape.getY() - (float)Offset <= fromY - (float)Offset ? toShape.getY() - (float)Offset : fromY - (float)Offset;
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(tmpx, toY);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        }
        return list;
    }

    public static ArrayList<Point> caculateTopBottom(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (fromX < toX) {
            if (toY + (float)minLen <= fromY - (float)minLen) {
                float tmpy = (fromY + toY) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(toX, tmpy);
                Point p4 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
            } else if (fromShape.getBottomRightX() + (float)minLen < toShape.getX() - (float)minLen) {
                float tmpx = (toShape.getX() + fromShape.getBottomRightX()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, fromY - (float)Offset);
                Point p3 = new Point(tmpx, fromY - (float)Offset);
                Point p4 = new Point(tmpx, toY + (float)Offset);
                Point p5 = new Point(toX, toY + (float)Offset);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            } else {
                float tmpy = fromShape.getY() <= toShape.getY() ? fromShape.getY() - (float)Offset : toShape.getY() - (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(toShape.getBottomRightX() + (float)Offset, tmpy);
                Point p4 = new Point(toShape.getBottomRightX() + (float)Offset, toY + (float)Offset);
                Point p5 = new Point(toX, toY + (float)Offset);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            }
        } else if (fromX == toX) {
            if (toY + (float)minLen < fromY - (float)minLen) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
            } else {
                float tmpy = fromShape.getY() < toShape.getY() ? fromShape.getY() - (float)Offset : toShape.getY() - (float)Offset;
                float tmpx = fromShape.getX() < toShape.getX() ? fromShape.getX() - (float)Offset : toShape.getX() - (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(tmpx, toY + (float)Offset);
                Point p5 = new Point(toX, toY + (float)Offset);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            }
        } else if (toY + (float)minLen < fromY - (float)minLen) {
            float tmpy = (fromY + toY) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(toX, tmpy);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        } else if (toShape.getBottomRightX() + (float)minLen < fromShape.getX() - (float)minLen) {
            float tmpx = (fromShape.getX() + toShape.getBottomRightX()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, fromY - (float)Offset);
            Point p3 = new Point(tmpx, fromY - (float)Offset);
            Point p4 = new Point(tmpx, toY + (float)Offset);
            Point p5 = new Point(toX, toY + (float)Offset);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        } else {
            float tmpy = fromShape.getY() < toShape.getY() ? fromShape.getY() - (float)Offset : toShape.getY() - (float)Offset;
            float tmpx = fromShape.getX() < toShape.getX() ? fromShape.getX() - (float)Offset : toShape.getX() - (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(tmpx, toY + (float)Offset);
            Point p5 = new Point(toX, toY + (float)Offset);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        }
        return list;
    }

    public static ArrayList<Point> caculateTopLeft(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getX() - (float)minLen > fromX) {
            if (toY < fromShape.getY() - (float)minLen) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, toY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else if (fromShape.getBottomRightX() + (float)minLen < toShape.getX() - (float)minLen) {
                float tmpx = (toShape.getX() + fromShape.getBottomRightX()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, fromY - (float)Offset);
                Point p3 = new Point(tmpx, fromY - (float)Offset);
                Point p4 = new Point(tmpx, toY);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            } else {
                float tmpy = 0.0f;
                float tmpx = 0.0f;
                tmpy = toShape.getY() <= fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset;
                tmpx = toShape.getX() <= fromShape.getX() ? toShape.getX() - (float)Offset : fromShape.getX() - (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(tmpx, toY);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (fromShape.getY() - (float)minLen >= toShape.getBottomRightY() + (float)minLen) {
            float tmpy = (fromShape.getY() + toShape.getBottomRightY()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(toX - (float)Offset, tmpy);
            Point p4 = new Point(toX - (float)Offset, toY);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        } else {
            float tmpy = 0.0f;
            float tmpx = 0.0f;
            tmpy = toShape.getY() < fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset;
            tmpx = toShape.getX() < fromShape.getX() ? toShape.getX() - (float)Offset : fromShape.getX() - (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(tmpx, toY);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        }
        return list;
    }

    public static ArrayList<Point> caculateRightTop(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (fromShape.getBottomRightX() + (float)minLen < toShape.getX() - (float)minLen) {
            if (fromY > toShape.getY() + (float)minLen) {
                float tmpx = (toShape.getX() + fromX) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, toY - (float)Offset);
                Point p4 = new Point(toX, toY - (float)Offset);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            } else {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX, fromY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            }
        } else if (toShape.getY() - (float)minLen < fromY) {
            float tmpy = 0.0f;
            float tmpx = 0.0f;
            tmpy = toShape.getY() < fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset;
            tmpx = toShape.getBottomRightX() >= fromShape.getBottomRightX() ? toShape.getBottomRightX() + (float)Offset : fromShape.getBottomRightX() + (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(tmpx, fromY);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(toX, tmpy);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        } else if (toShape.getY() - (float)minLen < fromShape.getBottomRightY() + (float)minLen) {
            if (toX > fromShape.getBottomRightX() + (float)minLen) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX, fromY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else {
                float tmpy = 0.0f;
                float tmpx = 0.0f;
                tmpy = toShape.getY() < fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset;
                tmpx = toShape.getBottomRightX() >= fromShape.getBottomRightX() ? toShape.getBottomRightX() + (float)Offset : fromShape.getBottomRightX() + (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(toX, tmpy);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (toX > fromShape.getBottomRightX() + (float)minLen) {
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(toX, fromY);
            Point p3 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
        } else {
            float tmpy = (fromShape.getBottomRightY() + toShape.getY()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX + (float)Offset, fromY);
            Point p3 = new Point(fromX + (float)Offset, tmpy);
            Point p4 = new Point(toX, tmpy);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        }
        return list;
    }

    public static ArrayList<Point> caculateRightRight(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getX() - (float)minLen >= fromShape.getBottomRightX() + (float)minLen) {
            if (toShape.getBottomRightY() + (float)minLen < fromY || toShape.getY() - (float)minLen > fromY) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX + (float)Offset, fromY);
                Point p3 = new Point(toX + (float)Offset, toY);
                Point p4 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
            } else {
                float tmpx = (toShape.getX() + fromX) / 2.0f;
                float tmpy = 0.0f;
                tmpy = fromY > toY ? toShape.getBottomRightY() + (float)Offset : toShape.getY() - (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(toX + (float)Offset, tmpy);
                Point p5 = new Point(toX + (float)Offset, toY);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            }
        } else if (toShape.getBottomRightX() + (float)minLen > fromShape.getX() - (float)minLen) {
            float tmpx = 0.0f;
            tmpx = toShape.getBottomRightX() > fromShape.getBottomRightX() ? toShape.getBottomRightX() + (float)Offset : fromShape.getBottomRightX() + (float)Offset;
            if (fromY == toY) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, toY);
                Point p4 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
            }
        } else if (toShape.getBottomRightY() + (float)minLen <= fromShape.getY() - (float)minLen || toShape.getY() - (float)minLen > fromShape.getBottomRightY() + (float)minLen) {
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX + (float)Offset, fromY);
            Point p3 = new Point(fromX + (float)Offset, toY);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        } else {
            float tmpx = (fromShape.getX() + toShape.getBottomRightX()) / 2.0f;
            float tmpy = 0.0f;
            tmpy = fromY <= toY ? fromShape.getBottomRightY() + (float)Offset : fromShape.getY() - (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX + (float)Offset, fromY);
            Point p3 = new Point(fromX + (float)Offset, tmpy);
            Point p4 = new Point(tmpx, tmpy);
            Point p5 = new Point(tmpx, toY);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        }
        return list;
    }

    public static ArrayList<Point> caculateRightBottom(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toX > fromShape.getBottomRightX() + (float)minLen) {
            if (fromY > toY + (float)minLen) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX, fromY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else {
                float tmpx = (fromShape.getBottomRightX() + toShape.getX()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, toY + (float)Offset);
                Point p4 = new Point(toX, toY + (float)Offset);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (toShape.getY() + (float)minLen < fromShape.getY() - (float)minLen) {
            float tmpy = (fromShape.getY() + toShape.getBottomRightY()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX + (float)Offset, fromY);
            Point p3 = new Point(fromX + (float)Offset, tmpy);
            Point p4 = new Point(toX, tmpy);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        } else {
            float tmpx = 0.0f;
            float tmpy = 0.0f;
            tmpx = toShape.getBottomRightX() > fromShape.getBottomRightX() ? toShape.getBottomRightX() + (float)Offset : fromShape.getBottomRightX() + (float)Offset;
            tmpy = toShape.getBottomRightY() < fromShape.getBottomRightY() ? fromShape.getBottomRightY() + (float)Offset : toShape.getBottomRightY() + (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(tmpx, fromY);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(toX, tmpy);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        }
        return list;
    }

    public static ArrayList<Point> caculateRightLeft(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getX() - (float)minLen > fromShape.getBottomRightX() + (float)minLen) {
            if (toY == fromY) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
            } else {
                float tmpx = (fromShape.getBottomRightX() + toShape.getX()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, toY);
                Point p4 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
            }
        } else if (toShape.getBottomRightY() + (float)minLen < fromShape.getY() - (float)minLen || fromShape.getBottomRightY() + (float)minLen < toShape.getY() - (float)minLen) {
            float tmpy = 0.0f;
            tmpy = toShape.getBottomRightY() < fromShape.getBottomRightY() ? (toShape.getBottomRightY() + fromShape.getY()) / 2.0f : (toShape.getY() + fromShape.getBottomRightY()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX + (float)Offset, fromY);
            Point p3 = new Point(fromX + (float)Offset, tmpy);
            Point p4 = new Point(toX - (float)Offset, tmpy);
            Point p5 = new Point(toX - (float)Offset, toY);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        } else {
            float tmpx = 0.0f;
            float tmpy = 0.0f;
            tmpx = toShape.getBottomRightX() > fromShape.getBottomRightX() ? toShape.getBottomRightX() + (float)Offset : fromShape.getBottomRightX() + (float)Offset;
            tmpy = fromY >= toY ? (toShape.getY() < fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset) : (toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset);
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(tmpx, fromY);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(toX - (float)Offset, tmpy);
            Point p5 = new Point(toX - (float)Offset, toY);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        }
        return list;
    }

    public static ArrayList<Point> caculateLeftTop(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getBottomRightX() + (float)minLen >= fromShape.getX() - (float)minLen) {
            if (toShape.getY() - (float)minLen >= fromShape.getBottomRightY() + (float)minLen) {
                if (toX > fromShape.getX()) {
                    float tmpy = (fromShape.getBottomRightY() + toShape.getY()) / 2.0f;
                    Point p1 = new Point(fromX, fromY);
                    Point p2 = new Point(fromX - (float)Offset, fromY);
                    Point p3 = new Point(fromX - (float)Offset, tmpy);
                    Point p4 = new Point(toX, tmpy);
                    Point p5 = new Point(toX, toY);
                    list.add(p1);
                    list.add(p2);
                    list.add(p3);
                    list.add(p4);
                    list.add(p5);
                } else {
                    Point p1 = new Point(fromX, fromY);
                    Point p2 = new Point(toX, fromY);
                    Point p3 = new Point(toX, toY);
                    list.add(p1);
                    list.add(p2);
                    list.add(p3);
                }
            } else if (toShape.getY() - (float)minLen > fromY) {
                if (toX > fromShape.getX()) {
                    float tmpx = 0.0f;
                    float tmpy = 0.0f;
                    tmpx = toShape.getX() >= fromShape.getX() ? fromShape.getX() - (float)Offset : toShape.getX() - (float)Offset;
                    tmpy = toShape.getY() < fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset;
                    Point p1 = new Point(fromX, fromY);
                    Point p2 = new Point(tmpx, fromY);
                    Point p3 = new Point(tmpx, tmpy);
                    Point p4 = new Point(toX, tmpy);
                    Point p5 = new Point(toX, toY);
                    list.add(p1);
                    list.add(p2);
                    list.add(p3);
                    list.add(p4);
                    list.add(p5);
                } else {
                    Point p1 = new Point(fromX, fromY);
                    Point p2 = new Point(toX, fromY);
                    Point p3 = new Point(toX, toY);
                    list.add(p1);
                    list.add(p2);
                    list.add(p3);
                }
            } else {
                float tmpx = 0.0f;
                float tmpy = 0.0f;
                tmpx = toShape.getX() >= fromShape.getX() ? fromShape.getX() - (float)Offset : toShape.getX() - (float)Offset;
                tmpy = toShape.getY() < fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(toX, tmpy);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (toShape.getY() - (float)minLen >= fromY) {
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(toX, fromY);
            Point p3 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
        } else {
            float tmpx = (toShape.getBottomRightX() + fromShape.getX()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(tmpx, fromY);
            Point p3 = new Point(tmpx, toY - (float)Offset);
            Point p4 = new Point(toX, toY - (float)Offset);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        }
        return list;
    }

    public static ArrayList<Point> caculateLeftRight(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getBottomRightX() + (float)minLen <= fromX - (float)minLen) {
            if (fromY == toY) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
            } else {
                float tmpx = (toShape.getBottomRightX() + fromShape.getX()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, toY);
                Point p4 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
            }
        } else if (toShape.getBottomRightY() + (float)minLen <= fromShape.getY() - (float)minLen || toShape.getY() >= fromShape.getBottomRightY() + (float)minLen) {
            float tmpy = 0.0f;
            tmpy = toShape.getBottomRightY() <= fromShape.getY() ? (toShape.getBottomRightY() + fromShape.getY()) / 2.0f : (toShape.getY() + fromShape.getBottomRightY()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX - (float)Offset, fromY);
            Point p3 = new Point(fromX - (float)Offset, tmpy);
            Point p4 = new Point(toX + (float)Offset, tmpy);
            Point p5 = new Point(toX + (float)Offset, toY);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        } else {
            float tmpx = 0.0f;
            float tmpy = 0.0f;
            tmpx = toShape.getX() < fromShape.getX() ? toShape.getX() - (float)Offset : fromX - (float)Offset;
            tmpy = fromY > toY ? (toShape.getY() < fromShape.getY() ? toShape.getY() - (float)Offset : fromShape.getY() - (float)Offset) : (toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset);
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(tmpx, fromY);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(toX + (float)Offset, tmpy);
            Point p5 = new Point(toX + (float)Offset, toY);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        }
        return list;
    }

    public static ArrayList<Point> caculateLeftBottom(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getBottomRightX() + (float)minLen < fromShape.getX() - (float)minLen) {
            if (toShape.getBottomRightY() + (float)minLen <= fromY) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX, fromY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else {
                float tmpx = (toShape.getBottomRightX() + fromShape.getX()) / 2.0f;
                float tmpy = toShape.getBottomRightY() + (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(toX, tmpy);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (toShape.getBottomRightY() + (float)minLen < fromShape.getY() - (float)minLen) {
            if (toX <= fromShape.getX()) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX, fromY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else {
                float tmpy = (toShape.getBottomRightY() + fromShape.getY()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX - (float)Offset, fromY);
                Point p3 = new Point(fromX - (float)Offset, tmpy);
                Point p4 = new Point(toX, tmpy);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (toShape.getBottomRightY() + (float)minLen <= fromY && toX < fromShape.getX() - (float)minLen) {
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(toX, fromY);
            Point p3 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
        } else {
            float tmpx = 0.0f;
            float tmpy = 0.0f;
            tmpx = toShape.getX() < fromShape.getX() ? toShape.getX() - (float)Offset : fromShape.getX() - (float)Offset;
            tmpy = toShape.getBottomRightY() < fromShape.getBottomRightY() ? fromShape.getBottomRightY() + (float)Offset : toShape.getBottomRightY() + (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(tmpx, fromY);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(toX, tmpy);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        }
        return list;
    }

    public static ArrayList<Point> caculateLeftLeft(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getBottomRightX() + (float)minLen < fromShape.getX() - (float)minLen) {
            if (toShape.getBottomRightY() + (float)minLen < fromY || toShape.getY() - (float)minLen > fromY) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(toX - (float)Offset, fromY);
                Point p3 = new Point(toX - (float)Offset, toY);
                Point p4 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
            } else {
                float tmpx = (toShape.getBottomRightX() + fromShape.getX()) / 2.0f;
                float tmpy = 0.0f;
                tmpy = toY >= fromY ? toShape.getY() - (float)Offset : toShape.getBottomRightY() + (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(tmpx, fromY);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(toX - (float)Offset, tmpy);
                Point p5 = new Point(toX - (float)Offset, toY);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            }
        } else if (toShape.getX() - (float)minLen < fromShape.getBottomRightX() + (float)minLen) {
            float tmpx = 0.0f;
            tmpx = toShape.getX() < fromShape.getX() ? toShape.getX() - (float)Offset : fromShape.getX() - (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(tmpx, fromY);
            Point p3 = new Point(tmpx, toY);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        } else if (toY < fromShape.getY() - (float)minLen || toY > fromShape.getBottomRightY() + (float)minLen) {
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX - (float)Offset, fromY);
            Point p3 = new Point(fromX - (float)Offset, toY);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        } else {
            float tmpx = (fromShape.getBottomRightX() + toShape.getX()) / 2.0f;
            float tmpy = 0.0f;
            tmpy = fromY > toY ? fromShape.getY() - (float)Offset : fromShape.getBottomRightY() + (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX - (float)Offset, fromY);
            Point p3 = new Point(fromX - (float)Offset, tmpy);
            Point p4 = new Point(tmpx, tmpy);
            Point p5 = new Point(tmpx, toY);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        }
        return list;
    }

    public static ArrayList<Point> caculateBottomTop(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toShape.getY() - (float)minLen < fromShape.getBottomRightY() + (float)minLen) {
            if (toShape.getBottomRightX() + (float)minLen < fromShape.getX() - (float)minLen || toShape.getX() - (float)minLen > fromShape.getBottomRightX() + (float)minLen) {
                float tmpx = 0.0f;
                tmpx = toShape.getBottomRightX() < fromShape.getX() ? (toShape.getBottomRightX() + fromShape.getX()) / 2.0f : (toShape.getX() + fromShape.getBottomRightX()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, fromY + (float)Offset);
                Point p3 = new Point(tmpx, fromY + (float)Offset);
                Point p4 = new Point(tmpx, toY - (float)Offset);
                Point p5 = new Point(toX, toY - (float)Offset);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            } else {
                float tmpx = 0.0f;
                float tmpy = 0.0f;
                tmpx = toX > fromX ? (toShape.getBottomRightX() > fromShape.getBottomRightX() ? toShape.getBottomRightX() + (float)Offset : fromShape.getBottomRightX() + (float)Offset) : (toShape.getX() < fromShape.getX() ? toShape.getX() - (float)Offset : fromShape.getX() - (float)Offset);
                tmpy = toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(tmpx, tmpy);
                Point p4 = new Point(tmpx, toY - (float)Offset);
                Point p5 = new Point(toX, toY - (float)Offset);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            }
        } else if (toX == fromX) {
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
        } else {
            float tmpy = (fromShape.getBottomRightY() + toShape.getY()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(toX, tmpy);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        }
        return list;
    }

    public static ArrayList<Point> caculateBottomRight(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toY >= fromShape.getBottomRightY() + (float)minLen) {
            if (toShape.getBottomRightX() + (float)minLen <= fromX) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, toY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else if (toShape.getY() - (float)minLen > fromShape.getBottomRightY() + (float)minLen) {
                float tmpy = (fromShape.getBottomRightY() + toShape.getY()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(toX + (float)Offset, tmpy);
                Point p4 = new Point(toX + (float)Offset, toY);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            } else {
                float tmpy = 0.0f;
                tmpy = toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(toX + (float)Offset, tmpy);
                Point p4 = new Point(toX + (float)Offset, toY);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (toShape.getBottomRightX() + (float)minLen < fromShape.getX() - (float)minLen) {
            float tmpx = (toShape.getBottomRightX() + fromShape.getX()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, fromY + (float)Offset);
            Point p3 = new Point(tmpx, fromY + (float)Offset);
            Point p4 = new Point(tmpx, toY);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        } else {
            float tmpx = 0.0f;
            float tmpy = 0.0f;
            tmpx = toShape.getBottomRightX() > fromShape.getBottomRightX() ? toShape.getBottomRightX() + (float)Offset : fromShape.getBottomRightX() + (float)Offset;
            tmpy = toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(tmpx, toY);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        }
        return list;
    }

    public static ArrayList<Point> caculateBottomBottom(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toY + (float)minLen < fromShape.getY() - (float)minLen) {
            if (toX < fromShape.getX() - (float)minLen || toX > fromShape.getBottomRightX() + (float)minLen) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, fromY + (float)Offset);
                Point p3 = new Point(toX, fromY + (float)Offset);
                Point p4 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
            } else {
                float tmpy = (toShape.getBottomRightY() + fromShape.getY()) / 2.0f;
                float tmpx = 0.0f;
                tmpx = toX < fromX ? fromShape.getX() - (float)Offset : fromShape.getBottomRightX() + (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, fromY + (float)Offset);
                Point p3 = new Point(tmpx, fromY + (float)Offset);
                Point p4 = new Point(tmpx, tmpy);
                Point p5 = new Point(toX, tmpy);
                Point p6 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
                list.add(p6);
            }
        } else if (toShape.getX() - (float)minLen > fromX || toShape.getBottomRightX() + (float)minLen < fromX) {
            float tmpy = 0.0f;
            tmpy = toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(toX, tmpy);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        } else if (toShape.getY() - (float)minLen <= fromShape.getBottomRightY() + (float)minLen) {
            float tmpy = 0.0f;
            tmpy = toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(toX, tmpy);
            Point p4 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
        } else {
            float tmpx = 0.0f;
            float tmpy = (toShape.getY() + fromY) / 2.0f;
            tmpx = toX < fromX ? toShape.getBottomRightX() + (float)Offset : toShape.getX() - (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(tmpx, toY + (float)Offset);
            Point p5 = new Point(toX, toY + (float)Offset);
            Point p6 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
            list.add(p6);
        }
        return list;
    }

    public static ArrayList<Point> caculateBottomLeft(Shape fromShape, Shape toShape, Port fromPort, Port toPort) {
        ArrayList<Point> list = new ArrayList<Point>();
        float fromX = (float)((double)fromShape.getX() + (double)fromShape.getW() * fromPort.getX() + fromPort.getHorizontalOffset());
        float fromY = (float)((double)fromShape.getY() + (double)fromShape.getH() * fromPort.getY() + fromPort.getVerticalOffset());
        float toX = (float)((double)toShape.getX() + (double)toShape.getW() * toPort.getX() + toPort.getHorizontalOffset());
        float toY = (float)((double)toShape.getY() + (double)toShape.getH() * toPort.getY() + toPort.getVerticalOffset());
        if (toY >= fromShape.getBottomRightY() + (float)minLen) {
            if (toShape.getX() - (float)minLen >= fromX) {
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, toY);
                Point p3 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
            } else if (toShape.getY() - (float)minLen > fromShape.getBottomRightY() + (float)minLen) {
                float tmpy = (fromShape.getBottomRightY() + toShape.getY()) / 2.0f;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(toX - (float)Offset, tmpy);
                Point p4 = new Point(toX - (float)Offset, toY);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            } else {
                float tmpy = 0.0f;
                tmpy = toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset;
                Point p1 = new Point(fromX, fromY);
                Point p2 = new Point(fromX, tmpy);
                Point p3 = new Point(toX - (float)Offset, tmpy);
                Point p4 = new Point(toX - (float)Offset, toY);
                Point p5 = new Point(toX, toY);
                list.add(p1);
                list.add(p2);
                list.add(p3);
                list.add(p4);
                list.add(p5);
            }
        } else if (toShape.getX() - (float)minLen > fromShape.getBottomRightX() + (float)minLen) {
            float tmpx = (fromShape.getBottomRightX() + toShape.getX()) / 2.0f;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, fromY + (float)Offset);
            Point p3 = new Point(tmpx, fromY + (float)Offset);
            Point p4 = new Point(tmpx, toY);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        } else {
            float tmpx = 0.0f;
            float tmpy = 0.0f;
            tmpx = toShape.getX() > fromShape.getX() ? fromShape.getX() - (float)Offset : toShape.getX() - (float)Offset;
            tmpy = toShape.getBottomRightY() > fromShape.getBottomRightY() ? toShape.getBottomRightY() + (float)Offset : fromShape.getBottomRightY() + (float)Offset;
            Point p1 = new Point(fromX, fromY);
            Point p2 = new Point(fromX, tmpy);
            Point p3 = new Point(tmpx, tmpy);
            Point p4 = new Point(tmpx, toY);
            Point p5 = new Point(toX, toY);
            list.add(p1);
            list.add(p2);
            list.add(p3);
            list.add(p4);
            list.add(p5);
        }
        return list;
    }

    private static String getPointXml(List<Point> list) {
        StringBuffer sb = new StringBuffer();
        for (Point p : list) {
            sb.append("\n<omgdi:waypoint x=\"" + p.getX() + "\" y=\"" + p.getY() + "\"></omgdi:waypoint>\n");
        }
        return sb.toString();
    }

    public static String calcLabelPosition(String label) {
        float labelLen = 0.0f;
        for (int i = 0; i < label.length(); ++i) {
            if (label.charAt(i) > '\u00ff') {
                labelLen += 2.0f;
                continue;
            }
            if (Character.isUpperCase(label.charAt(i))) {
                labelLen = (float)((double)labelLen + 1.5);
                continue;
            }
            labelLen += 1.0f;
        }
        int x = (int)(labelLen > 16.0f ? -50.0f : -(labelLen / 16.0f + 1.0f) * 100.0f / 2.0f);
        int y = 0;
        int width = 100;
        int height = (int)((labelLen / 16.0f + 1.0f) * 14.0f);
        StringBuffer position = new StringBuffer();
        position.append(" <omgdc:Bounds ");
        position.append("x=\"" + x + "\" ");
        position.append("y=\"" + y + "\" ");
        position.append("width=\"" + width + "\" ");
        position.append("height=\"" + height + "\">");
        position.append("</omgdc:Bounds>");
        return position.toString();
    }

    public static String getPreVlanSumX(String contacts) {
        String[] xy = contacts.split(",");
        int pointx = 0;
        for (String str : xy) {
            if (!StringUtil.isNotEmpty((String)str)) continue;
            pointx += Integer.parseInt(str);
        }
        return pointx + "";
    }
}

