/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.service.ws.cxf.invok.impl;

import com.artfess.base.service.InvokeCmd;
import com.artfess.base.service.InvokeResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.XmlUtil;
import com.artfess.service.exception.InvokeException;
import com.artfess.service.model.DefaultInvokeResult;
import com.artfess.service.ws.cxf.invok.CxfInvokService;
import com.artfess.service.ws.cxf.invok.impl.SoapElementSaxHandler;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

@Service
public class CxfInvokServiceImpl
implements CxfInvokService {
    private static Log logger = LogFactory.getLog(CxfInvokServiceImpl.class);
    @Value(value="${service.webservice.connectTimeout:5000}")
    private Integer connectTimeout = 5000;
    @Value(value="${service.webservice.readTimeout:60000}")
    private Integer readTimeout = 60000;

    @Override
    public InvokeResult invoke(InvokeCmd invokeCmd) throws Exception {
        if (BeanUtils.isNotEmpty((Object)invokeCmd) && "webservice".equals(invokeCmd.getType())) {
            SOAPElement soapElement = this.getSOAPElement(invokeCmd);
            SOAPMessage requestMessage = this.buildRequest(soapElement, invokeCmd);
            DefaultInvokeResult invokeResult = new DefaultInvokeResult();
            String requestXml = this.out(requestMessage);
            invokeResult.setRequestXml(requestXml);
            SOAPMessage responseMessage = this.doInvoke(requestMessage, invokeCmd);
            String responseXml = this.out(responseMessage);
            invokeResult.setResponseXml(responseXml);
            return this.responseHandler(invokeResult, responseMessage, invokeCmd.getJAXBRespClass());
        }
        return null;
    }

    private String out(SOAPMessage message) throws Exception {
        Document doc = message.getSOAPPart().getEnvelope().getOwnerDocument();
        StringWriter output = new StringWriter();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(output));
        String outXml = output.toString();
        logger.debug((Object)outXml);
        return outXml;
    }

    private SOAPMessage buildRequest(SOAPElement soapElement, InvokeCmd invokeCmd) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage();
        if (invokeCmd.getJAXBObjectHeader() != null) {
            String xmlHeader = JAXBUtil.marshall((Object)invokeCmd.getJAXBObjectHeader(), (boolean)true);
            SOAPElement headerElement = this.getSOAPElementByString(xmlHeader);
            message.getSOAPHeader().addChildElement(headerElement);
        }
        SOAPPart soapPart = message.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        if (invokeCmd.getNeedPrefix().booleanValue()) {
            envelope.addNamespaceDeclaration(invokeCmd.getNsPrefix(), invokeCmd.getOperatorNamespace());
        }
        SOAPBody body = envelope.getBody();
        body.addChildElement(soapElement);
        message.saveChanges();
        return message;
    }

    private SOAPElement getSOAPElement(InvokeCmd invokeCmd) throws Exception {
        String xmlParam;
        String jsonParam;
        SOAPElement bodyElement;
        String opratorName = invokeCmd.getOperatorName();
        String opratorNamespace = invokeCmd.getOperatorNamespace();
        SOAPFactory factory = SOAPFactory.newInstance();
        if (StringUtil.isNotEmpty((String)opratorNamespace)) {
            bodyElement = factory.createElement(opratorName, invokeCmd.getNsPrefix(), opratorNamespace);
            if (invokeCmd.getNeedPrefix().booleanValue()) {
                bodyElement.addNamespaceDeclaration(invokeCmd.getNsPrefix(), opratorNamespace);
            }
        } else {
            bodyElement = factory.createElement(opratorName);
        }
        if (StringUtil.isNotEmpty((String)(jsonParam = invokeCmd.getJsonParam()))) {
            jsonParam = jsonParam.trim();
            JsonNode json = JsonUtil.toJsonNode((String)jsonParam);
            this.setRequestStruct(json, bodyElement, invokeCmd.getNeedPrefix(), invokeCmd.getNsPrefix());
        } else if (BeanUtils.isNotEmpty((Object)invokeCmd.getJAXBObjectParam())) {
            xmlParam = JAXBUtil.marshall((Object)invokeCmd.getJAXBObjectParam(), (boolean)true);
            invokeCmd.setXmlParam(xmlParam);
        }
        if (StringUtil.isNotEmpty((String)invokeCmd.getXmlParam()) && StringUtil.isNotEmpty((String)(xmlParam = invokeCmd.getXmlParam()))) {
            SOAPElement xmlSoapElement = this.getSOAPElementByString(xmlParam);
            if (opratorName.equals(xmlSoapElement.getLocalName())) {
                return xmlSoapElement;
            }
            bodyElement.addChildElement(xmlSoapElement);
        }
        return bodyElement;
    }

    private SOAPElement getSOAPElementByString(String xml) throws Exception {
        StringReader stringReader = new StringReader(xml);
        InputSource inputSource = new InputSource(stringReader);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        SoapElementSaxHandler handler = new SoapElementSaxHandler();
        parser.parse(inputSource, (DefaultHandler)handler);
        return handler.getSOAPElement();
    }

    private void setRequestStruct(JsonNode jsonElement, SOAPElement soapElement, Boolean needPrefix, String nsPrefix) throws SOAPException {
        if (jsonElement.isArray()) {
            ArrayNode jarray = (ArrayNode)jsonElement;
            int count = jarray.size();
            for (int i = 0; i < count; ++i) {
                JsonNode jelement = jarray.get(i);
                if (i == 0) {
                    this.setRequestStruct(jelement, soapElement, needPrefix, nsPrefix);
                    continue;
                }
                SOAPElement cloneNode = (SOAPElement)soapElement.cloneNode(false);
                soapElement.getParentElement().appendChild((Node)cloneNode);
                this.setRequestStruct(jelement, cloneNode, needPrefix, nsPrefix);
            }
        } else if (jsonElement.isObject()) {
            ObjectNode jobject = (ObjectNode)jsonElement;
            Iterator it = jobject.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                SOAPElement element = null;
                element = needPrefix != false ? soapElement.addChildElement((String)entry.getKey(), nsPrefix) : soapElement.addChildElement((String)entry.getKey());
                this.setRequestStruct((JsonNode)entry.getValue(), element, needPrefix, nsPrefix);
            }
        } else if (jsonElement.isTextual()) {
            soapElement.setValue(jsonElement.asText());
        }
    }

    private SOAPMessage doInvoke(SOAPMessage requestMessage, final InvokeCmd cmd) throws Exception {
        SOAPConnectionFactory soapConnFactory = SOAPConnectionFactory.newInstance();
        try (SOAPConnection connection = null;){
            SOAPMessage reply;
            URL endPoint = new URL(null, new URL(cmd.getAddress()).toString(), new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    URL clone_url = new URL(u.toString());
                    HttpURLConnection clone_urlconnection = (HttpURLConnection)clone_url.openConnection();
                    clone_urlconnection.setConnectTimeout(CxfInvokServiceImpl.this.connectTimeout);
                    clone_urlconnection.setReadTimeout(CxfInvokServiceImpl.this.readTimeout);
                    for (String key : cmd.getConnHeaders().keySet()) {
                        clone_urlconnection.addRequestProperty(key, (String)cmd.getConnHeaders().get(key));
                    }
                    return clone_urlconnection;
                }
            });
            connection = soapConnFactory.createConnection();
            SOAPMessage sOAPMessage = reply = connection.call(requestMessage, (Object)endPoint);
            return sOAPMessage;
        }
    }

    private void buildResultJson(SOAPMessage message, DefaultInvokeResult invokeResult) throws Exception {
        SOAPBody body = message.getSOAPBody();
        Node reponseNode = body.getFirstChild();
        Node returnNode = reponseNode.getFirstChild();
        StringWriter output = new StringWriter();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(returnNode), new StreamResult(output));
        String xml = output.toString();
        String json = XmlUtil.toJson((String)xml);
        invokeResult.setJson(json);
    }

    private InvokeResult responseHandler(DefaultInvokeResult invokeResult, SOAPMessage responseMessage, Class<?> jaxbRespClazz) throws Exception {
        this.checkFault(responseMessage);
        Node response = responseMessage.getSOAPBody().getFirstChild();
        if (response.getFirstChild() == null) {
            return invokeResult;
        }
        HashMap result = new HashMap();
        XmlUtil.transformToMap(result, (Node)response);
        if (jaxbRespClazz != null) {
            try {
                invokeResult.setObject(XmlUtil.mapToXMLBean(result, jaxbRespClazz));
            }
            catch (Exception e) {
                e.printStackTrace();
                invokeResult.setObject(XmlUtil.transformToObject((Node)response, jaxbRespClazz));
            }
        } else {
            invokeResult.setObject(result);
            if (result.size() == 1) {
                Object value = result.values().iterator().next();
                if (value instanceof List) {
                    invokeResult.setList((List)value);
                } else {
                    invokeResult.setObject(value);
                }
            }
        }
        return invokeResult;
    }

    protected InvokeResult responseMessageHandler(SOAPMessage responseMessage) throws Exception {
        this.checkFault(responseMessage);
        this.out(responseMessage);
        Node response = responseMessage.getSOAPBody().getFirstChild();
        Node result = response.getFirstChild();
        DefaultInvokeResult invokeResult = new DefaultInvokeResult();
        if (BeanUtils.isEmpty((Object)result)) {
            return invokeResult;
        }
        this.buildResultJson(responseMessage, invokeResult);
        String resultNodeName = result.getNodeName();
        Node nextSibling = result.getNextSibling();
        if (BeanUtils.isNotEmpty((Object)nextSibling) && resultNodeName.equals(nextSibling.getNodeName())) {
            NodeList results = response.getChildNodes();
            int count = results.getLength();
            ArrayList<Object> resultList = new ArrayList<Object>();
            for (int i = 0; i < count; ++i) {
                resultList.add(results.item(i));
            }
            invokeResult.setList(resultList);
        } else {
            Node firstNode = result.getFirstChild();
            if (firstNode instanceof Text) {
                invokeResult.setObject(firstNode.getNodeValue());
            } else {
                String firstNodeName = firstNode.getNodeName();
                Node nextChild = firstNode.getNextSibling();
                if (BeanUtils.isNotEmpty((Object)nextChild) && firstNodeName.equals(nextChild.getNodeName())) {
                    NodeList resultDetailList = result.getChildNodes();
                    int count = resultDetailList.getLength();
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < count; ++i) {
                        Node element = resultDetailList.item(i);
                        NodeList childNodes = element.getChildNodes();
                        int s = childNodes.getLength();
                        if (s == 1) {
                            Node item = childNodes.item(0);
                            if (item instanceof Text) {
                                list.add(item.getNodeValue());
                                continue;
                            }
                            list.add(this.buildMapResult(item.getChildNodes()));
                            continue;
                        }
                        if (s <= 1) continue;
                        list.add(this.buildMapResult(childNodes));
                    }
                    invokeResult.setList(list);
                } else {
                    invokeResult.setObject(result);
                }
            }
        }
        return invokeResult;
    }

    private Map<String, Object> buildMapResult(NodeList nodeList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node item = nodeList.item(i);
            String nodeName = item.getNodeName();
            if (item instanceof Element) {
                String xml = XmlUtil.getXML((Element)((Element)item));
                map.put(nodeName, XmlUtil.toJson((String)xml));
                continue;
            }
            if (item instanceof Text) {
                map.put(nodeName, item.getNodeValue());
                continue;
            }
            map.put(nodeName, item);
        }
        return map;
    }

    private void checkFault(SOAPMessage message) throws SOAPException, InvokeException {
        SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPFault fault = body.getFault();
        if (fault != null && fault.getFaultCode() != null) {
            throw new InvokeException(" [" + fault.getFaultCode() + "] " + fault.getFaultString());
        }
    }
}

