/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.job.persistence.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.job.model.JobDetails;
import com.artfess.job.model.ParameterObj;
import com.artfess.job.model.SchedulerVo;
import com.artfess.job.persistence.dao.JobDetailsDao;
import com.artfess.job.persistence.manager.JobDetailsManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class JobDetailsManagerImpl
extends BaseManagerImpl<JobDetailsDao, JobDetails>
implements JobDetailsManager {
    @Resource
    BaseContext baseContext;

    @Override
    public void addJob(SchedulerVo schedulerVo) throws IOException, ClassNotFoundException {
        Class<?> cls = Class.forName(schedulerVo.getClassName());
        JobDetails jobDetails = new JobDetails();
        jobDetails.setSchedName("quartzScheduler");
        jobDetails.setJobName(schedulerVo.getJobName());
        jobDetails.setJobGroup(this.baseContext.getCurrentTenantId());
        jobDetails.setDescription(schedulerVo.getDescription());
        jobDetails.setJobClassNname(schedulerVo.getClassName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = (List)JsonUtil.toBean((String)schedulerVo.getParameterJson(), (TypeReference)new TypeReference<List<ParameterObj>>(){});
        for (ParameterObj obj : list) {
            Constable val;
            String type = obj.getType();
            String name = obj.getName();
            String value = obj.getValue();
            if (type.equals("int")) {
                val = StringUtils.isEmpty((String)value) ? 0 : Integer.parseInt(value);
                map.put(name, val);
                continue;
            }
            if (type.equals("long")) {
                val = StringUtils.isEmpty((String)value) ? 0L : Long.parseLong(value);
                map.put(name, val);
                continue;
            }
            if (type.equals("float")) {
                val = Float.valueOf(StringUtils.isEmpty((String)value) ? 0.0f : Float.parseFloat(value));
                map.put(name, val);
                continue;
            }
            if (type.equals("boolean")) {
                val = Boolean.valueOf(StringUtils.isEmpty((String)value) ? false : Boolean.parseBoolean(value));
                map.put(name, val);
                continue;
            }
            map.put(name, value);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(map);
        byte[] bt = os.toByteArray();
        oos.close();
        os.close();
        jobDetails.setJobData(bt);
        super.create((Model)jobDetails);
    }

    @Override
    public boolean isJobExists(String jobName) {
        JobDetails jobDetails = (JobDetails)((Object)((JobDetailsDao)this.baseMapper).selectOne((Wrapper)Wrappers.lambdaQuery().eq(JobDetails::getJobName, (Object)jobName)));
        return BeanUtils.isNotEmpty((Object)((Object)jobDetails));
    }
}

