package com.artfess.i18n.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.i18n.persistence.model.I18nMessageType;

import java.util.List;

/**
 * 
 * <pre> 
 * 描述：国际化资源支持的语言类型 处理接口
 * @author zhaoxy
 * @company 阿特菲斯信息技术有限公司
 * @email zhxy@jee-soft.cn
 * @date 2018-06-06 14:20
 * </pre>
 */
public interface I18nMessageTypeManager extends BaseManager<I18nMessageType> {

    /**
     * 根据type获取语言类型
     * @param type
     * @return
     */
    I18nMessageType getByType(String type);
    
    /**
     * 获取所有语言类型
     */
    List<I18nMessageType> getAllType();
    
    /**
     * 清空语言类型缓存
     */
    void delMessageTypeCache();
}
