package com.artfess.file.persistence.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.FileZone;
import com.artfess.file.persistence.dao.FileZoneDao;
import com.artfess.file.persistence.manager.FileZoneManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 文件分片记录 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2021-12-29
 */
@Service
public class FileZoneManagerImpl extends BaseManagerImpl<FileZoneDao, FileZone> implements FileZoneManager {

    @Override
    public List<FileZone> queryByMd5Value(String md5Value, Long fileSize) {
        if(StringUtil.isEmpty(md5Value)){
            throw new RequiredException("文件hash值不能为空！");
        }
        QueryWrapper<FileZone> queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("zone_total_md5_", md5Value).eq("zone_total_size_", fileSize);
        List<FileZone> list = this.baseMapper.selectList(queryWrapper);
        return list;
    }

    @Override
    public Integer countByMd5AndSize(String md5Value,Long fileSize) {
        if(StringUtil.isEmpty(md5Value)){
            throw new RequiredException("文件hash值不能为空！");
        }
        QueryWrapper<FileZone> queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("zone_total_md5_", md5Value).eq("zone_total_size_", fileSize);
        Integer count = this.baseMapper.selectCount(queryWrapper);
        return count;
    }

    @Transactional
    @Override
    public boolean removeZoneByMd5AndSize(String md5Value, Long fileSize) {
        if(StringUtil.isEmpty(md5Value)){
            throw new RequiredException("文件hash值不能为空！");
        }
        if(StringUtil.isEmpty(fileSize)){
            throw new RequiredException("文件长度不能为空！");
        }
        QueryWrapper<FileZone> queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("zone_total_md5_", md5Value).eq("zone_total_size_", fileSize);
        Integer result = this.baseMapper.delete(queryWrapper);
        return null != result && result >= 1;
    }
}
