/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.attachmentService;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.config.FtpEntity;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.AppFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.springframework.stereotype.Service;

@Service
public class FtpAttachmentServiceImpl
implements AttachmentService {
    private void connect(FtpEntity ftpEntity, FTPClient ftp) {
        try {
            int reply;
            ftp.connect(ftpEntity.getUrl(), ftpEntity.getPort().intValue());
            FTPClientConfig conf = new FTPClientConfig("WINDOWS");
            conf.setServerLanguageCode("zh");
            boolean loginResult = ftp.login(ftpEntity.getUsername(), ftpEntity.getPassword());
            if (loginResult) {
                if (FTPReply.isPositiveCompletion((int)ftp.sendCommand("OPTS UTF8", "ON"))) {
                    ftpEntity.setLOCAL_CHARSET("UTF-8");
                }
                ftp.setControlEncoding(ftpEntity.getLOCAL_CHARSET());
                ftp.enterLocalPassiveMode();
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = ftp.getReplyCode()))) {
                ftp.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        FtpEntity ftpEntity = (FtpEntity)AppUtil.getBean(FtpEntity.class);
        FTPClient ftp = new FTPClient();
        ftpEntity = this.initUploadProperties(propertiesId, attachment, ftpEntity, true);
        String path = attachment.getFilePath();
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : attachment.getFileName() + "." + attachment.getExtensionName();
        path = this.replaceFileSeparator(path);
        path = new String(path.getBytes(ftpEntity.getLOCAL_CHARSET()), ftpEntity.getSERVER_CHARSET());
        this.validConnection(ftpEntity, ftp);
        this.CreateDirecroty(path, ftp);
        ftp.setFileType(2);
        boolean result = ftp.storeFile(fileName, inputStream);
        if (!result) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
        inputStream.close();
    }

    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        FtpEntity ftpEntity = (FtpEntity)AppUtil.getBean(FtpEntity.class);
        FTPClient ftp = new FTPClient();
        ftpEntity = this.initUploadProperties(propertiesId, attachment, ftpEntity, false);
        this.validConnection(ftpEntity, ftp);
        String path = attachment.getFilePath();
        path = this.replaceFileSeparator(path);
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : attachment.getFileName() + "." + attachment.getExtensionName();
        path = this.getFtpPath(path);
        path = new String(path.getBytes(ftpEntity.getLOCAL_CHARSET()), ftpEntity.getSERVER_CHARSET());
        boolean changeResult = ftp.changeWorkingDirectory(path);
        if (!changeResult) {
            throw new RuntimeException("\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        FTPFile[] fs = ftp.listFiles();
        boolean tag = false;
        for (FTPFile ff : fs) {
            String n = ff.getName();
            if (!n.equals(fileName)) continue;
            tag = true;
            ftp.retrieveFile(fileName, outStream);
            outStream.close();
            break;
        }
        if (!tag) {
            throw new RuntimeException("\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        FtpEntity ftpEntity = (FtpEntity)AppUtil.getBean(FtpEntity.class);
        FTPClient ftp = new FTPClient();
        ftpEntity = this.initUploadProperties(propertiesId, attachment, ftpEntity, false);
        boolean ref = true;
        this.validConnection(ftpEntity, ftp);
        String path = attachment.getFilePath();
        path = this.replaceFileSeparator(path);
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : attachment.getFileName() + "." + attachment.getExtensionName();
        path = this.getFtpPath(path);
        path = new String(path.getBytes(ftpEntity.getLOCAL_CHARSET()), ftpEntity.getSERVER_CHARSET());
        boolean changeResult = ftp.changeWorkingDirectory(path);
        if (!changeResult) {
            ref = false;
        }
        FTPFile[] fs = ftp.listFiles();
        boolean tag = false;
        for (FTPFile ff : fs) {
            String n = ff.getName();
            if (!n.equals(fileName)) continue;
            tag = true;
            break;
        }
        if (!tag) {
            ref = false;
        }
        return ref;
    }

    public void remove(Attachment attachment, String propertiesId) throws Exception {
        FtpEntity ftpEntity = (FtpEntity)AppUtil.getBean(FtpEntity.class);
        FTPClient ftp = new FTPClient();
        ftpEntity = this.initUploadProperties(propertiesId, attachment, ftpEntity, false);
        this.validConnection(ftpEntity, ftp);
        String path = attachment.getFilePath();
        path = this.replaceFileSeparator(path);
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : attachment.getFileName() + "." + attachment.getExtensionName();
        ftp.deleteFile(path + ftpEntity.getSeparator() + fileName);
    }

    private void validConnection(FtpEntity ftpEntity, FTPClient ftp) {
        try {
            if (!(ftp.isConnected() && ftp.isRemoteVerificationEnabled() && ftp.sendNoOp())) {
                this.connect(ftpEntity, ftp);
            }
            ftp.changeWorkingDirectory(File.separator);
        }
        catch (Exception e) {
            this.connect(ftpEntity, ftp);
        }
    }

    private boolean CreateDirecroty(String remote, FTPClient ftp) throws IOException {
        boolean success;
        block5: {
            success = true;
            remote = this.getFtpPath(remote);
            String separator = "/";
            String directory = remote + separator;
            if (directory.equalsIgnoreCase(separator) || this.changeWorkingDirectory(new String(directory), ftp)) break block5;
            int start = 0;
            int end = 0;
            start = directory.startsWith(separator) ? 1 : 0;
            end = directory.indexOf(separator, start);
            String path = "";
            String paths = "";
            do {
                String subDirectory = new String(remote.substring(start, end).getBytes("GBK"), "iso-8859-1");
                if (!this.existFile(path = path + separator + subDirectory, ftp)) {
                    if (this.makeDirectory(subDirectory, ftp)) {
                        this.changeWorkingDirectory(subDirectory, ftp);
                    } else {
                        System.out.println("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                        this.changeWorkingDirectory(subDirectory, ftp);
                    }
                } else {
                    this.changeWorkingDirectory(subDirectory, ftp);
                }
                paths = paths + separator + subDirectory;
            } while ((end = directory.indexOf(separator, start = end + 1)) > start);
        }
        return success;
    }

    private boolean changeWorkingDirectory(String directory, FTPClient ftp) {
        boolean flag = true;
        try {
            flag = ftp.changeWorkingDirectory(directory);
            if (flag) {
                System.out.println("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u6210\u529f\uff01");
            } else {
                System.out.println("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u5931\u8d25\uff01\u5f00\u59cb\u521b\u5efa\u6587\u4ef6\u5939");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return flag;
    }

    private boolean existFile(String path, FTPClient ftp) throws IOException {
        boolean flag = false;
        FTPFile[] ftpFileArr = ftp.listFiles(path);
        if (ftpFileArr.length > 0) {
            flag = true;
        }
        return flag;
    }

    private boolean makeDirectory(String dir, FTPClient ftp) {
        boolean flag = true;
        try {
            flag = ftp.makeDirectory(dir);
            if (flag) {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u6210\u529f\uff01");
            } else {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private String replaceFileSeparator(String path) {
        String ftpFormatPath = this.regReplace(path, File.separator);
        if (path.equals(ftpFormatPath = ftpFormatPath.replaceAll("/\\w+\\.?(\\w+)?(\\s+)?$", ""))) {
            ftpFormatPath = this.getFtpPath(ftpFormatPath);
            ftpFormatPath = ftpFormatPath.replaceAll("/\\w+\\.?(\\w+)?(\\s+)?$", "");
            ftpFormatPath = ftpFormatPath.replaceAll("/", "\\\\");
        }
        return ftpFormatPath;
    }

    private String regReplace(String str, String replaceChar) {
        StringBuffer resultString = new StringBuffer();
        try {
            Pattern regex = Pattern.compile("[\\|/]");
            Matcher regexMatcher = regex.matcher(str);
            while (regexMatcher.find()) {
                regexMatcher.appendReplacement(resultString, replaceChar);
            }
            regexMatcher.appendTail(resultString);
        }
        catch (PatternSyntaxException ex) {
            ex.printStackTrace();
        }
        return resultString.toString();
    }

    public String getStoreType() {
        return "ftp";
    }

    private FtpEntity initUploadProperties(String propertiesId, Attachment defaultFile, FtpEntity ftpEntity, boolean isUpload) {
        if (StringUtil.isNotEmpty((String)propertiesId)) {
            FileStorageManager fileStorageManager = (FileStorageManager)AppUtil.getBean(FileStorageManager.class);
            FileStorage fileStorage = (FileStorage)fileStorageManager.get((Serializable)((Object)propertiesId));
            if (BeanUtils.isNotEmpty((Object)((Object)fileStorage))) {
                String location = fileStorage.getLocation();
                if (isUpload && StringUtil.isNotEmpty((String)location)) {
                    location = location.replace("/", "\\");
                    defaultFile.setFilePath(location + defaultFile.getFilePath());
                }
                FtpEntity ftpEntity2 = new FtpEntity();
                ftpEntity2.setUrl(fileStorage.getUrl());
                ftpEntity2.setPort(fileStorage.getPort());
                ftpEntity2.setUsername(fileStorage.getUserName());
                ftpEntity2.setPassword(fileStorage.getPassword());
                defaultFile.setEntryptName(Boolean.valueOf(fileStorage.getEncryptName() != 0));
                return ftpEntity2;
            }
            if (isUpload) {
                String sysPath = AppFileUtil.getAttachPath();
                if (StringUtil.isNotEmpty((String)sysPath)) {
                    sysPath = sysPath.replace("/", "\\");
                    defaultFile.setFilePath(sysPath + defaultFile.getFilePath());
                }
            } else {
                FlowUploadPropertiesManager uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class);
                FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
                if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
                    String location = uploadProperties.getLocation();
                    if (isUpload && StringUtil.isNotEmpty((String)location)) {
                        location = location.replace("/", "\\");
                        defaultFile.setFilePath(location + defaultFile.getFilePath());
                    }
                    FtpEntity ftpEntity2 = new FtpEntity();
                    ftpEntity2.setUrl(uploadProperties.getUrl());
                    ftpEntity2.setPort(uploadProperties.getPort());
                    ftpEntity2.setUsername(uploadProperties.getUserName());
                    ftpEntity2.setPassword(uploadProperties.getPassword());
                    defaultFile.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
                    return ftpEntity2;
                }
            }
            return ftpEntity;
        }
        return ftpEntity;
    }

    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        return null;
    }

    private String getFtpPath(String path) {
        if (StringUtil.isNotEmpty((String)path)) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }
}

