/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.sysConfig.persistence.manager.SysModuleDetailManager;
import com.artfess.sysConfig.persistence.manager.SysModuleManager;
import com.artfess.sysConfig.persistence.model.SysModule;
import com.artfess.sysConfig.util.SysPropertyUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sys/sysModule/v1"})
@Api(tags={"\u7cfb\u7edf\u6a21\u5757"})
@ApiGroup(group={"group_system"})
public class SysModuleController
extends BaseController<SysModuleManager, SysModule> {
    @Resource
    SysModuleManager sysModuleManager;
    @Resource
    SysModuleDetailManager sysModuleDetailManager;
    private static final String ROOT_PATH = "attachFiles" + File.separator + "tempZip";

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6a21\u5757\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6a21\u5757\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    @ResponseBody
    public PageList<SysModule> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysModule> queryFilter) {
        queryFilter.getSorter().add(new FieldSort("updateTime", Direction.DESC));
        return this.sysModuleManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6a21\u5757\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u6a21\u5757\u660e\u7ec6\u9875\u9762")
    public SysModule getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id) {
        if (StringUtil.isEmpty((String)id)) {
            return new SysModule();
        }
        SysModule sysModule = (SysModule)this.sysModuleManager.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)sysModule)) {
            return new SysModule();
        }
        List details = this.sysModuleDetailManager.getModuleDetail(sysModule.getId(), null);
        sysModule.setModuleDetail(details);
        return sysModule;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6a21\u5757\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysModule", value="\u6a21\u5757\u4fe1\u606f\u5bf9\u8c61") @RequestBody SysModule sysModule) {
        CommonResult resultMsg = null;
        String id = sysModule.getId();
        boolean isDeploy = sysModule.isDeploy();
        try {
            if (StringUtil.isEmpty((String)id)) {
                SysModule oldSysModule = this.sysModuleManager.getModuleByCode(sysModule.getCode());
                if (BeanUtils.isNotEmpty((Object)oldSysModule)) {
                    throw new RuntimeException("\u7f16\u7801\uff1a" + sysModule.getCode() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u6a21\u5757\u7f16\u7801\uff01");
                }
                sysModule.setId(UniqueIdUtil.getSuid());
                IGroup iGroup = ContextUtil.getCurrentGroup();
                sysModule.setUpdateTime(LocalDateTime.now());
                this.sysModuleManager.create((Model)sysModule);
                resultMsg = new CommonResult(isDeploy ? "\u6a21\u5757\u6dfb\u52a0\u3001\u53d1\u5e03\u6210\u529f" : "\u6dfb\u52a0\u6a21\u5757\u6210\u529f");
            } else {
                this.sysModuleManager.update((Model)sysModule);
                resultMsg = new CommonResult(isDeploy ? "\u6a21\u5757\u66f4\u65b0\u3001\u53d1\u5e03\u6210\u529f" : "\u66f4\u65b0\u6a21\u5757\u6210\u529f");
            }
        }
        catch (Exception e) {
            resultMsg = new CommonResult(false, "\u5bf9\u6a21\u5757\u64cd\u4f5c\u5931\u8d25" + e.getMessage());
        }
        return resultMsg;
    }

    @RequestMapping(value={"saveModule"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6a21\u5757\u4fe1\u606f")
    public CommonResult<String> saveModule(@ApiParam(name="sysModule", value="\u6a21\u5757\u4fe1\u606f\u5bf9\u8c61") @RequestBody SysModule sysModule) {
        CommonResult resultMsg = null;
        String id = sysModule.getId();
        this.sysModuleManager.saveModule(sysModule);
        resultMsg = StringUtil.isEmpty((String)id) ? new CommonResult(true, "\u6dfb\u52a0\u6a21\u5757\u4fe1\u606f\u6210\u529f", (Object)sysModule.getId()) : new CommonResult(true, "\u66f4\u65b0\u6a21\u5757\u4fe1\u606f\u6210\u529f", (Object)sysModule.getId());
        return resultMsg;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8bb0\u5f55")
    public CommonResult<String> remove(String ... ids) {
        CommonResult message = null;
        try {
            this.sysModuleManager.removeByIds(ids);
            message = new CommonResult("\u5220\u9664\u6a21\u5757\u6210\u529f");
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5220\u9664\u6a21\u5757\u5931\u8d25");
        }
        return message;
    }

    @RequestMapping(value={"isExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u6a21\u5757\u7f16\u53f7\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u5224\u65ad\u6a21\u5757\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    public boolean isExist(@ApiParam(name="code", value="\u6a21\u5757\u7f16\u7801", required=false) @RequestParam String code) throws Exception {
        boolean res = false;
        if (StringUtil.isNotEmpty((String)code)) {
            SysModule temp = this.sysModuleManager.getModuleByCode(code);
            res = BeanUtils.isNotEmpty((Object)temp);
        }
        return res;
    }

    @RequestMapping(value={"exportModule"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u683c\u5f0f\u4e3a*.zip\u7684\u6a21\u5757\u5bf9\u8c61\uff0czip\u6587\u4ef6\u5305\u542b\u4e00\u4e2axml\u6587\u4ef6\uff0cxml\u6587\u4ef6\u90fd\u662f\u591a\u4e2a\u6a21\u5757\u5bf9\u8c61;", httpMethod="GET", notes="\u5bfc\u51fa\u683c\u5f0f\u4e3a*.zip\u7684\u6a21\u5757\u5bf9\u8c61\uff0czip\u6587\u4ef6\u5305\u542b\u4e00\u4e2axml\u6587\u4ef6\uff0cxml\u6587\u4ef6\u90fd\u662f\u591a\u4e2a\u6a21\u5757\u5bf9\u8c61;")
    public void exportModule(HttpServletRequest request, HttpServletResponse response, String ... ids) throws Exception {
        if (BeanUtils.isEmpty((Object)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids);
        Map map = this.sysModuleManager.exportModules(idList);
        String fileName = "ht_module_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (Map)map, (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequestMapping(value={"importModule"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6a21\u5757\u5bf9\u8c61", httpMethod="POST", notes="\u5bfc\u5165\u6a21\u5757\u5bf9\u8c61")
    public CommonResult<String> importModule(@ApiParam(name="file", value="\u5bfc\u5165\u7684zip\u6587\u4ef6", required=true) @RequestBody MultipartFile file) throws Exception {
        CommonResult message;
        block13: {
            message = null;
            String unZipFilePath = null;
            String rootRealPath = SysPropertyUtil.getByAlias((String)"file.upload");
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.sysModuleManager.importModules(unZipFilePath);
            message = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            try {
                File formDir = new File(unZipFilePath);
                if (formDir.exists()) {
                    FileUtil.deleteDir((File)formDir);
                }
                break block13;
            }
            catch (Exception e2) {
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25! " + e2.getMessage());
            }
            break block13;
            catch (Exception e) {
                try {
                    System.out.println(e.getMessage());
                    message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25! " + e.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        File formDir = new File(unZipFilePath);
                        if (formDir.exists()) {
                            FileUtil.deleteDir((File)formDir);
                        }
                    }
                    catch (Exception e2) {
                        message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25! " + e2.getMessage());
                    }
                    throw throwable;
                }
                try {
                    File formDir = new File(unZipFilePath);
                    if (formDir.exists()) {
                        FileUtil.deleteDir((File)formDir);
                    }
                }
                catch (Exception e2) {
                    message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25! " + e2.getMessage());
                }
            }
        }
        return message;
    }
}

