package com.artfess.security.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.security.model.SecurityPersonloginlimit;
import com.artfess.security.vo.PersonloginlimitVo;
import com.baomidou.mybatisplus.core.metadata.IPage;


/**
 * 人员+设备登录限制 服务类
 *
 * @company 阿特菲斯
 * @author chenshi
 * @email chenshi@artfess.com
 * @since 2021-03-08
 */
public interface SecurityPersonloginlimitManager extends BaseManager<SecurityPersonloginlimit> {
    /**
     * 获取涉密机器关联的人员账号
     * @param queryFilter
     * @return
     * @throws Exception
     */
    IPage<PersonloginlimitVo> queryPersonloginlimitPage(QueryFilter<SecurityPersonloginlimit> queryFilter) throws Exception;

    /**
     * 关联涉密机器与账号
     * @param machineId 涉密机器id
     * @param userIds 账号id
     * @return
     */
    CommonResult<String> insertPersonloginlimit(String machineId, String userIds) throws Exception;

    /**
     * 根据机器Id删除人员与机器关联
     * @param machineId 涉密机器id
     * @return
     */
    void deleteByMachineId(String machineId)  throws Exception;
}
