package com.artfess.form.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.QueryFilter;
import com.artfess.form.model.CustomChart;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 自定义图表管理
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2020年4月14日
 */
public interface CustomChartManager extends BaseManager<CustomChart> {
    /**
     * 通过通用查询对自定义图表进行查询
     *
     * @param customDialog
     * @param filter
     * @param dbType
     * @return
     * @throws IOException
     */
    Object getListData(CustomChart customDialog, QueryFilter<?> filter, String dbType) throws IOException;

    /**
     * 通过别名获取自定义图表
     *
     * @param alias
     * @return
     */
    CustomChart getChartByAlias(String alias);

    /**
     * 判断指定别名的自定义图表是否存在
     *
     * @param alias
     * @return
     */
    boolean listChartByAlias(String alias);

    Map<String, String> exportData(List<String> ids) throws Exception;

    void importData(MultipartFile file);
}
