package com.artfess.base.enums;

import com.google.common.collect.Lists;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 区域级别
 */
@Getter
public enum AreaLevelEnum {
    /**
     * 删除
     */
    province("province", "省"),

    city("city", "市"),

    country("country", "区/县"),

    town("town", "乡镇"),

    village("village", "村"),
    ;

    AreaLevelEnum(String level, String desc){
        this.level = level;
        this.desc = desc;
    }

    private String level;

    private String desc;

    public static List<String> townLevels(){
        List<String> townLevels = Lists.newArrayList();
        townLevels.add(AreaLevelEnum.province.level);
        townLevels.add(AreaLevelEnum.city.level);
        townLevels.add(AreaLevelEnum.country.level);
        townLevels.add(AreaLevelEnum.town.level);
        return townLevels;
    }

    public static List<String> provinceTree(){
        List<String> townLevels = Lists.newArrayList();
        townLevels.add(AreaLevelEnum.province.level);
        return townLevels;
    }

    public static String getDesc(String level){
        if(StringUtils.isEmpty(level)){
            return null;
        }
        AreaLevelEnum[] values = values();
        for (AreaLevelEnum state : values) {
            if (state.getLevel().equals(level)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
