package com.artfess.base.service;

import java.util.List;

/**
 * 涉密计算机与人员关联接口
 *
 * @author chens
 * @date 2021年03月10日
 */
public interface SecurityMachinePersonService {

	/**
	* 根据账号获取涉密计算机关联的人员
	* @param account 人员账号
	* @Author: chens
	* @Date: 2021/3/10 11:05
	*/
	List<String> queryPersonLimitByAccount(String account);

	/**
	 * 根据涉密计算机ID获取涉密计算IP信息
	 * @param machineIdList 涉密计算机ID集合
	 * @Author: chens
	 * @Date: 2021/3/10 11:05
	 */
	List<String> queryMachineIps(List<String> machineIdList);
}
