/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FluentUtil {
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 30000;
    private static final Logger logger = LoggerFactory.getLogger(FluentUtil.class);

    public static String get(String url, String headerStr) throws ClientProtocolException, IOException {
        return FluentUtil.get(url, headerStr, 0, 0);
    }

    public static String get(String url, String headerStr, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        connectTimeout = connectTimeout > 0 ? connectTimeout : 30000;
        socketTimeout = socketTimeout > 0 ? socketTimeout : 30000;
        Request request = Request.Get((String)url);
        request = FluentUtil.setHeaders(request, headerStr);
        HttpResponse returnResponse = request.connectTimeout(connectTimeout).socketTimeout(socketTimeout).execute().returnResponse();
        return FluentUtil.handleResponse(returnResponse);
    }

    public static String post(String url, String headerStr, Object params) throws ClientProtocolException, IOException {
        return FluentUtil.post(url, headerStr, params, 0, 0);
    }

    public static String post(String url, String headerStr, Object params, ContentType contentType) throws ClientProtocolException, IOException {
        return FluentUtil.post(url, headerStr, params, 0, 0, contentType);
    }

    private static String post(String url, String headerStr, Object params, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        return FluentUtil.post(url, headerStr, params, connectTimeout, socketTimeout, ContentType.APPLICATION_JSON);
    }

    private static String post(String url, String headerStr, Object params, int connectTimeout, int socketTimeout, ContentType contentType) throws ClientProtocolException, IOException {
        logger.debug("[Fluent Request]:" + url);
        connectTimeout = connectTimeout > 0 ? connectTimeout : 30000;
        socketTimeout = socketTimeout > 0 ? socketTimeout : 30000;
        Request request = Request.Post((String)url);
        request = FluentUtil.setHeaders(request, headerStr);
        String paramStr = "";
        if (BeanUtils.isNotEmpty(params)) {
            paramStr = JsonUtil.toJson(params);
        }
        HttpResponse returnResponse = request.bodyString(paramStr, contentType).connectTimeout(connectTimeout).socketTimeout(socketTimeout).execute().returnResponse();
        return FluentUtil.handleResponse(returnResponse);
    }

    private static Request setHeaders(Request request, String headerStr) {
        if (StringUtil.isNotEmpty(headerStr)) {
            try {
                headerStr = Base64.getFromBase64(headerStr);
                ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(headerStr);
                Iterator it = obj.fieldNames();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    request.setHeader(key, obj.get(key).asText());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return request;
    }

    private static String handleResponse(HttpResponse returnResponse) throws IOException {
        int statusCode = returnResponse.getStatusLine().getStatusCode();
        InputStream content = returnResponse.getEntity().getContent();
        String res = StringUtil.InputStreamToString(content);
        logger.debug("[Fluent Response]:" + res);
        if (statusCode != 200) {
            logger.error("[Fluent Response Error]:{}", (Object)res);
            JsonNode jsonNode = JsonUtil.toJsonNode(res);
            throw new RuntimeException(JsonUtil.getString(jsonNode, "message", res));
        }
        return res;
    }

    public static String getCurAppInterfaceWithHttp(String url, String account) throws ClientProtocolException, IOException {
        return FluentUtil.get(FluentUtil.handleUrl(url), FluentUtil.getAuthHeaderStr(account), 0, 0);
    }

    public static String postCurAppInterfaceWithHttp(String url, String account, Object params) throws ClientProtocolException, IOException {
        return FluentUtil.post(FluentUtil.handleUrl(url), FluentUtil.getAuthHeaderStr(account), params, 0, 0);
    }

    private static String handleUrl(String url) {
        if (FluentUtil.isHttpUrl(url)) {
            return url;
        }
        url = "http://localhost:" + AppUtil.getServerPort() + url;
        return url;
    }

    public static boolean isHttpUrl(String url) {
        Assert.notNull((Object)url, (String)"\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a");
        url = url.toLowerCase();
        String regex = "^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*\u2018().&=+$%-]+: )?[0-9a-z_!~*\u2018().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*\u2018()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,5})?((/?)|(/[0-9a-z_!~*\u2018().;?:@&=+$,%#-]+)+/?)$";
        return url.matches(regex);
    }

    private static String getAuthHeaderStr(String account) throws UnsupportedEncodingException, IOException {
        JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
        String generateToken = jwtTokenHandler.generateToken(account);
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        objectNode.put("Authorization", "Bearer " + generateToken);
        return Base64.getBase64(JsonUtil.toJson(objectNode));
    }
}

