/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.duty.model;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum TeamMemberStatusEnum {
    CANCELLED("CANCELLED", "\u79bb\u804c", "0"),
    NORMAL("NORMAL", "\u5728\u5c97", "1"),
    ONLINE("ONLINE", "\u5728\u7ebf", "2"),
    CROSSING("CROSSING", "\u8d8a\u754c", "3"),
    ABSENT("ABSENT", "\u7f3a\u52e4", "4");

    private String code;
    private String desc;
    private String type;

    private TeamMemberStatusEnum(String code, String desc, String type) {
        this.code = code;
        this.desc = desc;
        this.type = type;
    }

    public static String findByCode(String code) {
        TeamMemberStatusEnum[] values;
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (TeamMemberStatusEnum state : values = TeamMemberStatusEnum.values()) {
            if (!state.getCode().equals(code)) continue;
            return state.getDesc();
        }
        return null;
    }

    public static TeamMemberStatusEnum getByType(String val) {
        TeamMemberStatusEnum[] values = TeamMemberStatusEnum.values();
        Optional<TeamMemberStatusEnum> first = Arrays.stream(values).filter(e -> e.getCode().equals(val)).findFirst();
        return !first.isPresent() ? null : first.get();
    }

    public static String getType(String code) {
        TeamMemberStatusEnum[] values;
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (TeamMemberStatusEnum state : values = TeamMemberStatusEnum.values()) {
            if (!state.getCode().equals(code)) continue;
            return state.getType();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }
}

