/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.base;

import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.context.BaseContext;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class ManageCommonService
implements ApplicationContextAware {
    private ApplicationContext ctx;
    @Resource
    private BaseContext baseContext;
    public static final String orgRoot = "96240625-934F-490B-8AA6-0BC775B18468";
    @Resource
    OrgDao orgDao;
    @Resource
    UserDao userDao;
    @Autowired
    OrgManager orgService;

    public List<Object> findSelectOptions(String name, String query) {
        String beanName = name.substring(0, name.indexOf("."));
        String methodName = name.substring(name.indexOf(".") + 1);
        Object bean = this.ctx.getBean(beanName);
        if (bean != null) {
            if (query != null) {
                return (List)ReflectUtil.invoke((Object)bean, (String)methodName, (Object[])new Object[]{query});
            }
            return (List)ReflectUtil.invoke((Object)bean, (String)methodName, (Object[])new Object[0]);
        }
        return new ArrayList<Object>();
    }

    public Object getfindSelectOptionsLabel(String name, String valueAttribute, String labelAttribute, Object val) {
        List<Object> options = this.findSelectOptions(name, null);
        for (Object o : options) {
            Object v = null;
            v = o instanceof JSONObject ? ((JSONObject)o).get((Object)valueAttribute) : ReflectUtil.getFieldValue((Object)o, (String)valueAttribute);
            if (v == null || !v.equals(val)) continue;
            if (o instanceof JSONObject) {
                return ((JSONObject)o).get((Object)labelAttribute);
            }
            return ReflectUtil.getFieldValue((Object)o, (String)labelAttribute);
        }
        return null;
    }

    public List<Org> findZGJOrg() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PARENT_ID_", (Object)orgRoot);
        return this.orgDao.selectList((Wrapper)queryWrapper);
    }

    public List<TreeNode<String>> getAllOrgTreeNodeList() {
        ArrayList<TreeNode<String>> r = new ArrayList<TreeNode<String>>();
        List rootOrgList = this.orgService.getOrgsByparentId("1");
        if (rootOrgList.size() == 0) {
            rootOrgList = this.orgService.getOrgsByparentId("0");
        }
        Org d = (Org)rootOrgList.get(0);
        TreeNode root = new TreeNode((Object)d.getId(), (Object)"0", d.getName(), (Comparable)Integer.valueOf(d.getOrderNo() != null ? d.getOrderNo().intValue() : 999));
        r.add(root);
        r.addAll(this.findchildrenNode((String)root.getId()));
        return r;
    }

    public List<TreeNode<String>> findchildrenNode(String pid) {
        List childrenOrg = this.orgService.getOrgsByparentId(pid);
        ArrayList<TreeNode<String>> children = new ArrayList<TreeNode<String>>();
        childrenOrg.stream().forEach(child -> {
            TreeNode c = new TreeNode((Object)child.getId(), (Object)pid, child.getName(), (Comparable)Integer.valueOf(child.getOrderNo() != null ? child.getOrderNo().intValue() : 999));
            children.add(c);
            children.addAll(this.findchildrenNode(child.getId()));
        });
        return children;
    }

    public JSONArray getAllUsers(String orgId) {
        JSONArray r = JSONUtil.createArray();
        List users = Lists.newArrayList();
        if (StringUtil.isEmpty((String)orgId)) {
            users = this.userDao.selectList(null);
        } else {
            HashMap map = Maps.newHashMap();
            map.put("orgId", orgId);
            users = this.userDao.getOrgUsers((Map)map);
        }
        for (User u : users) {
            List uOrgs = this.orgDao.getOrgListByUserId(u.getId());
            System.out.println(uOrgs + "===========uOrgs===========" + u.getUserId());
            Org uOrg = null;
            uOrg = uOrgs.size() > 0 ? (Org)uOrgs.get(0) : new Org();
            r.add((Object)JSONUtil.createObj().putOpt("id", (Object)u.getId()).putOpt("fullname", (Object)u.getFullname()).putOpt("account", (Object)u.getAccount()).putOpt("orgId", (Object)uOrg.getId()).putOpt("orgName", (Object)uOrg.getName()));
        }
        return r;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }
}

