/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialPurchasingDao;
import com.artfess.manage.material.manager.CmgtMaterialInfoManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingManager;
import com.artfess.manage.material.model.CmgtMaterialInfo;
import com.artfess.manage.material.model.CmgtMaterialPurchasing;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmgtMaterialPurchasingManagerImpl
extends BaseManagerImpl<CmgtMaterialPurchasingDao, CmgtMaterialPurchasing>
implements CmgtMaterialPurchasingManager {
    @Resource
    private CmgtMaterialPurchasingDao cmgtMaterialPurchasingDao;
    @Resource
    private CmgtMaterialPurchasingDetailManager cmgtMaterialPurchasingDetailManager;
    @Resource
    private CmgtMaterialInfoManager cmgtMaterialInfoManager;

    @Override
    @Transactional(readOnly=false)
    public Boolean deleteById(String id) {
        return this.cmgtMaterialPurchasingDao.deleteById(id);
    }

    @Override
    @Transactional
    public String createInfo(CmgtMaterialPurchasing t) {
        if (t.getStatus() == null) {
            t.setStatus("CREATED");
        }
        int i = ((CmgtMaterialPurchasingDao)this.baseMapper).insert((Object)t);
        ArrayList dlist = new ArrayList();
        t.getDetailList().forEach(d -> {
            d.setPurchasingId(t.getId());
            CmgtMaterialInfo info = this.cmgtMaterialInfoManager.getLikeName(d.getName(), d.getModel());
            if (info != null) {
                d.setMaterialInfoId(info.getId());
            }
            dlist.add(d);
        });
        this.cmgtMaterialPurchasingDetailManager.saveBatch(dlist);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public String updateInfo(CmgtMaterialPurchasing t) {
        if (t.getStatus() == null) {
            t.setStatus("CREATED");
        }
        ((CmgtMaterialPurchasingDao)this.baseMapper).updateById((Object)t);
        this.cmgtMaterialPurchasingDetailManager.deleteByMaterialInfoId(t.getId());
        ArrayList dlist = new ArrayList();
        t.getDetailList().forEach(d -> {
            d.setPurchasingId(t.getId());
            d.setId(null);
            dlist.add(d);
        });
        this.cmgtMaterialPurchasingDetailManager.saveBatch(dlist);
        return t.getId();
    }
}

