/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.monitor.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.manager.DeviceInfoManager;
import com.artfess.device.base.utils.BizUtils;
import com.artfess.device.base.vo.ActGroupVo;
import com.artfess.device.base.vo.BollardResultVo;
import com.artfess.device.monitor.dao.DeviceDataBarricadeDao;
import com.artfess.device.monitor.manager.DeviceDataBarricadeManager;
import com.artfess.device.monitor.model.DeviceDataBarricade;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

@Service
public class DeviceDataBarricadeManagerImpl
extends BaseManagerImpl<DeviceDataBarricadeDao, DeviceDataBarricade>
implements DeviceDataBarricadeManager {
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private DeviceInfoManager deviceInfoManager;

    @Override
    public String batchAct(List<ActGroupVo> list) {
        Assert.notEmpty(list, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List deviceInfos = this.deviceInfoManager.list();
        ArrayList authorityMessage = Lists.newArrayList();
        Iterator<ActGroupVo> it = list.iterator();
        while (it.hasNext()) {
            ActGroupVo vo = it.next();
            deviceInfos.forEach(di -> {
                if (di.getCode().equals(vo.getDeviceCode())) {
                    try {
                        BizUtils.checkLevel(di);
                    }
                    catch (RuntimeException e) {
                        it.remove();
                        authorityMessage.add(",");
                        authorityMessage.add(e.getMessage());
                        return;
                    }
                }
            });
        }
        String url = "/access-open/bollard/act-group.do";
        ResponseEntity result = this.restTemplate.postForEntity(url, list, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)result.getBody();
        if (!body.containsKey((Object)"response_code") || !"0".equals(body.getString("response_code"))) {
            return null;
        }
        List data = JSONObject.parseArray((String)JSONObject.toJSONString((Object)body.getJSONArray("data")), BollardResultVo.class);
        Map<String, ActGroupVo> actGroupVoMap = list.stream().collect(Collectors.toMap(item -> item.getController_id(), item -> item));
        StringBuffer sb = new StringBuffer();
        ArrayList deviceDataBarricades = Lists.newArrayList();
        data.forEach(bollardResultVo -> {
            String controllerId = bollardResultVo.getController_id();
            if (!actGroupVoMap.containsKey(controllerId)) {
                return;
            }
            ActGroupVo actGroupVo = (ActGroupVo)actGroupVoMap.get(controllerId);
            DeviceDataBarricade deviceDataBarricade = new DeviceDataBarricade();
            deviceDataBarricade.setCollTime(LocalDateTime.now());
            deviceDataBarricade.setDeviceCode(actGroupVo.getDeviceCode());
            deviceDataBarricade.setAction(actGroupVo.getAction());
            if ("0".equals(bollardResultVo.getResponse_code())) {
                deviceDataBarricade.setStatus("1");
            } else {
                deviceDataBarricade.setStatus("0");
            }
            deviceDataBarricades.add(deviceDataBarricade);
            sb.append(",");
            sb.append("\u64cd\u4f5c" + actGroupVo.getDeviceName() + bollardResultVo.getResponse_msg());
        });
        authorityMessage.forEach(sb::append);
        this.saveBatch(deviceDataBarricades);
        if (sb.length() > 1) {
            return sb.substring(1);
        }
        return null;
    }

    @Override
    public String lockAct(List<ActGroupVo> vo) {
        User currentUser = ContextUtil.getCurrentUser();
        Assert.notNull((Object)currentUser, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u5f02\u5e38\uff01");
        List deviceInfos = this.deviceInfoManager.list();
        StringBuffer sb = new StringBuffer();
        ArrayList authorityMessage = Lists.newArrayList();
        ArrayList actData = Lists.newArrayList();
        vo.forEach(v -> {
            String action = "20".equals(v.getAction()) ? "\u9501\u5b9a" : "\u89e3\u9501";
            deviceInfos.forEach(di -> {
                if (v.getDeviceCode().equals(di.getCode())) {
                    if (di.getLevel() > currentUser.getUserLevel()) {
                        throw new RuntimeException(action + "\u3010" + di.getName() + "\u3011\u6743\u9650\u4e0d\u8db3\uff1a\u6240\u9700\u7ea7\u522b\u4e3a\u3010" + di.getLevel() + "\u3011\uff0c\u5f53\u524d\u7528\u6237\u3010" + currentUser.getFullname() + "\u3011\u62e5\u6709\u7684\u8bbe\u5907\u64cd\u4f5c\u6743\u9650\u4e3a\u3010" + currentUser.getUserLevel() + "\u3011\uff01");
                    }
                    if ("21".equals(v.getAction()) && di.getLevel().equals(currentUser.getUserLevel()) && !di.getLockUser().equals(currentUser.getAccount())) {
                        throw new RuntimeException(action + "\u3010" + di.getName() + "\u3011\u5931\u8d25\uff1a\u540c\u7ea7\u8bbe\u5907\u53ea\u80fd\u7531\u9501\u5b9a\u4eba\u3010" + di.getLockUser() + "\u3011\u89e3\u9501");
                    }
                    boolean actResult = this.deviceInfoManager.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"code_", (Object)v.getDeviceCode())).set((Object)"IS_LOCK_", (Object)("20".equals(v.getAction()) ? "1" : "0"))).set((Object)"LOCK_USER_", (Object)currentUser.getAccount()));
                    DeviceDataBarricade deviceDataBarricade = new DeviceDataBarricade();
                    deviceDataBarricade.setCollTime(LocalDateTime.now());
                    deviceDataBarricade.setDeviceCode(v.getDeviceCode());
                    deviceDataBarricade.setAction(v.getAction());
                    deviceDataBarricade.setCreateBy(currentUser.getAccount());
                    deviceDataBarricade.setStatus(actResult ? "1" : "0");
                    actData.add(deviceDataBarricade);
                    sb.append(",");
                    sb.append(action + di.getName() + "\uff0c\u72b6\u6001\uff1a" + actResult);
                }
            });
        });
        this.saveBatch(actData);
        authorityMessage.forEach(sb::append);
        if (sb.length() > 1) {
            return sb.substring(1);
        }
        return null;
    }

    @Override
    public CommonResult findByDeviceId(String productType, QueryFilter<DeviceDataBarricade> queryFilter) {
        HashMap data = Maps.newHashMap();
        data.put("productType", productType);
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceDataBarricade> result = ((DeviceDataBarricadeDao)this.baseMapper).findByDeviceId((IPage<DeviceDataBarricade>)this.convert2IPage(pageBean), (Wrapper<DeviceDataBarricade>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        data.put("data", new PageList(result));
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @Transactional(readOnly=true)
    public PageList<DeviceDataBarricade> query(QueryFilter<DeviceDataBarricade> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<DeviceDataBarricade> result = ((DeviceDataBarricadeDao)this.baseMapper).findByDeviceId((IPage<DeviceDataBarricade>)this.convert2IPage(pageBean), (Wrapper<DeviceDataBarricade>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }
}

