/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.manager.DeviceRelationContractManager;
import com.artfess.device.base.model.DeviceBaseContract;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceRelationContract;
import com.artfess.device.base.vo.ContractDeviceVo;
import com.artfess.device.base.vo.ContractVo;
import com.artfess.device.base.vo.DeviceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u8bbe\u5907-\u8bbe\u5907\u5408\u540c\u5173\u8054\u63a5\u53e3"})
@RequestMapping(value={"/device/relation/contract/"})
@ApiGroup(group={"device_biz"})
public class DeviceRelationContractContractController
extends BaseController<DeviceRelationContractManager, DeviceRelationContract> {
    private static final Logger log = LoggerFactory.getLogger(DeviceRelationContractContractController.class);

    @PostMapping(value={"/bindDevice"})
    @ApiOperation(value="\u5408\u540c\u5173\u8054\u8bbe\u5907")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.ADD, description="\u5408\u540c\u5173\u8054\u8bbe\u5907")
    public CommonResult<String> bindDevice(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody ContractVo t) {
        log.info("\u5173\u8054\u8bbe\u5907\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)t));
        ((DeviceRelationContractManager)this.baseService).bindDevice(t);
        return new CommonResult();
    }

    @PostMapping(value={"/getDeviceList"})
    @ApiOperation(value="\u83b7\u53d6\u5408\u540c\u5df2\u5173\u8054\u8bbe\u5907")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u5408\u540c\u5df2\u5173\u8054\u8bbe\u5907")
    public PageList<ContractDeviceVo> getDeviceList(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) {
        return ((DeviceRelationContractManager)this.baseService).getDeviceList(queryFilter);
    }

    @PostMapping(value={"/findByPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5408\u540c\u5173\u8054\u8bbe\u5907")
    public PageList<DeviceVo> findByPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceInfo> queryFilter) {
        return ((DeviceRelationContractManager)this.baseService).findByPage(queryFilter);
    }

    @PostMapping(value={"/bindContract"})
    @ApiOperation(value="\u8bbe\u5907\u5173\u8054\u5408\u540c")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.ADD, description="\u8bbe\u5907\u5173\u8054\u5408\u540c")
    public CommonResult<String> bindContract(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody DeviceVo t) {
        log.info("\u8bbe\u5907\u5173\u8054\u5408\u540c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)t));
        ((DeviceRelationContractManager)this.baseService).bindContract(t);
        return new CommonResult();
    }

    @PostMapping(value={"/getContractList"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u5df2\u5173\u8054\u5408\u540c")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u8bbe\u5907\u5df2\u5173\u8054\u5408\u540c")
    public CommonResult<String> getContractList(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody DeviceVo t) {
        log.info("\u83b7\u53d6\u8bbe\u5907\u5df2\u5173\u8054\u5408\u540c\u8bbe\u5907\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)t));
        DeviceVo base = ((DeviceRelationContractManager)this.baseService).getContractList(t);
        return CommonResult.success((Object)base, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/findByContractPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8bbe\u5907\u5173\u8054\u5408\u540c")
    public PageList<DeviceBaseContract> findByContractPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceBaseContract> queryFilter) {
        return ((DeviceRelationContractManager)this.baseService).findByContractPage(queryFilter);
    }
}

