/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.dao.DeviceBaseContractDao;
import com.artfess.device.base.dao.DeviceRelationContractDao;
import com.artfess.device.base.manager.DeviceRelationContractManager;
import com.artfess.device.base.model.DeviceBaseContract;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceRelationContract;
import com.artfess.device.base.vo.ContractDeviceVo;
import com.artfess.device.base.vo.ContractVo;
import com.artfess.device.base.vo.DeviceVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DeviceRelationContractManagerImpl
extends BaseManagerImpl<DeviceRelationContractDao, DeviceRelationContract>
implements DeviceRelationContractManager {
    @Resource
    private DeviceBaseContractDao contractDao;

    @Override
    public PageList<DeviceVo> findByPage(QueryFilter<DeviceInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceVo> result = ((DeviceRelationContractDao)this.baseMapper).queryPage((IPage<DeviceRelationContract>)this.convert2IPage(pageBean), (Wrapper<DeviceRelationContract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void bindDevice(ContractVo t) {
        Assert.hasText((String)t.getContractId(), (String)"\u8bf7\u9009\u62e9\u8981\u5173\u8054\u7684\u5408\u540c");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id_", (Object)t.getContractId());
        ((DeviceRelationContractDao)this.baseMapper).delete((Wrapper)queryWrapper);
        t.getDeviceList().forEach(deviceInfo -> {
            DeviceRelationContract deviceRelationContract = new DeviceRelationContract();
            deviceRelationContract.setDeviceId(deviceInfo.getId());
            deviceRelationContract.setContractId(t.getContractId());
            ((DeviceRelationContractDao)this.baseMapper).insert((Object)deviceRelationContract);
        });
    }

    @Override
    public PageList<ContractDeviceVo> getDeviceList(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page((long)pageBean.getPage().intValue(), (long)pageBean.getPageSize().intValue());
        Map params = queryFilter.getParams();
        if (params.get("contractId") == null || StringUtil.isEmpty((String)params.get("contractId").toString())) {
            throw new ApplicationException("\u5408\u540cID\u3010contractId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        IPage<ContractDeviceVo> result = ((DeviceRelationContractDao)this.baseMapper).getDeviceList(page, params);
        return new PageList(result);
    }

    @Override
    public void bindContract(DeviceVo t) {
        Assert.hasText((String)t.getDeviceId(), (String)"\u8bf7\u9009\u62e9\u8981\u5173\u8054\u7684\u8bbe\u5907");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"device_id_", (Object)t.getDeviceId());
        ((DeviceRelationContractDao)this.baseMapper).delete((Wrapper)queryWrapper);
        t.getContracts().forEach(contract -> {
            DeviceRelationContract deviceRelationContract = new DeviceRelationContract();
            deviceRelationContract.setDeviceId(t.getDeviceId());
            deviceRelationContract.setContractId(contract.getId());
            ((DeviceRelationContractDao)this.baseMapper).insert((Object)deviceRelationContract);
        });
    }

    @Override
    public DeviceVo getContractList(DeviceVo t) {
        List<DeviceBaseContract> list = this.contractDao.getContractList(t.getDeviceId());
        t.setContracts(list);
        return t;
    }

    @Override
    public PageList<DeviceBaseContract> findByContractPage(QueryFilter<DeviceBaseContract> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceBaseContract> result = ((DeviceRelationContractDao)this.baseMapper).findByContractPage((IPage<DeviceRelationContract>)this.convert2IPage(pageBean), (Wrapper<DeviceRelationContract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

