/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceBaseParamsConfManager;
import com.artfess.device.base.manager.DeviceBaseUserManager;
import com.artfess.device.base.model.DeviceBaseUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u8bbe\u5907-\u5355\u4f4d\u4eba\u5458\u7ba1\u7406"})
@RequestMapping(value={"/device/base/user/"})
@ApiGroup(group={"device_biz"})
public class DeviceBaseUserController
extends BaseController<DeviceBaseUserManager, DeviceBaseUser> {
    private static final Logger log = LoggerFactory.getLogger(DeviceBaseUserController.class);
    @Autowired
    private DeviceBaseParamsConfManager deviceBaseParamsConfManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) DeviceBaseUser t) {
        boolean result = ((DeviceBaseUserManager)this.baseService).save((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        this.deviceBaseParamsConfManager.saveParamsValue(t.getParamsValueList(), t.getId());
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) DeviceBaseUser t) {
        boolean result = ((DeviceBaseUserManager)this.baseService).updateById((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        this.deviceBaseParamsConfManager.saveParamsValue(t.getParamsValueList(), t.getId());
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<DeviceBaseUser> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceBaseUser> queryFilter) {
        return ((DeviceBaseUserManager)this.baseService).findByPage(queryFilter);
    }
}

