/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.colmap;

import com.artfess.table.model.Column;
import com.artfess.table.model.impl.DefaultColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class SQLServerColumnMap
implements RowMapper<Column> {
    public Column mapRow(ResultSet rs, int row) throws SQLException {
        DefaultColumn column = new DefaultColumn();
        String name = rs.getString("NAME");
        String is_nullable = rs.getString("IS_NULLABLE");
        String data_type = rs.getString("TYPENAME");
        String length = rs.getString("LENGTH");
        String precisions = rs.getString("PRECISION");
        String scale = rs.getString("SCALE");
        String tableName = rs.getString("TABLE_NAME");
        String comments = rs.getString("DESCRIPTION");
        int isPK = rs.getInt("IS_PK");
        int iLength = StringUtils.isEmpty((String)length) ? 0 : Integer.parseInt(length);
        int iPrecisions = StringUtils.isEmpty((String)precisions) ? 0 : Integer.parseInt(precisions);
        int iScale = StringUtils.isEmpty((String)scale) ? 0 : Integer.parseInt(scale);
        column.setFieldName(name);
        boolean isNull = is_nullable.equals("1");
        column.setIsNull(isNull);
        column.setTableName(tableName);
        column.setComment(comments);
        column.setIsPk(isPK == 1);
        this.setType(data_type, iLength, iPrecisions, iScale, column);
        return column;
    }

    private void setType(String dbtype, int length, int precision, int scale, Column columnModel) {
        if (dbtype.equals("int")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("bigint")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("smallint")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("tinyint")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("bit")) {
            columnModel.setColumnType("number");
            return;
        }
        if (dbtype.equals("decimal")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("numeric")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("real")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            return;
        }
        if (dbtype.equals("float")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            return;
        }
        if (dbtype.equals("varchar")) {
            columnModel.setColumnType("varchar");
            columnModel.setCharLen(length);
            return;
        }
        if (dbtype.equals("char")) {
            columnModel.setColumnType("varchar");
            columnModel.setCharLen(length);
            return;
        }
        if (dbtype.equals("varchar")) {
            columnModel.setColumnType("varchar");
            columnModel.setCharLen(length);
            return;
        }
        if (dbtype.equals("nchar")) {
            columnModel.setColumnType("varchar");
            columnModel.setCharLen(length);
            return;
        }
        if (dbtype.equals("nvarchar")) {
            columnModel.setColumnType("varchar");
            columnModel.setCharLen(length);
            return;
        }
        if (dbtype.startsWith("datetime")) {
            columnModel.setColumnType("date");
            return;
        }
        if (dbtype.endsWith("money")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.endsWith("smallmoney")) {
            columnModel.setColumnType("clob");
            columnModel.setIntLen(precision);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.endsWith("text")) {
            columnModel.setColumnType("clob");
            columnModel.setCharLen(length);
            return;
        }
        if (dbtype.endsWith("ntext")) {
            columnModel.setColumnType("clob");
            columnModel.setCharLen(length);
            return;
        }
    }
}

