/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.UpdateMethod;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.dao.OrgUserDao;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgAuthManager;
import com.artfess.uc.manager.OrgJobManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgParamsManager;
import com.artfess.uc.manager.OrgPostManager;
import com.artfess.uc.manager.OrgRoleManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.UserImportManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserUnderManager;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgAuth;
import com.artfess.uc.model.OrgJob;
import com.artfess.uc.model.OrgParams;
import com.artfess.uc.model.OrgPost;
import com.artfess.uc.model.OrgRole;
import com.artfess.uc.model.OrgTree;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserUnder;
import com.artfess.uc.params.common.OrgExportObject;
import com.artfess.uc.params.group.GroupIdentity;
import com.artfess.uc.params.org.OaAsyncObject;
import com.artfess.uc.params.org.OrgAuthVo;
import com.artfess.uc.params.org.OrgPostVo;
import com.artfess.uc.params.org.OrgUserVo;
import com.artfess.uc.params.org.OrgVo;
import com.artfess.uc.params.orgRole.OrgRoleVo;
import com.artfess.uc.params.post.PostDueVo;
import com.artfess.uc.params.user.UserUnderVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.AuthFilterUtil;
import com.artfess.uc.util.ContextUtil;
import com.artfess.uc.util.OrgUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"/api/org/v1/"})
@Api(tags={"\u7ec4\u7ec7\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class OrgController
extends BaseController<OrgManager, Org> {
    @Autowired
    OrgManager orgService;
    @Autowired
    DemensionManager demService;
    @Autowired
    OrgPostManager postService;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    UserUnderManager userUnderService;
    @Autowired
    UserImportManager userImportService;
    @Resource
    OrgRoleManager orgRoleService;
    @Autowired
    OrgAuthManager orgAuthService;
    @Autowired
    OrgJobManager orgJobManager;
    @Autowired
    OrgUserManager orgUserManager;
    @Autowired
    UserManager userService;
    @Resource
    OrgParamsManager orgParamsService;
    @Resource
    OrgUserDao orgUserDao;

    @RequestMapping(value={"orgUser/deleteOrgById"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u548c\u7528\u6237id\u5220\u9664\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\uff0c\u5e76\u5c97\u4f4did\u4e3a\u7a7a", httpMethod="DELETE", notes="\u6839\u636e\u7ec4\u7ec7id\u548c\u7528\u6237id\u5220\u9664\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\uff0c\u5e76\u5c97\u4f4did\u4e3a\u7a7a")
    public CommonResult<String> deleteOrgById(@ApiParam(name="orgId", value="\u7ec4\u7ec7id", required=true) @RequestParam String orgId, @ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        return this.orgUserService.deleteOrgById(orgId, userId);
    }

    @RequestMapping(value={"orgs/getOrgPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    public PageList<Org> getOrgPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Org> queryFilter) throws Exception {
        PageList list = this.orgService.query(queryFilter);
        return list;
    }

    @RequestMapping(value={"org/addOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7", httpMethod="POST", notes="\u6dfb\u52a0\u7ec4\u7ec7")
    public CommonResult<String> addOrg(@ApiParam(name="orgVo", value="\u7ec4\u7ec7\u89c6\u56fe", required=true) @RequestBody OrgVo orgVo) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgService.addOrg(orgVo);
        }
        catch (Exception e) {
            rtn = new CommonResult(false, e.getMessage(), (Object)"\u4fdd\u5b58\u5931\u8d25");
        }
        return rtn;
    }

    @RequestMapping(value={"org/deleteOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u5220\u9664\u7ec4\u7ec7", httpMethod="POST", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u5220\u9664\u7ec4\u7ec7\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09\uff0c\u8fde\u540c\u5176\u5b50\u7ec4\u7ec7\u3001\u7ec4\u7ec7\u53c2\u6570\u3001\u5c97\u4f4d\u3001\u7ec4\u7ec7\u4eba\u5458\u5173\u7cfb\u53ca\u5bf9\u5e94\u4e0b\u5c5e\u4e00\u8d77\u5220\u9664")
    public CommonResult<String> deleteOrg(@ApiParam(name="codes", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestBody String codes) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgService.deleteOrg(codes);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = new CommonResult(false, e.getMessage(), (Object)"\u4fdd\u5b58\u5931\u8d25");
        }
        return rtn;
    }

    @RequestMapping(value={"org/updateOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7", httpMethod="POST", notes="\u4fee\u6539\u7ec4\u7ec7")
    @UpdateMethod(type=OrgVo.class)
    public CommonResult<String> updateOrg(@ApiParam(name="orgVo", value="\u7ec4\u7ec7\u89c6\u56fe", required=true) @RequestBody OrgVo orgVo) throws Exception {
        return this.orgService.updateOrg(orgVo);
    }

    @RequestMapping(value={"org/getOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7")
    public Org getOrg(@ApiParam(name="code", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        Org org = this.orgService.getOrg(code);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgCode", code);
        map.put("group", "true");
        List list = this.orgUserDao.getUserNumByOrgCode(map);
        org.setNowNum(list.size());
        return org;
    }

    @RequestMapping(value={"org/getOrgLimitByCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7\u9650\u7f16", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7\u9650\u7f16")
    public PageList<Org> getOrgLimitByCodes(@ApiParam(name="codes", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String codes) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("code", (Object)codes, QueryOP.IN, FieldRelation.AND, "group_1");
        PageList query = this.orgService.query(queryFilter);
        if (BeanUtils.isNotEmpty((Object)query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
            for (Org org : query.getRows()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgCode", org.getCode());
                map.put("group", "true");
                List list = this.orgUserDao.getUserNumByOrgCode(map);
                org.setNowNum(list.size());
            }
        }
        return query;
    }

    @RequestMapping(value={"org/get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u83b7\u53d6\u7ec4\u7ec7", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7id\u83b7\u53d6\u7ec4\u7ec7")
    public Org get(@ApiParam(name="id", value="\u7ec4\u7ec7id", required=true) @RequestParam String id) throws Exception {
        Org org = (Org)this.orgService.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)org)) {
            org = this.orgService.getByCode(id);
        }
        return org;
    }

    @RequestMapping(value={"org/getOrgMaster"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u7528\u6237\u4e3b\u7ec4\u7ec7", httpMethod="GET", notes="\u6839\u636e\u5f53\u524d\u7528\u6237\u4e3b\u7ec4\u7ec7")
    public Org getOrgMaster() throws Exception {
        return this.orgService.getOrgMaster(ContextUtil.getCurrentUser().getAccount());
    }

    @RequestMapping(value={"orgParam/saveOrgParams"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u53c2\u6570", httpMethod="POST", notes="\u4fdd\u5b58\u7ec4\u7ec7\u53c2\u6570\uff0c\u53c2\u6570params\u683c\u5f0f[{\"alias\":\"a1\",\"value\":\"v1\"},{\"alias\":\"a2\",\"value\":\"v2\"}]")
    public CommonResult<String> saveOrgParams(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="params", value="\u53c2\u6570\u503c", required=true) @RequestBody List<ObjectNode> params) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgService.saveOrgParams(orgCode, params);
        }
        catch (Exception e) {
            rtn = new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25,\u8bf7\u5c06\u53c2\u6570\u586b\u5199\u5b8c\u6574", (Object)e.getMessage());
        }
        return rtn;
    }

    @RequestMapping(value={"orgParam/getOrgParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570")
    public List<OrgParams> getOrgParams(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        return this.orgService.getOrgParams(orgCode);
    }

    @RequestMapping(value={"orgParam/getParamByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u53c2\u6570", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u548c\u53c2\u6570\u522b\u540d\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570")
    public CommonResult<OrgParams> getParamByAlias(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u4ee3\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="alias", value="\u53c2\u6570\u4ee3\u7801", required=true) @RequestParam String alias) throws Exception {
        return this.orgService.getParamByAlias(orgCode, alias);
    }

    @RequestMapping(value={"orgUser/addOrgUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u5165\u7528\u6237", httpMethod="POST", notes="\u5411\u7ec4\u7ec7\u4e2d\u52a0\u5165\u7cfb\u7edf\u5df2\u6709\u7684\u7528\u6237")
    public CommonResult<String> addOrgUser(@ApiParam(name="orgUserVo", value="\u7ec4\u7ec7\u7528\u6237", required=true) @RequestBody OrgUserVo orgUserVo) throws Exception {
        return this.orgService.addOrgUser(orgUserVo);
    }

    @RequestMapping(value={"orgUser/addOrgUserByCode"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65b0\u589e\u7528\u6237\u662f\u7ed9\u7528\u6237\u8bbe\u7f6e\u7ec4\u7ec7", httpMethod="POST", notes="\u65b0\u589e\u7528\u6237\u662f\u7ed9\u7528\u6237\u8bbe\u7f6e\u7ec4\u7ec7")
    public CommonResult<String> addOrgUserByCode(@ApiParam(name="account", value="\u7ec4\u7ec7\u7528\u6237", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        String[] orgCodes;
        for (String code : orgCodes = orgCode.split(",")) {
            OrgUserVo orgUserVo = new OrgUserVo();
            orgUserVo.setAccount(account);
            orgUserVo.setOrgCode(code);
            this.orgService.addOrgUser(orgUserVo);
        }
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"orgUser/delOrgUser"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u53d6\u6d88\u52a0\u5165\u7ec4\u7ec7", httpMethod="DELETE", notes="\u7528\u6237\u53d6\u6d88\u52a0\u5165\u7ec4\u7ec7\uff0cids\u4e3a\u7528\u6237\u7ec4\u7ec7\u5173\u7cfbid\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> delOrgUser(@ApiParam(name="ids", value="\u7528\u6237\u7ec4\u7ec7\u5173\u7cfbid\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        return this.orgService.delOrgUser(ids);
    }

    @RequestMapping(value={"orgUser/getUserIsMaster"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u4e3b\u7ec4\u7ec7", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u4e3b\u7ec4\u7ec7")
    public CommonResult<Boolean> getUserIsMaster(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String demCode) throws Exception {
        return this.orgService.getUserIsMaster(account, demCode);
    }

    @RequestMapping(value={"orgPost/setMaster"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4eba\u5458\uff08\u53d6\u6d88\uff09\u4e3b\u5c97\u4f4d", httpMethod="PUT", notes="\u8bbe\u7f6e\u4eba\u5458\uff08\u53d6\u6d88\uff09\u4e3b\u5c97\u4f4d")
    public CommonResult<String> setMaster(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode) throws Exception {
        return this.orgService.setMaster(account, postCode);
    }

    @RequestMapping(value={"orgs/getTreeDataByDem"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6811", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u6811")
    public List<OrgTree> getTreeDataByDem(@ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String demCode, @ApiParam(name="pOrgCode", value="\u7236\u7ec4\u7ec7\u7f16\u7801", required=false) @RequestParam(required=false) String pOrgCode) throws Exception {
        return this.orgService.getTreeDataByDem(demCode, pOrgCode);
    }

    @RequestMapping(value={"orgUser/setOrgCharge"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\uff08\u53d6\u6d88\uff09\uff08\u4e3b\uff09\u8d1f\u8d23\u4eba", httpMethod="PUT", notes="isCharge\u4e3atrue\u8868\u793a\u8bbe\u7f6e\u4e3b\u8d1f\u8d23\u4eba\uff0c\u4e3afalse\u65f6\uff0c\u82e5\u6b64\u65f6\u4e3a\u8d1f\u8d23\u4eba\uff0c\u5219\u964d\u4e3a\u975e\u8d1f\u8d23\u4eba")
    public CommonResult<String> setOrgCharge(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="isCharge", value="\u662f\u5426\u8bbe\u7f6e\u4e3b\u8d1f\u8d23\u4eba", required=true) @RequestParam Boolean isCharge) throws Exception {
        return this.orgService.setOrgCharge(account, orgCode, isCharge);
    }

    @RequestMapping(value={"userUnder/addUserUnders"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ec4\u7ec7\u4eba\u5458\u6dfb\u52a0\u4e0b\u5c5e", httpMethod="POST", notes="\u7ec4\u7ec7\u4eba\u5458\u6dfb\u52a0\u4e0b\u5c5e")
    public CommonResult<String> addUserUnders(@ApiParam(name="userUnder", value="\u4e0b\u5c5e\u7528\u6237", required=true) @RequestBody UserUnderVo userUnder) throws Exception {
        return this.orgService.addUserUnders(userUnder);
    }

    @RequestMapping(value={"userUnder/delUserUnders"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ec4\u7ec7\u4eba\u5458\u5220\u9664\u4e0b\u5c5e", httpMethod="DELETE", notes="\u7ec4\u7ec7\u4eba\u5458\u5220\u9664\u4e0b\u5c5e")
    public CommonResult<String> delUserUnders(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        return this.orgService.delUserUnders(account, orgCode);
    }

    @RequestMapping(value={"userUnder/getUserUnders"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5728\u67d0\u7ec4\u7ec7\u4e0b\u7684\u4e0b\u5c5e", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5728\u67d0\u7ec4\u7ec7\u4e0b\u7684\u4e0b\u5c5e")
    public List<UserVo> getUserUnders(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        return this.orgService.getUserUnders(account, orgCode);
    }

    @RequestMapping(value={"userUnder/getUserUndersPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5728\u67d0\u7ec4\u7ec7\u4e0b\u7684\u4e0b\u5c5e(\u542b\u5206\u9875)", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5728\u67d0\u7ec4\u7ec7\u4e0b\u7684\u4e0b\u5c5e(\u542b\u5206\u9875)", hidden=true)
    public PageList<UserUnder> getUserUndersPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter filter) throws Exception {
        Page list = (Page)this.userUnderService.getUserUnder(filter);
        return new PageList((IPage)list);
    }

    @RequestMapping(value={"userUnder/delUnderUserByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u4e0b\u5c5e", httpMethod="DELETE", notes="\u6839\u636eid\u5220\u9664\u4e0b\u5c5e\uff0c\u591a\u4e2a\u7528\u6237\u9017\u53f7\u9694\u5f00", hidden=true)
    public CommonResult<String> delUnderUserByIds(@ApiParam(name="ids", value="\u8bb0\u5f55id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        String[] idArr = ids.split(",");
        this.userUnderService.removeByIds(idArr);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"orgAuth/saveOrgAuth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u5206\u7ea7\u7ba1\u7406", httpMethod="POST", notes="\u6dfb\u52a0\u5206\u7ea7\u7ba1\u7406")
    public CommonResult<String> saveOrgAuth(@ApiParam(name="orgAuthVo", value="\u5206\u7ea7\u7ec4\u7ec7\u7ba1\u7406", required=true) @RequestBody OrgAuthVo orgAuthVo) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgService.saveOrgAuth(orgAuthVo);
        }
        catch (Exception e) {
            rtn = new CommonResult(false, e.getMessage(), (Object)"\u4fdd\u5b58\u5931\u8d25");
        }
        return rtn;
    }

    @RequestMapping(value={"orgAuth/deleteOrgAuth"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u5206\u7ea7\u7ba1\u7406", httpMethod="DELETE", notes="\u5220\u9664\u5206\u7ea7\u7ba1\u7406")
    public CommonResult<String> deleteOrgAuth(@ApiParam(name="id", value="\u5206\u7ea7\u7ba1\u7406id", required=true) @RequestParam String id) throws Exception {
        return this.orgService.deleteOrgAuth(id);
    }

    @RequestMapping(value={"orgAuths/getOrgAuthList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406\u5217\u8868")
    public PageList<OrgAuth> getOrgAuthList(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false) @RequestParam(required=false) String orgCode, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=false) @RequestParam(required=false) String demCode) throws Exception {
        Page<OrgAuth> list = this.orgService.getOrgAuthList(account, orgCode, demCode);
        return new PageList(list);
    }

    @RequestMapping(value={"orgAuth/getOrgAuth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406")
    public OrgAuth getOrgAuth(@ApiParam(name="id", value="\u5206\u7ea7\u7ba1\u7406id", required=true) @RequestParam String id) throws Exception {
        return this.orgService.getOrgAuth(id);
    }

    @RequestMapping(value={"orgs/getByParentId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b50\u7ec4\u7ec7", httpMethod="GET", notes="\u6839\u636e\u7236\u7ec4\u7ec7id\u83b7\u53d6\u5b50\u7ec4\u7ec7")
    public List<Org> getByParentId(@ApiParam(name="parentId", value="\u7236\u7ec4\u7ec7id", required=true) @RequestParam String parentId) throws Exception {
        if (BeanUtils.isEmpty((Object)this.orgService.get((Serializable)((Object)parentId)))) {
            throw new RuntimeException("\u6839\u636e\u7ec4\u7ec7id\u3010" + parentId + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7");
        }
        return this.orgService.getByParentId(parentId);
    }

    @RequestMapping(value={"orgs/getOrgsByparentId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b50\u7ec4\u7ec7(\u53ea\u83b7\u53d6\u5e95\u4e0b\u4e00\u5c42\u5b50\u7ec4\u7ec7)", httpMethod="GET", notes="\u6839\u636e\u7236\u7ec4\u7ec7id\u83b7\u53d6\u5b50\u7ec4\u7ec7")
    public List<Org> getOrgsByparentId(@ApiParam(name="parentId", value="\u7236\u7ec4\u7ec7id", required=true) @RequestParam String parentId) throws Exception {
        return this.orgService.getOrgsByparentId(parentId);
    }

    @RequestMapping(value={"orgs/getUserOrgs"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\uff08\u4e3b\uff09\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\uff08\u4e3b\uff09\u7ec4\u7ec7")
    public List<Org> getUserOrgs(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=false) @RequestParam(required=false) String demCode, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u7ec4\u7ec7", required=false) @RequestParam(required=false) Boolean isMain) throws Exception {
        return this.orgService.getUserOrgs(account, demCode, isMain);
    }

    @RequestMapping(value={"orgs/getOrgsByAccount"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7")
    public List<Org> getOrgsByAccount(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account) throws Exception {
        return this.orgService.getOrgsByAccount(account);
    }

    @RequestMapping(value={"orgs/getOrgListByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7")
    public List<Org> getOrgListByUserId(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        return this.orgService.getOrgListByUserId(userId);
    }

    @RequestMapping(value={"orgs/getUserOrgPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7")
    public PageList<HashMap<String, Object>> getUserOrgPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter filter) throws Exception {
        IPage p = this.orgUserService.getUserOrgPage(filter);
        return new PageList(p);
    }

    @RequestMapping(value={"orgUsers/getUsersByOrgCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u4eba\u5458", httpMethod="GET", notes=" \u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u4eba\u5458\uff0corgCodes\u7ec4\u7ec7\u7f16\u7801\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public List<UserVo> getUsersByOrgCodes(@ApiParam(name="orgCodes", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCodes, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u5c97\u4f4d", required=false) @RequestParam(required=false) Boolean isMain) throws Exception {
        return this.orgService.getUsersByOrgCodes(orgCodes, isMain);
    }

    @RequestMapping(value={"orgUsers/getChargesByOrgId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u7ec4\u7ec7\u7684\u8d1f\u8d23\u4eba\u7ec4\u7ec7\u5173\u7cfb", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u7ec4\u7ec7\u7684\u8d1f\u8d23\u4eba\u7ec4\u7ec7\u5173\u7cfb")
    public List<User> getChargesByOrgId(@ApiParam(name="orgId", value="\u7ec4\u7ec7id", required=true) @RequestParam String orgId, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u7ec4\u7ec7", required=false) @RequestParam(required=false) Boolean isMain, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801\uff08\u4e0d\u4f20\u5219\u4e3a\u9ed8\u8ba4\u7ef4\u5ea6\uff09", required=false) @RequestParam(required=false) Boolean demCode) throws Exception {
        List<OrgPost> mainPost;
        ArrayList<User> users = new ArrayList();
        Org org = (Org)this.orgService.get((Serializable)((Object)orgId));
        if (BeanUtils.isEmpty((Object)org) && BeanUtils.isNotEmpty((Object)(org = this.orgService.getByCode(orgId)))) {
            orgId = org.getId();
        }
        if (BeanUtils.isNotEmpty(mainPost = this.postService.getRelCharge(orgId, true))) {
            users = this.userService.getListByPostId(mainPost.get(0).getId());
        } else {
            List<OrgUser> orgUsers = this.orgUserManager.getChargesByOrgId(orgId, isMain);
            if (BeanUtils.isNotEmpty(orgUsers)) {
                HashSet<String> userIds = new HashSet<String>();
                for (OrgUser orgUser : orgUsers) {
                    User user;
                    if (userIds.contains(orgUser.getUserId()) || !BeanUtils.isNotEmpty((Object)(user = (User)this.userService.get((Serializable)((Object)orgUser.getUserId()))))) continue;
                    userIds.add(orgUser.getUserId());
                    users.add(user);
                }
            }
        }
        return users;
    }

    @RequestMapping(value={"orgPosts/getPostsByOrgCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u5c97\u4f4d", httpMethod="GET", notes=" \u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u5c97\u4f4d\uff0corgCodes\u7ec4\u7ec7\u7f16\u7801\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public List<OrgPost> getPostsByOrgCodes(@ApiParam(name="orgCodes", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCodes, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u5c97\u4f4d", required=false) @RequestParam(required=false) Boolean isMain) throws Exception {
        return this.orgService.getPostsByOrgCodes(orgCodes, isMain);
    }

    @RequestMapping(value={"orgPosts/getOrgPostPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u5217\u8868\uff08\u5206\u9875\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5c97\u4f4d\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<OrgPost> getOrgPostPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        String postAuthSql = AuthFilterUtil.getPostAuthSql();
        if (StringUtil.isNotEmpty((String)postAuthSql)) {
            queryFilter.addParams("authSql", (Object)postAuthSql);
        }
        return this.postService.getOrgPost(queryFilter);
    }

    @RequestMapping(value={"orgs/getByLevel"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u6839\u636e\u7ea7\u522b\u83b7\u53d6\u7ec4\u7ec7", httpMethod="GET", notes=" \u6839\u636e\u7ea7\u522b\u83b7\u53d6\u7ec4\u7ec7")
    public List<Org> getByLevel(@ApiParam(name="level", value="\u7ec4\u7ec7\u7ea7\u522b", required=true) @RequestParam String level, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=false) @RequestParam(required=false) String demCode) throws Exception {
        return this.orgService.getByLevel(level, demCode);
    }

    @RequestMapping(value={"userPost/saveUserPost"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7528\u6237\u52a0\u5165\u5230\u5c97\u4f4d", httpMethod="POST", notes=" \u7528\u6237\u52a0\u5165\u5230\u5c97\u4f4d\uff0caccounts\u7528\u6237\u5e10\u53f7\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> saveUserPost(@ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String accounts, @ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode) throws Exception {
        return this.orgService.saveUserPost(accounts, postCode);
    }

    @RequestMapping(value={"userPost/saveUserPosts"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7528\u6237\u52a0\u5165\u5230\u5c97\u4f4d", httpMethod="POST", notes=" \u7528\u6237\u52a0\u5165\u5230\u5c97\u4f4d\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> saveUserPosts(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="postCodes", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCodes) throws Exception {
        return this.orgService.saveUserPosts(account, postCodes);
    }

    @RequestMapping(value={"userPost/delUserPost"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7528\u6237\u9000\u51fa\u5c97\u4f4d", httpMethod="DELETE", notes=" \u7528\u6237\u9000\u51fa\u5c97\u4f4d\uff0caccounts\u7528\u6237\u5e10\u53f7\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> delUserPost(@ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String accounts, @ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode) throws Exception {
        return this.orgService.delUserPost(accounts, postCode);
    }

    @RequestMapping(value={"orgPost/saveOrgPost"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7ec4\u7ec7\u6dfb\u52a0\u5c97\u4f4d", httpMethod="POST", notes=" \u7ec4\u7ec7\u6dfb\u52a0\u5c97\u4f4d")
    public CommonResult<String> saveOrgPost(@ApiParam(name="orgPostVo", value="\u7ec4\u7ec7\u5c97\u4f4d", required=true) @RequestBody OrgPostVo orgPostVo) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgService.saveOrgPost(orgPostVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = new CommonResult(false, e.getMessage(), (Object)"\u4fdd\u5b58\u5931\u8d25");
        }
        return rtn;
    }

    @RequestMapping(value={"orgPost/addOrgPostFromExterUni"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u5c97\u4f4d\u6570\u636e\u6dfb\u52a0\u5230\u672c\u7cfb\u7edf", httpMethod="POST", notes=" \u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u5c97\u4f4d\u6570\u636e\u6dfb\u52a0\u5230\u672c\u7cfb\u7edf")
    public CommonResult<String> addOrgPostFromExterUni(@ApiParam(name="orgPostVo", value="\u7ec4\u7ec7\u5c97\u4f4d", required=true) @RequestBody OrgPost orgPostVo) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgService.addOrgPostFromExterUni(orgPostVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = new CommonResult(false, e.getMessage(), (Object)"\u4fdd\u5b58\u5931\u8d25");
        }
        return rtn;
    }

    @RequestMapping(value={"orgPost/updateOrgPost"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u5c97\u4f4d", httpMethod="POST", notes="\u66f4\u65b0\u5c97\u4f4d")
    public CommonResult<String> updateOrgPost(@ApiParam(name="orgPostVo", value="\u7ec4\u7ec7\u5c97\u4f4d", required=true) @RequestBody OrgPostVo orgPostVo) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgService.updateOrgPost(orgPostVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = new CommonResult(false, e.getMessage(), (Object)"\u4fdd\u5b58\u5931\u8d25");
        }
        return rtn;
    }

    @RequestMapping(value={"orgPost/getOrgPost"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u6839\u636e\u5c97\u4f4did\u6216\u7f16\u7801\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f", httpMethod="GET", notes=" \u6839\u636e\u5c97\u4f4d\u7f16\u7801\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f")
    public CommonResult<OrgPost> getOrgPost(@ApiParam(name="postCode", value="\u5c97\u4f4d\u4ee3\u7801", required=true) @RequestParam String postCode) throws Exception {
        OrgPost p = this.postService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)p)) {
            p = (OrgPost)this.postService.get((Serializable)((Object)postCode));
        }
        return new CommonResult(true, "\u83b7\u53d6\u5c97\u4f4d\u6210\u529f", (Object)p);
    }

    @RequestMapping(value={"orgPost/getOrgPostByUserAccount"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u6240\u5c5e\u5c97\u4f4d", httpMethod="GET", notes=" \u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u6240\u5c5e\u5c97\u4f4d")
    public List<OrgPost> getOrgPostByUserAccount(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account) throws Exception {
        List<OrgPost> list = this.postService.getListByAccount(account, null);
        return list;
    }

    @RequestMapping(value={"orgPost/deleteOrgPost"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u5220\u9664\u7ec4\u7ec7\u5c97\u4f4d", httpMethod="DELETE", notes=" \u5220\u9664\u7ec4\u7ec7\u5c97\u4f4d\uff0c\u8fde\u540c\u5c97\u4f4d\u4e0b\u7684\u4eba\u5458\u4fe1\u606f\u4e00\u8d77\u5220\u9664\uff0cpostCodes\u5c97\u4f4d\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> deleteOrgPost(@ApiParam(name="postCodes", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCodes) throws Exception {
        return this.orgService.deleteOrgPost(postCodes);
    }

    @RequestMapping(value={"orgPost/setPostMaster"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u8bbe\u7f6e\u7ec4\u7ec7\uff08\u53d6\u6d88\uff09\u8d23\u4efb\u5c97\u4f4d", httpMethod="PUT", notes=" \u8bbe\u7f6e\u7ec4\u7ec7\uff08\u53d6\u6d88\uff09\u8d23\u4efb\u5c97\u4f4d")
    public CommonResult<String> setPostMaster(@ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode, @ApiParam(name="isMain", value="\u662f\u5426\u8d23\u4efb\u5c97\u4f4d", required=true) @RequestParam Boolean isMain) throws Exception {
        return this.orgService.setPostMaster(postCode, isMain);
    }

    @RequestMapping(value={"userPost/setUserPostDueTime"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u8bbe\u7f6e\u4eba\u5458\u5c97\u4f4d\u6709\u6548\u671f", httpMethod="PUT", notes=" \u8bbe\u7f6e\u4eba\u5458\u5c97\u4f4d\u6709\u6548\u671f")
    public CommonResult<String> setUserPostDueTime(@ApiParam(name="postDueVo", value="\u4eba\u5458\u5c97\u4f4d\u6709\u6548\u671f", required=true) @RequestBody PostDueVo postDueVo) throws Exception {
        return this.orgService.setUserPostDueTime(postDueVo);
    }

    @RequestMapping(value={"userPost/validOrgUser"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u6821\u9a8c\u6240\u6709\u7528\u6237\u5c97\u4f4d\u662f\u5426\u6709\u6548", httpMethod="PUT", notes=" \u6821\u9a8c\u6240\u6709\u7528\u6237\u5c97\u4f4d\u662f\u5426\u6709\u6548")
    public CommonResult<String> validOrgUser() throws Exception {
        return this.orgService.validOrgUser();
    }

    @RequestMapping(value={"orgRole/addOrgRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7ec4\u7ec7\u6dfb\u52a0\u89d2\u8272", httpMethod="POST", notes=" \u7ec4\u7ec7\u6dfb\u52a0\u89d2\u8272")
    public CommonResult<String> addOrgRole(@ApiParam(name="orgRoleVo", value="\u7ec4\u7ec7\u89d2\u8272", required=true) @RequestBody OrgRoleVo orgRoleVo) throws Exception {
        this.orgService.addOrgRole(orgRoleVo);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"orgRole/delOrgRoleByCode"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u5220\u9664\u7ec4\u7ec7\u6307\u5b9a\u89d2\u8272", httpMethod="DELETE", notes=" \u5220\u9664\u7ec4\u7ec7\u6307\u5b9a\u89d2\u8272\uff0croleCodes\u89d2\u8272\u7f16\u7801\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> delOrgRoleByCode(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="roleCodes", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String roleCodes) throws Exception {
        this.orgService.delOrgRoleByCode(orgCode, roleCodes);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"orgRole/delAllOrgRole"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u5220\u9664\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u89d2\u8272", httpMethod="DELETE", notes=" \u5220\u9664\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u89d2\u8272")
    public CommonResult<String> delAllOrgRole(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        this.orgService.delAllOrgRole(orgCode);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"orgRoles/getOrgRoleByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u83b7\u53d6\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u89d2\u8272", httpMethod="GET", notes=" \u83b7\u53d6\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u89d2\u8272\uff0c\u82e5\u81ea\u8eab\u6709\u89d2\u8272\u5219\u8fd4\u56de\u81ea\u8eab\u7684\u89d2\u8272\uff0c\u82e5\u81ea\u8eab\u6ca1\u6709\u89d2\u8272\uff0c\u5219\u8fd4\u56de\u6700\u8fd1\u7684\u7236\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u53ef\u7ee7\u627f\u7684\u89d2\u8272")
    public List<Role> getOrgRoleByCode(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        return this.orgService.getOrgRoleByCode(orgCode);
    }

    @RequestMapping(value={"org/deleteOrgPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ec4\u7ec7\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ec4\u7ec7\u6570\u636e")
    public CommonResult<Integer> deleteOrgPhysical() throws Exception {
        Integer num = this.orgService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"org/deletePostPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u5c97\u4f4d\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u5c97\u4f4d\u6570\u636e")
    public CommonResult<Integer> deletePostPhysical() throws Exception {
        Integer num = this.orgService.removePostPhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"org/deleteOrgUserPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e")
    public CommonResult<Integer> deleteOrgUserPhysical() throws Exception {
        Integer num = this.orgService.removeOrgUserPhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"orgs/getByParentAndDem"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6id  \u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u4e0b\u7684\u7ec4\u7ec7", httpMethod="POST", notes="\u6839\u636e\u7ef4\u5ea6id\u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u4e0b\u7684\u7ec4\u7ec7\uff0c\u53c2\u6570{\"demId\":\"1\",\"parentId\":\"1\"}")
    public List<OrgTree> getByParentAndDem(@ApiParam(name="params", value="\u53c2\u6570\u503c") @RequestBody Map<String, String> params) throws Exception {
        OrgTree root;
        QueryFilter filter = QueryFilter.build();
        String demId = "";
        if (BeanUtils.isNotEmpty((Object)params.get("demId"))) {
            demId = params.get("demId").toString();
            filter.addParams("demId", (Object)demId);
        }
        String parentId = "0";
        if (BeanUtils.isNotEmpty((Object)params.get("parentId"))) {
            filter.addParams("parentId", (Object)(" ('" + params.get("parentId").toString() + "') "));
        } else {
            parentId = AuthFilterUtil.getOrgAuthParentId(demId);
            filter.addParams("parentId", (Object)parentId);
        }
        String authSql = AuthFilterUtil.getOrgAuthSql(demId);
        if (StringUtil.isNotEmpty((String)authSql)) {
            filter.addParams("authSql", (Object)authSql);
        }
        List<Org> list = null;
        if (BeanUtils.isNotEmpty((Object)params.get("deep"))) {
            parentId = BeanUtils.isNotEmpty((Object)params.get("parentId")) ? params.get("parentId") : "0";
            filter.getParams().remove("parentId");
            Org parent = (Org)((OrgManager)this.baseService).get((Serializable)((Object)parentId));
            filter.addParams("path", (Object)(parent.getPath() + "%"));
            list = this.orgService.getByParentAndDem(filter);
            list.removeIf(org -> org.getId().equals(parent.getId()));
        } else {
            list = this.orgService.getByParentAndDem(filter);
        }
        if (StringUtil.isNotEmpty((String)authSql)) {
            OrgUtil.dealRepeatAuthRoot(list);
        }
        ArrayList<OrgTree> groupTreeList = new ArrayList<OrgTree>();
        for (Org group : list) {
            List<OrgPost> postList;
            OrgTree groupTree = new OrgTree(group);
            if (BeanUtils.isNotEmpty((Object)params.get("isShowPost")) && StringUtil.isNotEmpty((String)params.get("isShowPost").toString()) && params.get("isShowPost").toString().equals("true") && !groupTree.isIsParent() && (postList = this.postService.getListByOrgId(groupTree.getId())).size() > 0) {
                groupTree.setIsParent(1);
            }
            groupTreeList.add(groupTree);
        }
        if (BeanUtils.isNotEmpty((Object)params.get("demId")) && StringUtil.isNotEmpty((String)params.get("demId").toString()) && BeanUtils.isEmpty((Object)params.get("parentId"))) {
            root = new OrgTree();
            Demension d = (Demension)this.demService.get((Serializable)((Object)params.get("demId").toString()));
            if (BeanUtils.isNotEmpty((Object)d)) {
                root.setId("0");
                if (BeanUtils.isNotEmpty(groupTreeList)) {
                    root.setIsParent(1);
                } else {
                    root.setIsParent(0);
                }
                root.setDemId(d.getId());
                root.setName(d.getDemName());
                root.setParentId("0");
            }
            groupTreeList.add(root);
        } else if (BeanUtils.isNotEmpty((Object)params.get("isOrgAuth")) && StringUtil.isNotEmpty((String)params.get("isOrgAuth").toString()) && params.get("isOrgAuth").toString().equals("true")) {
            root = new OrgTree();
            Org org2 = (Org)this.orgService.get((Serializable)((Object)params.get("parentId").toString()));
            if (BeanUtils.isNotEmpty((Object)org2)) {
                root = new OrgTree(org2);
                if (org2.isIsParent()) {
                    root.setAuthRoot(true);
                }
            }
            groupTreeList.add(root);
        }
        if (BeanUtils.isNotEmpty((Object)params.get("isShowPost")) && StringUtil.isNotEmpty((String)params.get("isShowPost").toString()) && params.get("isShowPost").toString().equals("true") && BeanUtils.isNotEmpty((Object)params.get("parentId"))) {
            List<OrgPost> postList = this.postService.getListByOrgId(params.get("parentId").toString());
            for (OrgPost orgPost : postList) {
                OrgTree postTree = new OrgTree(orgPost);
                postTree.setDemId(params.get("demId").toString());
                postTree.setPost(true);
                groupTreeList.add(postTree);
            }
        }
        return groupTreeList;
    }

    @GetMapping(value={"orgs/children/{orgId}"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6orgId\u7684\u4e0b\u7ea7\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6orgId\u7684\u4e0b\u7ea7\u7ec4\u7ec7")
    public List<Org> getByParentAndDem(@ApiParam(name="orgId", value="\u7ec4\u7ec7id") @PathVariable String orgId) throws Exception {
        QueryFilter filter = QueryFilter.build();
        filter.addParams("parentId", (Object)(" ('" + orgId + "') "));
        List<Org> list = this.orgService.getByParentAndDem(filter);
        return list;
    }

    @RequestMapping(value={"orgs/getByParentAndDemToTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6id  \u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u4e0b\u7684\u7ec4\u7ec7", httpMethod="POST", notes="\u6839\u636e\u7ef4\u5ea6id\u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u4e0b\u7684\u7ec4\u7ec7\uff0c\u53c2\u6570{\"demId\":\"1\",\"parentId\":\"1\"}")
    public List<OrgTree> getByParentAndDemToTree(@ApiParam(name="params", value="\u53c2\u6570\u503c") @RequestBody Map<String, String> params) throws Exception {
        OrgTree root;
        String authSql;
        QueryFilter filter = QueryFilter.build();
        String demId = "";
        if (BeanUtils.isNotEmpty((Object)params.get("demId"))) {
            demId = params.get("demId").toString();
            filter.addParams("demId", (Object)demId);
        }
        if (StringUtil.isNotEmpty((String)(authSql = AuthFilterUtil.getOrgAuthSql(demId)))) {
            filter.addParams("authSql", (Object)authSql);
        }
        List<Org> list = this.orgService.getByParentAndDem(filter);
        if (StringUtil.isNotEmpty((String)authSql)) {
            OrgUtil.dealRepeatAuthRoot(list);
        }
        ArrayList<OrgTree> groupTreeList = new ArrayList<OrgTree>();
        for (Org group : list) {
            List<OrgPost> postList;
            OrgTree groupTree = new OrgTree(group);
            if (BeanUtils.isNotEmpty((Object)params.get("isShowPost")) && StringUtil.isNotEmpty((String)params.get("isShowPost").toString()) && params.get("isShowPost").toString().equals("true") && !groupTree.isIsParent() && (postList = this.postService.getListByOrgId(groupTree.getId())).size() > 0) {
                groupTree.setIsParent(1);
            }
            groupTreeList.add(groupTree);
        }
        if (BeanUtils.isNotEmpty((Object)params.get("demId")) && StringUtil.isNotEmpty((String)params.get("demId").toString()) && BeanUtils.isEmpty((Object)params.get("parentId"))) {
            root = new OrgTree();
            Demension d = (Demension)this.demService.get((Serializable)((Object)params.get("demId").toString()));
            if (BeanUtils.isNotEmpty((Object)d)) {
                root.setId("0");
                if (BeanUtils.isNotEmpty(groupTreeList)) {
                    root.setIsParent(1);
                } else {
                    root.setIsParent(0);
                }
                root.setDemId(d.getId());
                root.setName(d.getDemName());
                root.setParentId("0");
            }
            groupTreeList.add(root);
        } else if (BeanUtils.isNotEmpty((Object)params.get("isOrgAuth")) && StringUtil.isNotEmpty((String)params.get("isOrgAuth").toString()) && params.get("isOrgAuth").toString().equals("true")) {
            root = new OrgTree();
            Org org = (Org)this.orgService.get((Serializable)((Object)params.get("parentId").toString()));
            if (BeanUtils.isNotEmpty((Object)org)) {
                root = new OrgTree(org);
                if (org.isIsParent()) {
                    root.setAuthRoot(true);
                }
            }
            groupTreeList.add(root);
        }
        if (BeanUtils.isNotEmpty((Object)params.get("isShowPost")) && StringUtil.isNotEmpty((String)params.get("isShowPost").toString()) && params.get("isShowPost").toString().equals("true") && BeanUtils.isNotEmpty((Object)params.get("parentId"))) {
            List<OrgPost> postList = this.postService.getListByOrgId(params.get("parentId").toString());
            for (OrgPost orgPost : postList) {
                OrgTree postTree = new OrgTree(orgPost);
                postTree.setDemId(params.get("demId").toString());
                postTree.setPost(true);
                groupTreeList.add(postTree);
            }
        }
        return groupTreeList;
    }

    @RequestMapping(value={"orgUsers/getOrgUserPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u4eba\u5458\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7ec4\u7ec7\u4eba\u5458\u5217\u8868")
    public PageList<HashMap<String, Object>> getOrgUserPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        QueryFilter groupFilter = QueryFilter.build();
        List userByGroupList = this.orgUserService.getUserByGroupList(groupFilter);
        Page p = (Page)this.orgUserService.getUserByGroup(queryFilter);
        if (p.getTotal() > 0L && userByGroupList.size() > 0) {
            for (Map user : p.getRecords()) {
                for (Map obj : userByGroupList) {
                    if (!user.get("userId").equals(obj.get("userId"))) continue;
                    String isMaster = obj.get("isMaster").toString();
                    String[] split = isMaster.split(",");
                    int count = 0;
                    Pattern pt = Pattern.compile("1");
                    Matcher m = pt.matcher(isMaster);
                    while (m.find()) {
                        ++count;
                    }
                    if (split.length > 1 && count > 1 || isMaster.indexOf("1") > -1 && !"1".equals(user.get("isMaster").toString())) {
                        user.put("otherPost", 3);
                        continue;
                    }
                    if (split.length == 1) {
                        user.put("otherPost", 1);
                        continue;
                    }
                    user.put("otherPost", 2);
                }
            }
        }
        return new PageList((IPage)p);
    }

    @RequestMapping(value={"orgPost/setMasterById"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4eba\u5458\uff08\u53d6\u6d88\uff09\u4e3b\u5c97\u4f4d", httpMethod="PUT", notes="\u901a\u8fc7id\uff0c\u8bbe\u7f6e\u4eba\u5458\uff08\u53d6\u6d88\uff09\u4e3b\u5c97\u4f4d")
    public CommonResult<String> setMasterById(String ... id) throws Exception {
        try {
            this.orgUserService.setMaster(id);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01", (Object)"");
        }
    }

    @RequestMapping(value={"orgPost/setMasterByIds"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4eba\u5458\u4e3b\u5c97\u4f4d", httpMethod="PUT", notes="\u901a\u8fc7id\uff0c\u8bbe\u7f6e\u4eba\u5458\u4e3b\u5c97\u4f4d")
    public CommonResult<String> setMasterByIds(String ... ids) throws Exception {
        try {
            this.orgUserService.setMasterByIds(ids);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01", (Object)"");
        }
    }

    @RequestMapping(value={"orgUsers/setUnderUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u6279\u91cf\u6dfb\u52a0\u4e0b\u5c5e", httpMethod="POST", notes="\u7528\u6237\u6279\u91cf\u6dfb\u52a0\u4e0b\u5c5e", hidden=true)
    public CommonResult<String> setUnderUsers(@ApiParam(name="orgId", value="\u7ec4\u7ec7id", required=true) @RequestParam String orgId, @ApiParam(name="account", value="\u4e0a\u7ea7\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="underAccounts", value="\u4e0b\u7ea7\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String underAccounts) throws Exception {
        return this.orgService.setUnderUsers(orgId, account, underAccounts);
    }

    @RequestMapping(value={"orgUsers/addUsersForOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ec4\u7ec7\u6279\u91cf\u52a0\u5165\u7528\u6237", httpMethod="POST", notes="\u7ec4\u7ec7\u6279\u91cf\u52a0\u5165\u7528\u6237", hidden=true)
    public CommonResult<String> addUsersForOrg(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u4ee3\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String accounts) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgService.addUsersForOrg(orgCode, accounts);
        }
        catch (Exception e) {
            rtn = new CommonResult(false, e.getMessage(), (Object)"\u4fdd\u5b58\u5931\u8d25");
        }
        return rtn;
    }

    @RequestMapping(value={"orgs/getOrgByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<Org> getOrgByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        return this.orgService.getOrgByTime(exportObject);
    }

    @RequestMapping(value={"orgParams/getOrgParamByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<OrgParams> getOrgParamByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        return this.orgService.getOrgParamByTime(exportObject);
    }

    @RequestMapping(value={"orgPosts/getOrgPostByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<OrgPost> getOrgPostByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        return this.orgService.getOrgPostByTime(exportObject);
    }

    @RequestMapping(value={"orgRoles/getOrgRoleByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<OrgRole> getOrgRoleByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        return this.orgService.getOrgRoleByTime(exportObject);
    }

    @RequestMapping(value={"orgUsers/getOrgUserByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<OrgUser> getOrgUserByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        return this.orgService.getOrgUserByTime(exportObject);
    }

    @RequestMapping(value={"userUnders/getUserUnderByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u4e2d\u4e0b\u5c5e\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u4e2d\u4e0b\u5c5e\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<UserUnder> getUserUnderByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        return this.orgService.getUserUnderByTime(exportObject);
    }

    @RequestMapping(value={"org/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u7ec4\u7ec7\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u7ec4\u7ec7\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.orgService.isCodeExist(code);
    }

    @RequestMapping(value={"orgPost/isPostCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u5c97\u4f4d\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u5c97\u4f4d\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isPostCodeExist(@ApiParam(name="code", value="\u5c97\u4f4d\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.orgService.isPostCodeExist(code);
    }

    @RequestMapping(value={"orgs/oaAsync"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u540c\u6b65OA\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e", httpMethod="POST", notes="\u540c\u6b65OA\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e")
    public CommonResult<String> oaAsync(@ApiParam(name="oaAsyncObject", value="\u540c\u6b65\u53c2\u6570", required=true) @RequestBody OaAsyncObject oaAsyncObject, HttpServletRequest request) throws Exception {
        String ip = OrgUtil.getIpAddress(request);
        return this.userImportService.syncSoap(oaAsyncObject, ip);
    }

    @RequestMapping(value={"orgRoles/getOrgRoleList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09")
    public PageList<OrgRole> getOrgRoleList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList list = this.orgRoleService.query(queryFilter);
        return list;
    }

    @RequestMapping(value={"orgRoles/saveOrgRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u89d2\u8272\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7ec4\u7ec7\u89d2\u8272\u4fe1\u606f")
    public CommonResult<String> saveOrgRole(@ApiParam(name="vo", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody OrgRoleVo vo) throws Exception {
        return this.orgService.addOrgRole(vo);
    }

    @RequestMapping(value={"orgRoles/removeOrgRole"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u89d2\u8272\u4fe1\u606f", httpMethod="GET", notes="\u4fdd\u5b58\u7ec4\u7ec7\u89d2\u8272\u4fe1\u606f")
    public CommonResult<String> removeOrgRole(@ApiParam(name="code", value="\u5c97\u4f4d\u7f16\u7801") @RequestParam(required=true) String id) throws Exception {
        return this.orgService.delOrgRoleById(id);
    }

    @RequestMapping(value={"orgs/updateOrgPos"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u7ec4\u7ec7\u6240\u5728\u6811\u7684\u4f4d\u7f6e", httpMethod="POST", notes="\u66f4\u65b0\u7ec4\u7ec7\u6240\u5728\u6811\u7684\u4f4d\u7f6e\uff08\u6811\u7ed3\u6784\u62d6\u52a8\u4fdd\u5b58\uff09")
    public CommonResult<String> updateOrgPos(@ApiParam(name="orgId", value="\u79fb\u52a8\u8282\u70b9id", required=true) @RequestParam String orgId, @ApiParam(name="parentId", value="\u79fb\u81f3\uff08\u76ee\u6807\uff09\u8282\u70b9id", required=true) @RequestParam String parentId) throws Exception {
        return this.orgService.updateOrgPos(orgId, parentId);
    }

    @RequestMapping(value={"orgs/exportUsers"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237\u7ec4\u7ec7\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u7528\u6237\u7ec4\u7ec7\u6570\u636e")
    public void exportUsers(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="isChildre", value="\u662f\u5426\u5305\u542b\u5b50\u7ec4\u7ec7\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam Boolean isChildre) throws Exception {
        File file;
        String excelPath;
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        String path = this.orgService.exportData(orgCode, isChildre = Boolean.valueOf(BeanUtils.isEmpty((Object)isChildre) ? true : isChildre));
        if (StringUtil.isNotEmpty((String)path)) {
            excelPath = path + ".xls";
            file = new File(excelPath);
            if (!file.exists()) {
                throw new RuntimeException("\u751f\u6210Excel\u6587\u4ef6\u5931\u8d25\uff01");
            }
        } else {
            throw new RuntimeException("\u5bfc\u51fa\u7ec4\u7ec7\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String excelName = file.getName();
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)excelPath, (String)excelName);
        FileUtil.deleteFile((String)file.getParentFile().getPath());
    }

    @RequestMapping(value={"org/getMainGroup"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7")
    public Org getMainGroup(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="demId", value="\u7ef4\u5ea6id", required=true) @RequestParam Optional<String> demId) throws Exception {
        return this.orgService.getMainGroup(userId, demId.orElse(""));
    }

    @RequestMapping(value={"org/getParentMainOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7\uff08\u5305\u542b\u7236\u7ea7\u7ec4\u7ec7\uff09", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7\uff08\u5305\u542b\u7236\u7ea7\u7ec4\u7ec7\uff09")
    public Map<String, Org> getParentMainOrg(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        return this.orgService.getParentMainOrg(userId);
    }

    @RequestMapping(value={"orgJobs/getJobsByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u6709\u804c\u52a1", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u804c\u52a1")
    public List<OrgJob> getJobsByUserId(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        return this.orgJobManager.getListByUserId(userId);
    }

    @RequestMapping(value={"org/isSupOrgByCurrMain"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u7528\u6237\u4e3b\u90e8\u95e8\u662f\u5426\u6709\u4e0a\u7ea7 ", httpMethod="GET", notes="\u5224\u65ad\u5f53\u524d\u7528\u6237\u4e3b\u90e8\u95e8\u662f\u5426\u6709\u4e0a\u7ea7 ")
    public Boolean isSupOrgByCurrMain(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="demId", value="\u7ef4\u5ea6id", required=true) @RequestParam String demId, @ApiParam(name="level", value="\u7ea7\u522b", required=true) @RequestParam Integer level) throws Exception {
        List<OrgUser> orgUsers = this.orgUserService.getOrgUserMaster(userId, demId);
        if (BeanUtils.isNotEmpty(orgUsers)) {
            OrgUser orgUser = orgUsers.get(0);
            String levelGroupId = orgUser.getOrgId();
            Org org = (Org)this.orgService.get((Serializable)((Object)levelGroupId));
            while (level > 0) {
                if (BeanUtils.isNotEmpty((Object)(org = (Org)this.orgService.get((Serializable)((Object)org.getParentId()))))) {
                    levelGroupId = org.getId();
                    level = level - 1;
                    continue;
                }
                return false;
            }
            Org currentOrg = this.orgService.getMainGroup(userId, demId);
            if (BeanUtils.isNotEmpty((Object)currentOrg)) {
                String groupId = currentOrg.getId();
                if (levelGroupId.equals(groupId)) {
                    return false;
                }
                if (StringUtil.isNotZeroEmpty((String)currentOrg.getParentId())) {
                    return true;
                }
            }
        }
        return false;
    }

    @RequestMapping(value={"org/getSupOrgByCurrMain"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u7ec4\u7ec7\u5173\u7cfb", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u7ec4\u7ec7\u5173\u7cfb")
    public OrgUser getSupOrgByCurrMain(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="demId", value="\u7ef4\u5ea6id", required=true) @RequestParam String demId) throws Exception {
        List<OrgUser> orgUsers = this.orgUserService.getOrgUserMaster(userId, demId);
        if (BeanUtils.isNotEmpty(orgUsers)) {
            return orgUsers.get(0);
        }
        return null;
    }

    @RequestMapping(value={"org/getMainPostOrOrgByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u3001\u4e3b\u7ec4\u7ec7(\u4f18\u5148\u83b7\u53d6\u9ed8\u8ba4\u7ef4\u5ea6\u7684\uff0c\u6ca1\u6709\u65f6\u83b7\u53d6\u5176\u4ed6\u7ef4\u5ea6\u7684)", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u3001\u4e3b\u7ec4\u7ec7(\u4f18\u5148\u83b7\u53d6\u9ed8\u8ba4\u7ef4\u5ea6\u7684\uff0c\u6ca1\u6709\u65f6\u83b7\u53d6\u5176\u4ed6\u7ef4\u5ea6\u7684)")
    public OrgUser getMainPostOrOrgByUserId(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        return this.orgUserService.getMainPostOrOrgByUserId(userId);
    }

    @RequestMapping(value={"/orgusers/getCustomLevelCharge"}, method={RequestMethod.GET})
    public List<User> getCustomLevelCharge(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="level", required=true) String level, @RequestParam(value="isMainCharge", required=true) boolean isMainCharge) throws Exception {
        List<Org> userOrg = this.orgService.getUserOrg(userId, "", true);
        List<User> chargesByOrg = new ArrayList<User>();
        if (BeanUtils.isEmpty(userOrg)) {
            return chargesByOrg;
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = (Org)this.orgService.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getChargesByOrg(org.getCode(), isMainCharge);
            break;
        }
        return chargesByOrg;
    }

    @RequestMapping(value={"/orgusers/getCustomLevelPost"}, method={RequestMethod.GET})
    public Set<GroupIdentity> getCustomLevelPost(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="level", required=true) String level, @RequestParam(value="postCode", required=true) String postCode) throws Exception {
        List<Org> userOrg = this.orgService.getUserOrg(userId, "", true);
        Set<GroupIdentity> chargesByOrg = new HashSet<GroupIdentity>();
        if (BeanUtils.isEmpty(userOrg)) {
            return chargesByOrg;
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = (Org)this.orgService.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getByPostCodeAndOrgCode(postCode, org.getCode());
            break;
        }
        return chargesByOrg;
    }

    @RequestMapping(value={"/orgusers/getCustomLevelJob"}, method={RequestMethod.GET})
    public Set<GroupIdentity> getCustomLevelJob(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="level", required=true) String level, @RequestParam(value="jobCode", required=true) String jobCode) throws Exception {
        List<Org> userOrg = this.orgService.getUserOrg(userId, "", true);
        Set<GroupIdentity> chargesByOrg = new HashSet<GroupIdentity>();
        if (BeanUtils.isEmpty(userOrg)) {
            return chargesByOrg;
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = (Org)this.orgService.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getByJobCodeAndOrgCode(jobCode, org.getCode());
            break;
        }
        return chargesByOrg;
    }

    @RequestMapping(value={"/orgusers/getStartOrgParam"}, method={RequestMethod.GET})
    public String getStartOrgParam(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="param", required=true) String param) {
        List<Org> userOrg = this.orgService.getUserOrg(userId, "", true);
        String paramValue = "";
        if (BeanUtils.isEmpty(userOrg)) {
            return paramValue;
        }
        Org org = userOrg.get(0);
        OrgParams byOrgIdAndAlias = this.orgParamsService.getByOrgIdAndAlias(org.getId(), param);
        return byOrgIdAndAlias.getValue();
    }

    @RequestMapping(value={"orgpost/getFullname"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5c97\u4f4did\u67e5\u8be2\u5c97\u4f4d\u6240\u5728\u7684\u4eba\u5458\uff0c\u4e00\u822c\u53ea\u6709\u4e00\u4f4d", httpMethod="GET", notes="\u6839\u636e\u5c97\u4f4did\u67e5\u8be2\u5c97\u4f4d\u6240\u5728\u7684\u4eba\u5458\uff0c\u4e00\u822c\u53ea\u6709\u4e00\u4f4d")
    public List<Map<String, Object>> getFullname(@ApiParam(name="postId", value="\u5c97\u4f4did", required=true) @RequestParam String postId) throws Exception {
        return this.postService.getFullname(postId);
    }

    @RequestMapping(value={"orgpost/getPostByJobId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1id\u67e5\u8be2\u5c97\u4f4d\u4ee5\u53ca\u8fd9\u4e9b\u5c97\u4f4d\u6240\u5c5e\u7684\u7ec4\u7ec7\u5168\u8def\u5f84", httpMethod="GET", notes="\u6839\u636e\u804c\u4f4did\u67e5\u8be2\u5c97\u4f4d\u4ee5\u53ca\u8fd9\u4e9b\u5c97\u4f4d\u6240\u5c5e\u7684\u7ec4\u7ec7\u5168\u8def\u5f84")
    public List<Map<String, Object>> getPostByJobId(@ApiParam(name="jobId", value="\u804c\u52a1id", required=true) @RequestParam String jobId) throws Exception {
        return this.postService.getPostByJobId(jobId);
    }

    @RequestMapping(value={"orgpost/getUserByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u5c97\u4f4d\u89d2\u8272\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u5c97\u4f4d\u89d2\u8272\u4fe1\u606f")
    public List<Map<String, Object>> getUserByUserId(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        return this.postService.getUserByUserId(userId);
    }

    @RequestMapping(value={"org/getPathNames"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u7ec4\u83b7\u53d6\u7ec4\u7ec7\u5168\u8def\u5f84", httpMethod="POST", notes="\u6839\u636e\u7528\u6237id\u83b7\u5f97\u4e3b\u5c97\u4f4d\u7684\u5c97\u4f4d\u7ec4")
    public List<Map<String, String>> getPathNames(@ApiParam(name="userIds", value="\u7528\u6237id\u7ec4", required=false) @RequestParam List<String> userIds) throws Exception {
        return this.orgService.getPathNames(userIds);
    }

    @RequestMapping(value={"org/getChildrenIds"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b50\u7ec4\u7ec7ID\uff08\u5305\u542b\u81ea\u5df1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5b50\u7ec4\u7ec7ID\uff08\u5305\u542b\u81ea\u5df1\uff09")
    public Map<String, Set<String>> getChildrenIds(@ApiParam(name="ids", value="\u7ec4\u7ec7id", required=true) @RequestParam Map<String, String> ids) throws Exception {
        return this.orgService.getChildrenIds(ids);
    }

    @RequestMapping(value={"org/getOrgListByDemId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    public List<Org> getOrgListByDemId(@ApiParam(name="demId", value="\u7ef4\u5ea6id", required=true) @RequestParam String demId) throws Exception {
        return this.orgService.getOrgListByDemId(demId);
    }

    @RequestMapping(value={"orgusers/getUserOrgNowNumByOrgId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u9762\u7684\u4eba\u5458\u6570\u91cf", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u9762\u7684\u4eba\u5458\u6570\u91cf")
    public Integer getUserOrgNowNumByOrgId(@ApiParam(name="orgId", value="\u7ec4\u7ec7id", required=true) @RequestParam String orgId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        map.put("group", "true");
        List list = this.orgUserDao.getUserNumByOrgId(map);
        return list.size();
    }

    @RequestMapping(value={"orgusers/getUserOrgNowNumByOrgIds"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u9762\u7684\u4eba\u5458\u6570\u91cf", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u9762\u7684\u4eba\u5458\u6570\u91cf")
    public List<Map<String, Object>> getUserOrgNowNumByOrgIds(@ApiParam(name="orgIds", value="\u7ec4\u7ec7id\u96c6\u5408", required=true) @RequestParam String orgIds) throws Exception {
        String[] value;
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (String orgId : value = orgIds.split(",")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, Object> numMap = new HashMap<String, Object>();
            map.put("orgId", orgId);
            map.put("group", "true");
            List list = this.orgUserDao.getUserNumByOrgId(map);
            numMap.put("orgId", orgId);
            numMap.put("num", list.size());
            mapList.add(numMap);
        }
        return mapList;
    }

    @RequestMapping(value={"org/addOrgFromExterUni"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u6dfb\u52a0\u5230\u672c\u7cfb\u7edf", httpMethod="POST", notes="\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u6dfb\u52a0\u5230\u672c\u7cfb\u7edf")
    public CommonResult<String> addOrgFromExterUni(@ApiParam(name="org", value="\u7ec4\u7ec7", required=true) @RequestBody Org orgVo) throws Exception {
        CommonResult<String> rtn = null;
        rtn = this.orgService.addOrgFromExterUni(orgVo);
        return rtn;
    }

    @Deprecated
    @RequestMapping(value={"org/getSuperiorPost"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    public Map<String, Object> getSuperiorPost(@RequestParam(value="userId", required=true) String userId) {
        return this.postService.getSuperiorPost(userId);
    }

    @RequestMapping(value={"org/getFillOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u586b\u5236\u5355\u4f4d", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u586b\u5236\u5355\u4f4d")
    public CommonResult<Org> getFillOrg(@ApiParam(name="demId", value="\u7ef4\u5ea6Id", required=true) @RequestParam Optional<String> demId, @ApiParam(name="grade", value="\u7ec4\u7ec7\u7ea7\u522b", required=true) @RequestParam Optional<String> grade) throws Exception {
        return this.orgService.getFillOrg(demId.orElse(""), grade.orElse("2"));
    }

    @RequestMapping(value={"orgParam/getParamById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u53c2\u6570", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7Id\u548c\u53c2\u6570\u522b\u540d\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570")
    public String getParamById(@ApiParam(name="orgId", value="\u7ec4\u7ec7\u4ee3\u7801", required=true) @RequestParam String orgId, @ApiParam(name="alias", value="\u53c2\u6570\u4ee3\u7801", required=true) @RequestParam String alias) throws Exception {
        OrgParams params = this.orgService.getParamById(orgId, alias);
        if (BeanUtils.isNotEmpty((Object)params)) {
            return params.getValue();
        }
        return "";
    }

    @RequestMapping(value={"orgParam/isOrgHasParamKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u5224\u65ad\u662f\u5426\u6709\u8be5\u53c2\u6570", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u662f\u5426\u6709\u8be5\u53c2\u6570")
    public boolean isOrgHasParamKey(@ApiParam(name="orgId", value="\u7ec4\u7ec7Id", required=true) @RequestParam String orgId, @ApiParam(name="alias", value="\u53c2\u6570\u4ee3\u7801", required=true) @RequestParam String alias) throws Exception {
        return this.orgService.isOrgHasParamKey(orgId, alias);
    }

    @RequestMapping(value={"orgParam/hasOrgParamKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u662f\u5426\u6709\u8be5\u53c2\u6570", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u662f\u5426\u6709\u8be5\u53c2\u6570")
    public boolean hasOrgParamKey(@ApiParam(name="grade", value="\u7ec4\u7ec7\u7ea7\u522b", required=true) @RequestParam String grade, @ApiParam(name="userId", value="\u7528\u6237Id", required=true) @RequestParam String userId, @ApiParam(name="alias", value="\u53c2\u6570\u4ee3\u7801", required=true) @RequestParam String alias) throws Exception {
        return this.orgService.hasOrgParamKey(grade, userId, alias);
    }

    @RequestMapping(value={"org/getOrgsByIds"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7id\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7id\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)")
    public List<Org> getOrgsByIds(@ApiParam(name="ids", value="\u7ec4\u7ec7ids") @RequestParam(required=true) String ids) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ID_", (Object)ids, QueryOP.IN);
        List orgs = this.orgService.queryNoPage(queryFilter);
        return orgs;
    }

    @RequestMapping(value={"org/getOrgsByCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7code\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7code\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)")
    public List<Org> getOrgsByCodes(@ApiParam(name="codes", value="\u7ec4\u7ec7codes") @RequestParam(required=true) String codes) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("CODE_", (Object)codes, QueryOP.IN);
        List orgs = this.orgService.queryNoPage(queryFilter);
        return orgs;
    }
}

