/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.portal.model.PortalNewsNotice;
import com.artfess.portal.model.PortalNewsTree;
import com.artfess.portal.model.SysIndexColumn;
import com.artfess.portal.model.SysIndexNewsColumn;
import com.artfess.portal.persistence.dao.PortalNewsTreeDao;
import com.artfess.portal.persistence.manager.PortalNewsNoticeManager;
import com.artfess.portal.persistence.manager.PortalNewsTreeManager;
import com.artfess.portal.persistence.manager.SysIndexColumnManager;
import com.artfess.portal.persistence.manager.SysIndexNewsColumnManager;
import com.artfess.sysConfig.persistence.manager.SysAuthUserManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalNewsTreeManagerImpl
extends BaseManagerImpl<PortalNewsTreeDao, PortalNewsTree>
implements PortalNewsTreeManager {
    @Autowired
    SysIndexColumnManager sysIndexColumnManager;
    @Resource
    SysIndexNewsColumnManager sysIndexNewsColumnManager;
    @Resource
    PortalNewsNoticeManager portalNewsNoticeManager;
    @Resource
    PortalNewsTreeDao portalNewsTreeDao;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    SaaSConfig saaSConfig;

    @Override
    public CommonResult<String> issue(String id) throws Exception {
        String templateHtml;
        SysIndexColumn sysIndexColumn2;
        SysIndexColumn sysIndexColumn = new SysIndexColumn();
        PortalNewsTree portalNewsTree = (PortalNewsTree)this.get((Serializable)((Object)id));
        String columnId = portalNewsTree.getColumnId();
        if (StringUtil.isNotEmpty((String)columnId) && BeanUtils.isNotEmpty((Object)((Object)(sysIndexColumn2 = (SysIndexColumn)this.sysIndexColumnManager.get((Serializable)((Object)columnId)))))) {
            return new CommonResult(false, "\u6b64\u5206\u7c7b\u5df2\u7ecf\u88ab\u53d1\u5e03\u6210\u9996\u9875\u680f\u76ee,\u65e0\u6cd5\u518d\u6b21\u53d1\u5e03!");
        }
        String path = portalNewsTree.getPath();
        sysIndexColumn.setAlias(id);
        sysIndexColumn.setCatalog("31081");
        sysIndexColumn.setColHeight(327L);
        sysIndexColumn.setColType((short)0);
        sysIndexColumn.setIsPublic((short)2);
        sysIndexColumn.setNeedPage((short)0);
        sysIndexColumn.setCatalogName("\u9ed8\u8ba4\u5206\u7c7b");
        sysIndexColumn.setColHeight(portalNewsTree.getColHeight().longValue());
        String suid = UniqueIdUtil.getSuid();
        sysIndexColumn.setId(suid);
        sysIndexColumn.setName(portalNewsTree.getName());
        if (path.startsWith("100.")) {
            String template = "<home-news-list classifyId='" + id + "'/>";
            templateHtml = Base64.getBase64((String)template);
            sysIndexColumn.setTemplateHtml(templateHtml);
            sysIndexColumn.setColUrl("/newsList/" + id);
        } else {
            String template = "<homeCarousel height='" + portalNewsTree.getColHeight() + "' classifyId='" + id + "' :interval='" + portalNewsTree.getIntervalTime() + "'/>";
            templateHtml = Base64.getBase64((String)template);
            sysIndexColumn.setTemplateHtml(templateHtml);
        }
        this.sysIndexColumnManager.create((Model)sysIndexColumn);
        portalNewsTree.setColumnId(suid);
        this.update((Model)portalNewsTree);
        String indexColumnId = sysIndexColumn.getId();
        String objType = "indexColumn";
        String ownerNameJson = "[{\"type\":\"everyone\",\"title\":\"\u6240\u6709\u4eba\",\"checked\":true}]";
        this.sysAuthUserManager.saveRights(indexColumnId, objType, ownerNameJson);
        IUser currentUser = ContextUtil.getCurrentUser();
        this.sysAuthUserManager.delUserMenuCache(currentUser.getUserId());
        return new CommonResult();
    }

    @Override
    public void updateEntity(PortalNewsTree t) throws Exception {
        SysIndexColumn sysIndexColumn;
        if (StringUtil.isNotEmpty((String)t.getColumnId()) && BeanUtils.isNotEmpty((Object)((Object)(sysIndexColumn = (SysIndexColumn)this.sysIndexColumnManager.get((Serializable)((Object)t.getColumnId())))))) {
            String path = t.getPath();
            String id = t.getId();
            sysIndexColumn.setColHeight(t.getColHeight().longValue());
            sysIndexColumn.setName(t.getName());
            if (path.startsWith("100.")) {
                String template = "<home-news-list classifyId='" + id + "'/>";
                String templateHtml = Base64.getBase64((String)template);
                sysIndexColumn.setTemplateHtml(templateHtml);
            } else {
                String template = "<homeCarousel height='" + t.getColHeight() + "' classifyId='" + id + "' :interval='" + t.getIntervalTime() + "'/>";
                String templateHtml = Base64.getBase64((String)template);
                sysIndexColumn.setTemplateHtml(templateHtml);
            }
            this.sysIndexColumnManager.update((Model)sysIndexColumn);
        }
        super.update((Model)t);
    }

    @Override
    public CommonResult<String> mobileIssue(String id) {
        SysIndexNewsColumn sysIndexColumn2;
        PortalNewsTree portalNewsTree = (PortalNewsTree)this.get((Serializable)((Object)id));
        portalNewsTree.setMobileIssue(new BigDecimal(1));
        this.update((Model)portalNewsTree);
        String columnId = portalNewsTree.getColumnId();
        if (StringUtil.isNotEmpty((String)columnId) && BeanUtils.isNotEmpty((Object)((Object)(sysIndexColumn2 = (SysIndexNewsColumn)((Object)this.sysIndexNewsColumnManager.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysIndexNewsColumn::getPortalNewsId, (Object)id))))))) {
            return new CommonResult(false, "\u6b64\u5206\u7c7b\u5df2\u7ecf\u88ab\u53d1\u5e03\u6210\u9996\u9875\u680f\u76ee,\u65e0\u6cd5\u518d\u6b21\u53d1\u5e03!");
        }
        SysIndexNewsColumn sysIndexColumn = new SysIndexNewsColumn();
        sysIndexColumn.setName(portalNewsTree.getName());
        String path = portalNewsTree.getPath();
        if (path.startsWith("100.")) {
            sysIndexColumn.setType("0");
        } else {
            sysIndexColumn.setType("1");
        }
        sysIndexColumn.setPortalNewsId(id);
        this.sysIndexNewsColumnManager.create((Model)sysIndexColumn);
        return new CommonResult("\u53d1\u5e03\u6210\u529f");
    }

    @Override
    public CommonResult<String> mobileRemove(String id) {
        PortalNewsTree portalNewsTree = (PortalNewsTree)this.get((Serializable)((Object)id));
        portalNewsTree.setMobileIssue(new BigDecimal(0));
        this.update((Model)portalNewsTree);
        this.sysIndexNewsColumnManager.remove((Wrapper)Wrappers.lambdaQuery().eq(SysIndexNewsColumn::getPortalNewsId, (Object)id));
        return new CommonResult("\u53d6\u6d88\u516c\u544a\u53d1\u5e03\u6210\u529f");
    }

    @Transactional
    public boolean removeById(Serializable id) {
        PortalNewsTree tree = (PortalNewsTree)((Object)this.getById(id));
        if (tree.getParentId().equals("0")) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u5220\u9664\u6b64\u5206\u7c7b");
        }
        if ("2".equals(tree.getRank().toString())) {
            this.portalNewsNoticeManager.deleteNewsByParentId((String)((Object)id));
            this.sysIndexColumnManager.deleteByNewsParentId((String)((Object)id));
            this.portalNewsTreeDao.deleteByParentId((String)((Object)id));
        } else if ("3".equals(tree.getRank().toString())) {
            if (StringUtil.isNotEmpty((String)tree.getColumnId())) {
                this.sysIndexColumnManager.remove((Serializable)((Object)tree.getColumnId()));
            }
            this.portalNewsNoticeManager.deleteByClassifyId((String)((Object)id));
        }
        return super.removeById(id);
    }

    @Override
    @Transactional
    public void importFile(String uzPath, String classifyId) throws Exception {
        try {
            String fileStr = FileUtil.readFile((String)(uzPath + File.separator + "portalTree.json"));
            Map map = (Map)JsonUtil.toBean((String)fileStr, HashMap.class);
            PortalNewsTree targetTree = (PortalNewsTree)((Object)this.getById((Serializable)((Object)classifyId)));
            ArrayList treesObj = (ArrayList)map.get("trees");
            ArrayList noticeObj = (ArrayList)map.get("notices");
            ArrayList<PortalNewsTree> treesRank2 = new ArrayList<PortalNewsTree>();
            ArrayList<PortalNewsTree> treesRank3 = new ArrayList<PortalNewsTree>();
            ArrayList<PortalNewsNotice> notices = new ArrayList<PortalNewsNotice>();
            for (Object o : treesObj) {
                PortalNewsTree portalNewsTree = (PortalNewsTree)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), PortalNewsTree.class));
                if (2 == portalNewsTree.getRank().intValue()) {
                    treesRank2.add(portalNewsTree);
                    continue;
                }
                if (3 != portalNewsTree.getRank().intValue()) continue;
                treesRank3.add(portalNewsTree);
            }
            if (1 == targetTree.getRank().intValue() && treesRank2.isEmpty()) {
                throw new BaseException("\u4e0d\u5141\u8bb8\u5728\u9876\u7ea7\u5206\u7c7b\u4e2d\u76f4\u63a5\u5bfc\u5165\u4e09\u7ea7\u5206\u7c7b,\u8bf7\u5148\u6dfb\u52a0\u4e8c\u7ea7\u5206\u7c7b");
            }
            if (2 == targetTree.getRank().intValue() && !treesRank2.isEmpty()) {
                throw new BaseException("\u4e0d\u5141\u8bb8\u5bfc\u5165\u540c\u7ea7\u5206\u7c7b\uff0c\u8bf7\u9009\u62e9\u9876\u7ea7\u5206\u7c7b\u5bfc\u5165");
            }
            if (BeanUtils.isNotEmpty((Object)noticeObj)) {
                for (Object o : noticeObj) {
                    notices.add((PortalNewsNotice)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), PortalNewsNotice.class)));
                }
            }
            if (1 == targetTree.getRank().intValue()) {
                Map<String, String> changeMap2 = this.handleTreeRank2(treesRank2, targetTree.getId());
                Map<String, String> changeMap3 = this.handleTreeRank3(treesRank3, targetTree.getId(), changeMap2);
                this.handleNotice(notices, changeMap3);
            } else if (2 == targetTree.getRank().intValue()) {
                Map<String, String> changeMap3 = this.handleTreeRank3(treesRank3, targetTree.getId(), new HashMap<String, String>());
                this.handleNotice(notices, changeMap3);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    private Map<String, String> handleTreeRank2(List<PortalNewsTree> trees2, String targetId) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        for (PortalNewsTree tree : trees2) {
            tree.setParentId(targetId);
            tree.setPath(targetId + "." + tree.getId() + ".");
            PortalNewsTree oldVal = (PortalNewsTree)((Object)((PortalNewsTreeDao)this.baseMapper).selectById((Serializable)((Object)tree.getId())));
            if (BeanUtils.isNotEmpty((Object)((Object)oldVal))) {
                if (StringUtil.equals((String)oldVal.getPath(), (String)tree.getPath())) {
                    ((PortalNewsTreeDao)this.baseMapper).updateById((Object)tree);
                    continue;
                }
                String oldId = tree.getId();
                String newId = UniqueIdUtil.getSuid();
                tree.setId(newId);
                tree.setPath(tree.getPath().replace(oldId, newId));
                rtnMap.put(oldId, newId);
                if (this.saaSConfig.isEnable()) {
                    tree.setTenantId(null);
                }
                ((PortalNewsTreeDao)this.baseMapper).insert((Object)tree);
                continue;
            }
            if (this.saaSConfig.isEnable()) {
                tree.setTenantId(null);
            }
            ((PortalNewsTreeDao)this.baseMapper).insert((Object)tree);
        }
        return rtnMap;
    }

    private Map<String, String> handleTreeRank3(List<PortalNewsTree> tree3, String targetId, Map<String, String> changeMap) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        PortalNewsTree parent = (PortalNewsTree)((Object)this.getById((Serializable)((Object)targetId)));
        if (BeanUtils.isEmpty((Object)((Object)parent))) {
            throw new BaseException("\u7236\u8282\u70b9\u4e3a\u7a7a");
        }
        for (PortalNewsTree tree : tree3) {
            if (changeMap.containsKey(tree.getParentId())) {
                String newPar = changeMap.get(tree.getParentId());
                tree.setParentId(newPar);
                tree.setPath(targetId + "." + newPar + "." + tree.getId() + ".");
            } else if (2 == parent.getRank().intValue()) {
                tree.setParentId(targetId);
                tree.setPath(tree.getPath().split("\\.")[0] + "." + targetId + "." + tree.getId() + ".");
            }
            PortalNewsTree oldVal = (PortalNewsTree)((Object)this.getById((Serializable)((Object)tree.getId())));
            if (BeanUtils.isNotEmpty((Object)((Object)oldVal))) {
                if (StringUtil.equals((String)oldVal.getParentId(), (String)tree.getParentId())) {
                    ((PortalNewsTreeDao)this.baseMapper).updateById((Object)tree);
                    continue;
                }
                String oldId = tree.getId();
                String newId = UniqueIdUtil.getSuid();
                tree.setId(newId);
                tree.setPath(tree.getPath().replace(oldId, newId));
                rtnMap.put(oldId, newId);
                if (this.saaSConfig.isEnable()) {
                    tree.setTenantId(null);
                }
                ((PortalNewsTreeDao)this.baseMapper).insert((Object)tree);
                continue;
            }
            if (this.saaSConfig.isEnable()) {
                tree.setTenantId(null);
            }
            ((PortalNewsTreeDao)this.baseMapper).insert((Object)tree);
        }
        return rtnMap;
    }

    private void handleNotice(List<PortalNewsNotice> notices, Map<String, String> changeMap) {
        if (BeanUtils.isEmpty(notices)) {
            return;
        }
        for (PortalNewsNotice notice : notices) {
            PortalNewsTree classify;
            String classifyId = notice.getClassifyId();
            if (changeMap.containsKey(classifyId)) {
                classifyId = changeMap.get(classifyId);
            }
            if (BeanUtils.isEmpty((Object)((Object)(classify = (PortalNewsTree)((Object)((PortalNewsTreeDao)this.baseMapper).selectById((Serializable)((Object)classifyId))))))) {
                throw new BaseException("\u5728\u5bfc\u5165\u516c\u544a\u3010" + notice.getTitle() + "\u3011\u65f6\u6240\u5728\u5206\u7c7b\u672a\u83b7\u53d6\uff0c\u5bfc\u5165\u5931\u8d25");
            }
            notice.setClassifyId(classifyId);
            notice.setClassifyPath(classify.getPath());
            PortalNewsNotice oldVal = (PortalNewsNotice)((Object)this.portalNewsNoticeManager.getById((Serializable)((Object)notice.getId())));
            if (BeanUtils.isNotEmpty((Object)((Object)oldVal))) {
                if (StringUtil.equals((String)oldVal.getClassifyPath(), (String)notice.getClassifyPath())) {
                    this.portalNewsNoticeManager.updateById((Object)notice);
                    continue;
                }
                notice.setId(UniqueIdUtil.getSuid());
                if (this.saaSConfig.isEnable()) {
                    notice.setTenantId(null);
                }
                this.portalNewsNoticeManager.create((Model)notice);
                continue;
            }
            if (this.saaSConfig.isEnable()) {
                notice.setTenantId(null);
            }
            this.portalNewsNoticeManager.create((Model)notice);
        }
    }
}

