/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.duty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.duty.dao.CmgtDutyOrgWorkarrangeDao;
import com.artfess.manage.duty.manager.CmgtDutyOrgWorkarrangeManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyOrgWorkarrangeDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyOrgWorkarrangeDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyOrgWorkarrange;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CmgtDutyOrgWorkarrangeManagerImpl
extends BaseManagerImpl<CmgtDutyOrgWorkarrangeDao, CmgtDutyOrgWorkarrange>
implements CmgtDutyOrgWorkarrangeManager {
    @Resource
    private CmgtDutyOrgWorkarrangeDao cmgtDutyOrgWorkarrangeDao;
    @Resource
    private CmgtDutyOrgWorkarrangeDtoMapper cmgtDutyOrgWorkarrangeDtoMapper;
    @Resource
    private ManageCommonService manageCommonService;
    @Resource
    DemensionManager demensionService;
    @Autowired
    OrgManager orgService;

    @Override
    public PageList<CmgtDutyOrgWorkarrangeDto> pageQuery(QueryFilter<CmgtDutyOrgWorkarrange> queryFilter) {
        PageList result = this.query(queryFilter);
        PageList r = new PageList(result.getRows().stream().map(e -> {
            CmgtDutyOrgWorkarrangeDto t = (CmgtDutyOrgWorkarrangeDto)((Object)((Object)this.cmgtDutyOrgWorkarrangeDtoMapper.toDto(e)));
            t.setOrgName(((Org)this.orgService.getById((Serializable)((Object)t.getOrgId()))).getName());
            return t;
        }).collect(Collectors.toList()));
        r.setPageSize(result.getPageSize());
        r.setPageSize(result.getPage());
        return r;
    }

    @Override
    public String createInfo(CmgtDutyOrgWorkarrange t) {
        int i = ((CmgtDutyOrgWorkarrangeDao)this.baseMapper).insert((Object)t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtDutyOrgWorkarrange t) {
        ((CmgtDutyOrgWorkarrangeDao)this.baseMapper).updateById((Object)t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtDutyOrgWorkarrange t) {
        ((CmgtDutyOrgWorkarrangeDao)this.baseMapper).deleteById((Serializable)((Object)t.getId()));
    }

    @Override
    public String create(CmgtDutyOrgWorkarrangeDto dto) {
        CmgtDutyOrgWorkarrange t = (CmgtDutyOrgWorkarrange)((Object)this.cmgtDutyOrgWorkarrangeDtoMapper.toEntity(dto));
        int i = ((CmgtDutyOrgWorkarrangeDao)this.baseMapper).insert((Object)t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String update(CmgtDutyOrgWorkarrangeDto dto) {
        CmgtDutyOrgWorkarrange t = (CmgtDutyOrgWorkarrange)((Object)this.cmgtDutyOrgWorkarrangeDtoMapper.toEntity(dto));
        ((CmgtDutyOrgWorkarrangeDao)this.baseMapper).updateById((Object)t);
        return t.getId();
    }

    @Override
    public boolean delete(List<String> ids) {
        for (String id : ids) {
            int count = ((CmgtDutyOrgWorkarrangeDao)this.baseMapper).deleteById((Serializable)((Object)id));
            if (count != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Map<String, Object>> getAllOrgTree() {
        List demAll = this.demensionService.getAll();
        ArrayList<Map<String, Object>> rootNode = new ArrayList<Map<String, Object>>();
        demAll.stream().forEach(d -> {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("id", d.getId());
            r.put("name", d.getDemName());
            r.put("demId", d.getId());
            QueryFilter filter = QueryFilter.build();
            filter.addParams("parentId", (Object)"('0')");
            filter.addParams("demId", (Object)d.getId());
            List childrenOrg = this.orgService.getByParentAndDem(filter);
            ArrayList children = new ArrayList();
            childrenOrg.stream().forEach(child -> {
                HashMap<String, Object> c = new HashMap<String, Object>();
                c.put("id", child.getId());
                c.put("name", child.getName());
                c.put("demId", child.getDemId());
                c.put("children", this.findchildrenNode(child.getId()));
                c.put("parentId", d.getId());
                children.add(c);
            });
            r.put("children", children);
            r.put("parentId", "0");
            rootNode.add(r);
        });
        return rootNode;
    }

    @Override
    public List<CmgtDutyOrgWorkarrange> findAll() {
        return this.getAll();
    }

    public List<Map<String, Object>> findchildrenNode(String pid) {
        List childrenOrg = this.orgService.getOrgsByparentId(pid);
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        childrenOrg.stream().forEach(child -> {
            HashMap<String, Object> c = new HashMap<String, Object>();
            c.put("id", child.getId());
            c.put("name", child.getName());
            c.put("demId", child.getDemId());
            c.put("children", this.findchildrenNode(child.getId()));
            c.put("parentId", pid);
            children.add(c);
        });
        return children;
    }
}

