/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.manager.DeviceStatusLogManager;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.vo.StatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u8bbe\u5907-\u6027\u80fd\u5206\u6790"})
@RequestMapping(value={"/performanceAnalysis/v1/"})
@ApiGroup(group={"device_biz"})
public class DeviceSafetyController {
    private static final Logger log = LoggerFactory.getLogger(DeviceSafetyController.class);
    @Autowired
    private DeviceStatusLogManager logManager;
    @Autowired
    private DeviceWarnInfoManager warnInfoManager;

    @PostMapping(value={"/statistics"})
    @ApiOperation(value="\u8bbe\u5907\u72b6\u6001\u7edf\u8ba1")
    public CommonResult<List<StatisticsVo>> statistics(@ApiParam(name="dto", value="\u53c2\u6570") @RequestBody StatisticsDto dto) {
        log.info("\u8bbe\u5907\u65e5\u5fd7\u72b6\u6001\u7edf\u8ba1\u8bf7\u6c42\u53c2\u6570:{}", (Object)dto);
        List<StatisticsVo> data = this.logManager.statistics(dto);
        log.info("\u8bbe\u5907\u65e5\u5fd7\u72b6\u6001\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/statisticsSub"})
    @ApiOperation(value="\u8bbe\u5907\u72b6\u6001\u7edf\u8ba1\u00b7\u4e0b\u94bb")
    public CommonResult<List<StatisticsVo>> statisticsSub(@ApiParam(name="dto", value="\u53c2\u6570") @RequestBody StatisticsDto dto) {
        log.info("\u8bbe\u5907\u65e5\u5fd7\u72b6\u6001\u7edf\u8ba1\u00b7\u4e0b\u94bb\u8bf7\u6c42\u53c2\u6570:{}", (Object)dto);
        List<StatisticsVo> data = this.logManager.statisticsSub(dto);
        log.info("\u8bbe\u5907\u65e5\u5fd7\u72b6\u6001\u7edf\u8ba1\u00b7\u4e0b\u94bb\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/statisticsTrouble"})
    @ApiOperation(value="\u8bbe\u5907\u6545\u969c\u6b21\u6570\u7edf\u8ba1")
    public CommonResult<List<StatisticsVo>> statisticsTrouble(@ApiParam(name="dto", value="\u53c2\u6570") @RequestBody StatisticsDto dto) {
        log.info("\u8bbe\u5907\u65e5\u5fd7\u72b6\u6001\u7edf\u8ba1\u8bf7\u6c42\u53c2\u6570:{}", (Object)dto);
        List<StatisticsVo> data = this.logManager.statisticsTrouble(dto);
        log.info("\u8bbe\u5907\u65e5\u5fd7\u72b6\u6001\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/statisticsCurrentTrouble"})
    @ApiOperation(value="\u5f53\u524d\u8bbe\u5907\u6545\u969c\u6b21\u6570\u7edf\u8ba1", notes="\u622a\u6b62\u81f3\u5f53\u524d\u65f6\u95f4\u7684\u6b21\u6570\u7edf\u8ba1")
    public CommonResult<List<StatisticsVo>> statisticsCurrentTrouble() {
        log.info("\u5f53\u524d\u8bbe\u5907\u6545\u969c\u6b21\u6570\u7edf\u8ba1\u8bf7\u8bf7\u6c42\u5f00\u59cb......");
        List<StatisticsVo> data = this.logManager.statisticsCurrentTrouble();
        log.info("\u5f53\u524d\u8bbe\u5907\u6545\u969c\u6b21\u6570\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/troubleCountMonthly"})
    @ApiOperation(value="\u5404\u6708\u4efd\u8bbe\u5907\u6545\u969c\u6b21\u6570\u7edf\u8ba1", notes="\u4ece\u5f53\u524d\u6708\u5f00\u59cb\u524d\u5341\u4e8c\u4e2a\u6708\u7684\u6570\u636e")
    public CommonResult<List<StatisticsVo>> troubleCountMonthly() {
        log.info("\u5404\u6708\u4efd\u8bbe\u5907\u6545\u969c\u6b21\u6570\u7edf\u8ba1\u8bf7\u6c42\u5f00\u59cb......");
        List<StatisticsVo> data = this.logManager.troubleCountMonthly();
        log.info("\u5404\u6708\u4efd\u8bbe\u5907\u6545\u969c\u6b21\u6570\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/statisticsWarn"})
    @ApiOperation(value="\u8bbe\u5907\u544a\u8b66\u7edf\u8ba1")
    public CommonResult<List<StatisticsVo>> statisticsWarn(@ApiParam(name="dto", value="\u53c2\u6570") @RequestBody StatisticsDto dto) {
        log.info("\u8bbe\u5907\u544a\u8b66\u7edf\u8ba1\u8bf7\u6c42\u53c2\u6570:{}", (Object)dto);
        List<StatisticsVo> data = this.warnInfoManager.statisticsWarn(dto);
        log.info("\u8bbe\u5907\u544a\u8b66\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/statisticsWarnSub"})
    @ApiOperation(value="\u8bbe\u5907\u544a\u8b66\u7edf\u8ba1\u00b7\u4e0b\u94bb")
    public CommonResult<List<StatisticsVo>> statisticsWarnSub(@ApiParam(name="dto", value="\u53c2\u6570") @RequestBody StatisticsDto dto) {
        log.info("\u8bbe\u5907\u544a\u8b66\u7edf\u8ba1\u00b7\u4e0b\u94bb\u8bf7\u6c42\u53c2\u6570:{}", (Object)dto);
        List<StatisticsVo> data = this.warnInfoManager.statisticsWarnSub(dto);
        log.info("\u8bbe\u5907\u544a\u8b66\u7edf\u8ba1\u00b7\u4e0b\u94bb\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/warnCountMonthly"})
    @ApiOperation(value="\u5404\u6708\u4efd\u8bbe\u5907\u544a\u8b66\u6b21\u6570\u7edf\u8ba1", notes="\u4ece\u5f53\u524d\u6708\u5f00\u59cb\u524d\u5341\u4e8c\u4e2a\u6708\u7684\u6570\u636e")
    public CommonResult<JSONObject> warnCountMonthly() {
        log.info("\u5404\u6708\u4efd\u8bbe\u5907\u544a\u8b66\u6b21\u6570\u7edf\u8ba1\u8ba1\u8bf7\u6c42\u5f00\u59cb......");
        List<StatisticsVo> data = this.warnInfoManager.warnCountMonthly();
        log.info("\u5404\u6708\u4efd\u8bbe\u5907\u6545\u969c\u6b21\u6570\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/warnCountCurrently"})
    @ApiOperation(value="\u5f53\u524d\u8bbe\u5907\u544a\u8b66\u6b21\u6570\u7edf\u8ba1", notes="\u622a\u6b62\u81f3\u5f53\u524d\u65f6\u95f4\u7684\u6b21\u6570\u7edf\u8ba1")
    public CommonResult<JSONObject> warnCountCurrently() {
        log.info("\u5f53\u524d\u8bbe\u5907\u544a\u8b66\u6b21\u6570\u7edf\u8ba1\u8bf7\u6c42\u5f00\u59cb......");
        List<StatisticsVo> data = this.warnInfoManager.warnCountCurrently();
        log.info("\u5f53\u524d\u8bbe\u5907\u544a\u8b66\u6b21\u6570\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }
}

