/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.device.base.manager.DeviceInfoManager;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.vo.HomeRealTimeVo;
import com.artfess.device.base.vo.StatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9996\u9875"})
@RequestMapping(value={"/homepage/v1/"})
@ApiGroup(group={"device_biz"})
public class HomePageController {
    private static final Logger log = LoggerFactory.getLogger(HomePageController.class);
    @Autowired
    private DeviceInfoManager deviceManager;
    @Autowired
    private DeviceWarnInfoManager warnInfoManager;

    @PostMapping(value={"/deviceStatistics"})
    @ApiOperation(value="\u8bbe\u5907\u7edf\u8ba1")
    public CommonResult<List<StatisticsVo>> deviceStatistics() {
        log.info("\u8bbe\u5907\u7edf\u8ba1\u8bf7\u6c42\u5f00\u59cb......");
        List<StatisticsVo> data = this.deviceManager.homeStatistics();
        log.info("\u8bbe\u5907\u7edf\u8ba1\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"currentStatusAnalyze"})
    @ApiOperation(value="\u5f53\u524d\u8bbe\u5907\u72b6\u6001\u5206\u6790")
    public CommonResult<List<StatisticsVo>> currentStatusAnalyze() {
        log.info("\u5f53\u524d\u8bbe\u5907\u72b6\u6001\u5206\u6790\u8bf7\u6c42\u5f00\u59cb......");
        List<StatisticsVo> data = this.deviceManager.currentStatusAnalyze();
        log.info("\u5f53\u524d\u8bbe\u5907\u72b6\u6001\u5206\u6790\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/monthlyAnalyze"})
    @ApiOperation(value="\u8fd1\u4e00\u6708\u72b6\u6001\u5206\u6790")
    public CommonResult<List<StatisticsVo>> monthlyAnalyze(@RequestParam @ApiParam(name="code", value="\u4ea7\u54c1\u5206\u7c7b\u7f16\u7801") String code) {
        log.info("\u8fd1\u4e00\u6708\u72b6\u6001\u5206\u6790\u8bf7\u6c42\u5f00\u59cb......");
        List<StatisticsVo> data = this.deviceManager.monthlyAnalyze(code);
        log.info("\u8fd1\u4e00\u6708\u72b6\u6001\u5206\u6790\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/realTimeData"})
    @ApiOperation(value="\u5b9e\u65f6\u6570\u636e")
    public CommonResult<List<HomeRealTimeVo>> realTimeData(@RequestParam @ApiParam(name="code", value="ProductTypeEnum \u7684code") String code) {
        log.info("\u5b9e\u65f6\u6570\u636e\u8bf7\u6c42\u53c2\u6570:{}", (Object)code);
        List<HomeRealTimeVo> data = this.deviceManager.homeRealTime(code);
        log.info("\u5b9e\u65f6\u6570\u636e\u54cd\u5e94\u7ed3\u679c:{}", data);
        return CommonResult.success(data, (String)"\u67e5\u8be2\u6210\u529f");
    }
}

