/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.service.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.uc.model.User;
import com.artfess.uc.service.UserDetailsFacade;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsFacadeImpl
implements UserDetailsFacade {
    private static final long serialVersionUID = 1L;

    @Override
    public UserDetails loadUserDetails(Collection<GrantedAuthority> authorities, Object obj) throws Exception {
        JsonNode jsonNode = JsonUtil.toJsonNode((Object)obj);
        String id = jsonNode.get("id").asText();
        String account = jsonNode.get("account").asText();
        String pwd = jsonNode.get("password").asText();
        int status = jsonNode.get("status").asInt();
        String fullname = jsonNode.get("fullname").asText();
        String email = jsonNode.get("email").asText();
        String mobile = jsonNode.get("mobile").asText();
        String weixin = jsonNode.get("weixin").asText();
        String tenantId = jsonNode.get("tenantId").asText();
        String clientId = jsonNode.get("clientId").asText();
        String clientToken = jsonNode.get("clientToken").asText();
        Integer userLevel = 1;
        Integer lockedStatus = jsonNode.get("lockedStatus").asInt();
        LocalDateTime pwdCreateTime = null;
        LocalDateTime lockedTime = null;
        LocalDateTime lastLoginTime = null;
        if (BeanUtils.isNotEmpty((Object)jsonNode.get("pwdCreateTime"))) {
            pwdCreateTime = TimeUtil.convertString((String)jsonNode.get("pwdCreateTime").asText());
        }
        if (BeanUtils.isNotEmpty((Object)jsonNode.get("lastLoginTime"))) {
            lastLoginTime = TimeUtil.convertString((String)jsonNode.get("lastLoginTime").asText());
        }
        if (BeanUtils.isNotEmpty((Object)jsonNode.get("lockedTime"))) {
            lockedTime = TimeUtil.convertString((String)jsonNode.get("lockedTime").asText());
        }
        if (BeanUtils.isNotEmpty((Object)jsonNode.get("userLevel"))) {
            userLevel = jsonNode.get("userLevel").asInt();
        }
        JsonNode jsonNode2 = jsonNode.get("attributes");
        Map attributes = JsonUtil.toMap((String)JsonUtil.toJson((Object)jsonNode2));
        User user = new User(account, fullname, pwd, authorities);
        user.setId(id);
        user.setStatus(status);
        user.setAttributes(attributes);
        user.isEnabled();
        user.setMobile(mobile);
        user.setEmail(email);
        user.setWeixin(weixin);
        user.setTenantId(tenantId);
        user.setPwdCreateTime(pwdCreateTime);
        user.setClientId(clientId);
        user.setClientToken(clientToken);
        user.setUserLevel(userLevel);
        user.setLockedTime(lockedTime);
        user.setLastLoginTime(lastLoginTime);
        user.setLockedStatus(lockedStatus);
        return user;
    }
}

