/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.sysConfig.persistence.manager.SysPropertiesManager;
import com.artfess.sysConfig.persistence.model.SysProperties;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysProperties/v1"})
@Api(tags={"\u7cfb\u7edf\u5c5e\u6027"})
@ApiGroup(group={"group_system"})
public class SysPropertiesController
extends BaseController<SysPropertiesManager, SysProperties> {
    @Resource
    SysPropertiesManager sysPropertiesManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5c5e\u6027\u5217\u8868", httpMethod="POST", notes="\u7cfb\u7edf\u5c5e\u6027\u5217\u8868")
    public PageList<SysProperties> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysProperties> queryFilter) throws Exception {
        return this.sysPropertiesManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5c5e\u6027\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u7cfb\u7edf\u5c5e\u6027\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysProperties getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        SysProperties sysProperties = new SysProperties();
        List groups = this.sysPropertiesManager.getGroups();
        if (StringUtil.isEmpty((String)id)) {
            sysProperties.setCategorys(groups);
            return sysProperties;
        }
        sysProperties = (SysProperties)this.sysPropertiesManager.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)sysProperties)) {
            sysProperties = this.sysPropertiesManager.getByAliasFromDb(id);
        }
        if (BeanUtils.isNotEmpty((Object)sysProperties)) {
            String val = sysProperties.getRealVal();
            sysProperties.setValue(val);
            sysProperties.setCategorys(groups);
        }
        return sysProperties;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u5c5e\u6027\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u5c5e\u6027\u4fe1\u606f")
    @CacheEvict(value={"bpm:sys:props"}, key="#sysProperties.alias")
    public CommonResult<String> save(@ApiParam(name="sysProperties", value="\u7cfb\u7edf\u5c5e\u6027", required=true) @RequestBody @Valid SysProperties sysProperties) throws Exception {
        String resultMsg = null;
        String id = sysProperties.getId();
        sysProperties.setValByEncrypt();
        if (StringUtil.isEmpty((String)id)) {
            sysProperties.setId(UniqueIdUtil.getSuid());
            this.sysPropertiesManager.create((Model)sysProperties);
            resultMsg = "\u6dfb\u52a0\u7cfb\u7edf\u5c5e\u6027\u6210\u529f";
        } else {
            this.sysPropertiesManager.update((Model)sysProperties);
            resultMsg = "\u66f4\u65b0\u7cfb\u7edf\u5c5e\u6027\u6210\u529f";
        }
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u5c5e\u6027\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u5c5e\u6027\u8bb0\u5f551,2,3")
    @CacheEvict(value={"bpm:sys:props"}, allEntries=true)
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        this.sysPropertiesManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u7cfb\u7edf\u5c5e\u6027\u6210\u529f");
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u53c2\u6570\u503c\u3002", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u53c2\u6570\u503c")
    public String getByAlias(@ApiParam(name="alias", value="\u5c5e\u6027\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="defaultValue", value="\u9ed8\u8ba4\u503c") @RequestParam Optional<String> defaultValue) throws Exception {
        String value = this.sysPropertiesManager.getByAlias(alias, defaultValue.orElse(""));
        return value;
    }

    @RequestMapping(value={"getDecryptByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u89e3\u5bc6\u540e\u53c2\u6570\u503c\u3002", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u89e3\u5bc6\u540e\u53c2\u6570\u503c")
    public SysProperties getDecryptByAlias(@ApiParam(name="alias", value="\u5c5e\u6027\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        SysProperties sysProperties = this.sysPropertiesManager.getByAliasFromDb(alias);
        if (BeanUtils.isNotEmpty((Object)sysProperties)) {
            sysProperties.setValue(EncryptUtil.decrypt((String)sysProperties.getValue()));
            return sysProperties;
        }
        return null;
    }

    @RequestMapping(value={"getDecryptBySysSetting"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u522b\u540d\u4e3a\u201csysSetting\u201d\u89e3\u5bc6\u540e\u53c2\u6570\u503c", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u522b\u540d\u4e3a\u201csysSetting\u201d\u89e3\u5bc6\u540e\u53c2\u6570\u503c")
    public SysProperties getDecryptBySysSetting() throws Exception {
        SysProperties sysProperties = this.sysPropertiesManager.getByAliasFromDb("sysSetting");
        if (BeanUtils.isNotEmpty((Object)sysProperties)) {
            sysProperties.setValue(EncryptUtil.decrypt((String)sysProperties.getValue()));
            return sysProperties;
        }
        return null;
    }
}

