/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.safty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.safty.dao.CmgtSaftyPlanDao;
import com.artfess.manage.safty.dao.CmgtSaftyPlanTaskDao;
import com.artfess.manage.safty.manager.CmgtSaftyPlanManager;
import com.artfess.manage.safty.manager.CmgtSaftyPlanTaskManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyPlanDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyPlanDtoMapper;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyPlanTaskDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyPlan;
import com.artfess.manage.safty.model.CmgtSaftyPlanTask;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CmgtSaftyPlanManagerImpl
extends BaseManagerImpl<CmgtSaftyPlanDao, CmgtSaftyPlan>
implements CmgtSaftyPlanManager {
    @Resource
    private UserDao userDao;
    @Resource
    private CmgtSaftyPlanDao cmgtSaftyPlanDao;
    @Resource
    private CmgtSaftyPlanDtoMapper cmgtSaftyPlanDtoMapper;
    @Resource
    private ManageCommonService manageCommonService;
    @Resource
    private CmgtSaftyPlanTaskDao cmgtSaftyPlanTaskDao;
    @Resource
    private CmgtSaftyPlanTaskDtoMapper cmgtSaftyPlanTaskDtoMapper;
    @Resource
    private CmgtSaftyPlanTaskManager cmgtSaftyPlanTaskManager;

    @Override
    public PageList<CmgtSaftyPlanDto> pageQuery(QueryFilter<CmgtSaftyPlan> queryFilter) {
        PageList result = this.query(queryFilter);
        PageList r = new PageList(result.getRows().stream().map(e -> {
            User user;
            CmgtSaftyPlanDto t = (CmgtSaftyPlanDto)((Object)((Object)this.cmgtSaftyPlanDtoMapper.toDto(e)));
            t.setTargetIdName(this.manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getCmgtSaftyTargets", "id", "name", t.getTargetId()));
            t.setCmgtSaftyPlanTaskList(this.cmgtSaftyPlanTaskDtoMapper.toDto(this.cmgtSaftyPlanTaskManager.selectListByPlanId(t.getId())));
            if (e.getCreateBy() != null && (user = (User)this.userDao.selectById((Serializable)((Object)e.getCreateBy()))) != null) {
                t.setCreateByName(user.getFullname());
            }
            return t;
        }).collect(Collectors.toList()));
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyPlan t) {
        int i = ((CmgtSaftyPlanDao)this.baseMapper).insert((Object)t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyPlan t) {
        ((CmgtSaftyPlanDao)this.baseMapper).updateById((Object)t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyPlan t) {
        ((CmgtSaftyPlanDao)this.baseMapper).deleteById((Serializable)((Object)t.getId()));
    }

    @Override
    public String create(CmgtSaftyPlanDto dto) {
        CmgtSaftyPlan t = (CmgtSaftyPlan)((Object)this.cmgtSaftyPlanDtoMapper.toEntity(dto));
        int i = ((CmgtSaftyPlanDao)this.baseMapper).insert((Object)t);
        if (i > 0) {
            if (dto.getCmgtSaftyPlanTaskList() != null && dto.getCmgtSaftyPlanTaskList().size() > 0) {
                dto.getCmgtSaftyPlanTaskList().forEach(c -> {
                    CmgtSaftyPlanTask e = (CmgtSaftyPlanTask)((Object)((Object)this.cmgtSaftyPlanTaskDtoMapper.toEntity(c)));
                    e.setPlanId(t.getId());
                    this.cmgtSaftyPlanTaskDao.insert((Object)e);
                });
            }
            return t.getId();
        }
        return null;
    }

    @Override
    public String update(CmgtSaftyPlanDto dto) {
        CmgtSaftyPlan t = (CmgtSaftyPlan)((Object)this.cmgtSaftyPlanDtoMapper.toEntity(dto));
        ((CmgtSaftyPlanDao)this.baseMapper).updateById((Object)t);
        List<CmgtSaftyPlanTask> cmgtSaftyPlanTasks = this.cmgtSaftyPlanTaskManager.selectListByPlanId(t.getId());
        for (CmgtSaftyPlanTask cmgtSaftyPlanTask : cmgtSaftyPlanTasks) {
            this.cmgtSaftyPlanTaskDao.deleteById((Serializable)((Object)cmgtSaftyPlanTask.getId()));
        }
        if (dto.getCmgtSaftyPlanTaskList() != null && dto.getCmgtSaftyPlanTaskList().size() > 0) {
            dto.getCmgtSaftyPlanTaskList().forEach(c -> {
                CmgtSaftyPlanTask e = (CmgtSaftyPlanTask)((Object)((Object)this.cmgtSaftyPlanTaskDtoMapper.toEntity(c)));
                e.setPlanId(t.getId());
                e.setId(null);
                this.cmgtSaftyPlanTaskDao.insert((Object)e);
            });
        }
        return t.getId();
    }

    @Override
    public boolean delete(List<String> ids) {
        for (String id : ids) {
            List<CmgtSaftyPlanTask> cmgtSaftyPlanTasks = this.cmgtSaftyPlanTaskManager.selectListByPlanId(id);
            for (CmgtSaftyPlanTask cmgtSaftyPlanTask : cmgtSaftyPlanTasks) {
                this.cmgtSaftyPlanTaskDao.deleteById((Serializable)((Object)cmgtSaftyPlanTask.getId()));
            }
            int count = ((CmgtSaftyPlanDao)this.baseMapper).deleteById((Serializable)((Object)id));
            if (count != 0) continue;
            return false;
        }
        return true;
    }
}

