/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.duty.controller;

import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.duty.manager.CmgtDutyTeamManager;
import com.artfess.manage.duty.manager.CmgtDutyTeamMemberManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkclassManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyWorkarrangeDto;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import com.artfess.manage.duty.model.CmgtDutyWorkarrange;
import com.artfess.manage.duty.model.CmgtDutyWorkclass;
import com.artfess.manage.duty.vo.WorkArrangeInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6392\u73ed\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/manager/cmgtDutyWorkarrange"})
@ApiGroup(group={"manager_biz"})
public class CmgtDutyWorkarrangeController
extends BaseController<CmgtDutyWorkarrangeManager, CmgtDutyWorkarrange> {
    private static final Logger log = LoggerFactory.getLogger(CmgtDutyWorkarrangeController.class);
    @Autowired
    private CmgtDutyWorkclassManager workclassManager;
    @Autowired
    private CmgtDutyTeamMemberManager teamMemberManager;
    @Autowired
    private CmgtDutyTeamManager teamManager;
    @Autowired
    private CmgtDutyWorkarrangeManager cmgtDutyWorkarrange;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u6392\u73ed\u4fe1\u606f")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtDutyWorkarrangeDto t) {
        this.cmgtDutyWorkarrange.saveInfo(t, true);
        return new CommonResult();
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) CmgtDutyWorkarrangeDto t) {
        this.cmgtDutyWorkarrange.saveInfo(t, false);
        return new CommonResult();
    }

    @PostMapping(value={"/query/team"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eorgId\u67e5\u8be2\u5c0f\u7ec4\u4fe1\u606f")
    public CommonResult<String> queryTeamByOrgId(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody QueryFilter<CmgtDutyTeam> filter) {
        List teams = this.teamManager.queryNoPage(filter);
        return CommonResult.success((Object)teams, null);
    }

    @PostMapping(value={"/query/teamMember"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eorgId\u67e5\u8be2\u7ec4\u5458\u4fe1\u606f")
    public CommonResult<String> queryTeamMemberByOrgId(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody QueryFilter<CmgtDutyTeamMember> filter) {
        List teamMembers = this.teamMemberManager.queryNoPage(filter);
        return CommonResult.success((Object)teamMembers, null);
    }

    @PostMapping(value={"/query/class"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u73ed\u79cd\u4fe1\u606f")
    public CommonResult<String> queryClassByOrgId(@RequestBody QueryFilter<CmgtDutyWorkclass> filter) {
        List classList = this.workclassManager.queryNoPage(filter);
        return CommonResult.success((Object)classList, null);
    }

    @GetMapping(value={"/query/members"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eteamId\u67e5\u8be2\u4eba\u5458\u4fe1\u606f")
    public CommonResult<String> queryMembers(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestParam String teamId, @RequestParam String orgId) {
        ArrayList<Map<String, Object>> mlist = new ArrayList<Map<String, Object>>();
        if (StringUtil.isNotEmpty((String)teamId)) {
            mlist.addAll(this.teamMemberManager.findAllMembersByTeamId(teamId));
        } else if (StringUtil.isNotEmpty((String)orgId)) {
            mlist.addAll(this.teamMemberManager.findMembersUngroupedByOrgId(orgId));
        }
        return CommonResult.success(mlist, null);
    }

    @PostMapping(value={"/query/fastWorkArrange"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6309\u7167\u90e8\u95e8\u4e00\u952e\u6392\u73ed")
    public CommonResult<String> fastWorkArrange(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody Map<String, Object> params) {
        System.out.println(params.toString());
        boolean result = false;
        try {
            result = this.cmgtDutyWorkarrange.fastWorkarrange(params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query/findMonthArrangeInfo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6bcf\u6708\u6392\u73ed\u4fe1\u606f")
    public CommonResult<String> query(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody Map<String, Object> params) {
        List<WorkArrangeInfoVo> all = this.cmgtDutyWorkarrange.findAllByMonth(params.get("date").toString(), params.get("orgId").toString());
        return CommonResult.success(all, null);
    }

    @PostMapping(value={"/query/findTeamMemberArrangeing"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u961f\u5458\u6708\u5ea6\u6392\u73ed\u4fe1\u606f")
    public CommonResult<String> findTeamMemberArrangeing(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody Map<String, Object> params) {
        if (params.get("startDate") != null) {
            return CommonResult.success(this.cmgtDutyWorkarrange.findTeamMemberArrangeing(params.get("startDate").toString(), params.get("endDate").toString(), params.get("teamMemberId").toString()), null);
        }
        return CommonResult.success(this.cmgtDutyWorkarrange.findTeamMemberArrangeing(params.get("date").toString(), params.get("teamMemberId").toString()), null);
    }

    @ApiOperation(value="\u6309\u7ec4\u5bfc\u51fa\u6392\u73ed\u4fe1\u606f")
    @PostMapping(value={"/export"}, produces={"application/json; charset=utf-8"})
    public void exportExecl(HttpServletRequest request, HttpServletResponse response, @RequestBody String date) {
        this.cmgtDutyWorkarrange.exportExcel(request, response, date);
    }

    @ApiOperation(value="\u6309\u4eba\u5458\u5bfc\u51fa\u6392\u73ed\u4fe1\u606f")
    @PostMapping(value={"/exportmember"}, produces={"application/json; charset=utf-8"})
    public void exportMemberArrangeExecl(HttpServletRequest request, HttpServletResponse response, @RequestBody String date) throws ParseException {
        this.cmgtDutyWorkarrange.exportMemberArrangeExcel(request, response, date);
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u52e4\u4eba\u5458")
    @PostMapping(value={"/onDudyMember"}, produces={"application/json; charset=utf-8"})
    public CommonResult<String> onDudyMember(@RequestBody JSONObject params) throws ParseException {
        System.out.println("========jobIds=============" + params);
        List jobIds = null;
        if (!params.isNull((Object)"jobIds")) {
            jobIds = params.getJSONArray((Object)"jobIds").toList(String.class);
        }
        if (!params.isNull((Object)"rq")) {
            List rqs = params.getJSONArray((Object)"rq").toList(LocalDateTime.class);
            return CommonResult.success((Object)this.cmgtDutyWorkarrange.findHistoryDutyStaff(jobIds, rqs, params), null);
        }
        return CommonResult.success((Object)this.cmgtDutyWorkarrange.findCurrentStaffOnDuty(jobIds), null);
    }
}

