/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceBaseParamsConfDao;
import com.artfess.device.base.dao.DeviceBaseParamsValueDao;
import com.artfess.device.base.manager.DeviceBaseParamsConfManager;
import com.artfess.device.base.model.DeviceBaseParamsConf;
import com.artfess.device.base.model.DeviceBaseParamsValue;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DeviceBaseParamsConfManagerImpl
extends BaseManagerImpl<DeviceBaseParamsConfDao, DeviceBaseParamsConf>
implements DeviceBaseParamsConfManager {
    @Resource
    private DeviceBaseParamsValueDao deviceBaseParamsValueDao;

    @Override
    public List<DeviceBaseParamsConf> findAll(DeviceBaseParamsConf conf) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)conf.getCode())) {
            queryWrapper.like((Object)"code_", (Object)conf.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)conf.getName())) {
            queryWrapper.like((Object)"name_", (Object)conf.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)conf.getType())) {
            queryWrapper.eq((Object)"type_", (Object)conf.getType());
        }
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        queryWrapper.orderByAsc((Object)"sn_");
        return ((DeviceBaseParamsConfDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DeviceBaseParamsValue> getConfValue(DeviceBaseParamsValue value) {
        Assert.hasText((String)value.getBaseId(), (String)"\u57fa\u7840\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)value.getType(), (String)"\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"base_id_", (Object)value.getBaseId());
        queryWrapper.eq((Object)"type_", (Object)value.getType());
        return this.deviceBaseParamsValueDao.selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveParamsValue(List<DeviceBaseParamsValue> values, String baseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"base_id_", (Object)baseId);
        this.deviceBaseParamsValueDao.delete((Wrapper)queryWrapper);
        if (null == values) {
            return;
        }
        Assert.hasText((String)baseId, (String)"\u57fa\u7840\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        values.forEach(value -> {
            Assert.hasText((String)value.getType(), (String)"\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            value.setBaseId(baseId);
            this.deviceBaseParamsValueDao.insert(value);
        });
    }
}

