/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dao.AppraiseBaseDao;
import com.artfess.device.base.manager.AppraiseBaseManager;
import com.artfess.device.base.manager.AppraiseItemsManager;
import com.artfess.device.base.model.AppraiseBase;
import com.artfess.device.base.model.AppraiseItems;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AppraiseBaseManagerImpl
extends BaseManagerImpl<AppraiseBaseDao, AppraiseBase>
implements AppraiseBaseManager {
    @Autowired
    private AppraiseItemsManager itemsManager;

    public PageList<AppraiseBase> query(QueryFilter<AppraiseBase> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        QueryWrapper queryWrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        IPage<AppraiseBase> result = ((AppraiseBaseDao)this.baseMapper).queryPage((IPage<AppraiseBase>)this.convert2IPage(pageBean), (Wrapper<AppraiseBase>)queryWrapper);
        List items = this.itemsManager.list();
        result.getRecords().forEach(r -> {
            ArrayList itemsList = Lists.newArrayList();
            items.forEach(i -> {
                if (i.getBaseId().equals(r.getId())) {
                    itemsList.add(i);
                }
            });
            r.setItemsList(itemsList);
        });
        return new PageList(result);
    }

    @Override
    public boolean publish(AppraiseBase t) {
        Assert.notNull((Object)((Object)t), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)t.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)t.getPublishStatus(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"id_", (Object)t.getId())).set((Object)"publish_status_", (Object)t.getPublishStatus()));
    }

    public boolean save(AppraiseBase t) {
        this.checkWeight(t.getItemsList());
        boolean result = super.save((Object)t);
        t.getItemsList().forEach(il -> il.setBaseId(t.getId()));
        this.itemsManager.saveBatch(t.getItemsList());
        return result;
    }

    public boolean updateById(AppraiseBase t) {
        this.checkWeight(t.getItemsList());
        boolean result = super.updateById((Object)t);
        t.getItemsList().forEach(il -> il.setBaseId(t.getId()));
        this.itemsManager.saveOrUpdateBatch(t.getItemsList());
        return result;
    }

    public AppraiseBase getById(Serializable id) {
        AppraiseBase result = (AppraiseBase)((Object)super.getById(id));
        result.setItemsList(this.itemsManager.list((Wrapper)new QueryWrapper().eq((Object)"base_id_", (Object)result.getId())));
        return result;
    }

    private void checkWeight(List<AppraiseItems> items) {
        BigDecimal weight = items.stream().map(AppraiseItems::getItemVal).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (weight.compareTo(new BigDecimal(1)) > 0 || weight.compareTo(new BigDecimal(0)) < 0) {
            throw new RuntimeException("\u6743\u91cd\u914d\u7f6e\u5f02\u5e38\uff0c\u5f53\u524d\u6743\u91cd\u548c\u4e3a\u3010" + weight.toPlainString() + "\u3011\uff0c\u6743\u91cd\u548c\u5e94\u843d\u4e8e\u533a\u95f4 [0, 1] \u4e2d");
        }
    }
}

