/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.device.base.dao.DeviceVideoBaseDao;
import com.artfess.device.base.dao.DeviceVideoPointExtendDao;
import com.artfess.device.base.manager.DeviceVideoBaseManager;
import com.artfess.device.base.manager.DeviceVideoPointManager;
import com.artfess.device.base.manager.DeviceVideoZoneManager;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.model.DeviceVideoBase;
import com.artfess.device.base.model.DeviceVideoPoint;
import com.artfess.device.base.model.DeviceVideoPointExtend;
import com.artfess.device.base.model.DeviceVideoZone;
import com.artfess.device.base.model.DeviceWarnInfo;
import com.artfess.device.base.vo.CollectVo;
import com.artfess.device.base.vo.DeviceWarnInfoVo;
import com.artfess.device.base.vo.HaiKangRequest;
import com.artfess.device.base.vo.HaiKangResult;
import com.artfess.device.base.vo.TreeCodeRespVo;
import com.artfess.rocketmq.producer.RocketMQProducer;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.hikvision.artemis.sdk.ArtemisHttpUtil;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DeviceVideoBaseManagerImpl
extends BaseManagerImpl<DeviceVideoBaseDao, DeviceVideoBase>
implements DeviceVideoBaseManager {
    private static final Logger log = LoggerFactory.getLogger(DeviceVideoBaseManagerImpl.class);
    @Autowired
    private DeviceVideoZoneManager videoZoneManager;
    @Autowired
    private DeviceVideoPointManager videoPointManager;
    @Autowired
    private DeviceWarnInfoManager warnInfoManager;
    @Resource
    private BaseContext baseContext;
    @Resource
    private DeviceVideoPointExtendDao deviceVideoPointExtendDao;
    @Autowired
    private RocketMQProducer rocketMQUtils;
    final String ARTEMIS_PATH = "/artemis";

    public List<DeviceVideoBase> getAllTreeCode(HaiKangRequest getAllTreeCodeRequest) {
        final String getAllTreeCodeDataApi = "/artemis/api/resource/v1/unit/getAllTreeCode";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", getAllTreeCodeDataApi);
            }
        };
        String body = JSON.toJSONString((Object)getAllTreeCodeRequest);
        String result = ArtemisHttpUtil.doPostStringArtemis((Map)path, (String)body, null, null, (String)"application/json");
        log.info("\u6d77\u5eb7\u76ee\u5f55\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)result);
        Assert.hasText((String)result, (String)"\u83b7\u53d6\u6d77\u5eb7\u8d44\u6e90\u76ee\u5f55\u5931\u8d25");
        HaiKangResult haiKangResult = (HaiKangResult)JSONObject.parseObject((String)result, HaiKangResult.class);
        if ("0".equals(haiKangResult.getCode())) {
            List resourceList = JSONArray.parseArray((String)haiKangResult.getData().getString("list"), TreeCodeRespVo.class);
            ArrayList list = Lists.newArrayList();
            resourceList.forEach(treeCodeRespVo -> {
                DeviceVideoBase videoBase = new DeviceVideoBase();
                videoBase.setCode(treeCodeRespVo.getTreeCode());
                videoBase.setName(treeCodeRespVo.getTreeName());
                videoBase.setPlatform("HK");
                list.add(videoBase);
            });
            return list;
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u6d77\u5eb7\u8d44\u6e90\u76ee\u5f55\u5931\u8d25");
    }

    public void regions(HaiKangRequest haiKangRequest) {
        final String regionsDataApi = "/artemis/api/resource/v1/regions";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", regionsDataApi);
            }
        };
        haiKangRequest.getTreeCodes().forEach(treeCode -> {
            haiKangRequest.setTreeCode((String)treeCode);
            haiKangRequest.setPageSize(2000);
            String body = JSON.toJSONString((Object)haiKangRequest);
            String result = ArtemisHttpUtil.doPostStringArtemis((Map)path, (String)body, null, null, (String)"application/json");
            log.info("\u6d77\u5eb7\u533a\u57df\u4fe1\u606f\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)result);
            Assert.hasText((String)result, (String)"\u83b7\u53d6\u6d77\u5eb7\u533a\u57df\u4fe1\u606f\u5931\u8d25");
            HaiKangResult haiKangResult = (HaiKangResult)JSONObject.parseObject((String)result, HaiKangResult.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"base_code_", (Object)haiKangRequest.getTreeCode());
            this.videoZoneManager.getBaseMapper().delete((Wrapper)queryWrapper);
            if (!"0".equals(haiKangResult.getCode())) {
                throw new IllegalArgumentException("\u83b7\u53d6\u6d77\u5eb7\u8d44\u6e90\u76ee\u5f55\u5931\u8d25");
            }
            List resourceList = JSONArray.parseArray((String)haiKangResult.getData().getString("list"), JSONObject.class);
            resourceList.stream().forEach(item -> {
                DeviceVideoZone zone = new DeviceVideoZone();
                zone.setCode(item.getString("indexCode"));
                zone.setPlatform("HK");
                zone.setName(item.getString("name"));
                zone.setBaseCode(item.getString("treeCode"));
                zone.setParentId(item.getString("parentIndexCode"));
                zone.setId(zone.getCode());
                String userId = this.baseContext.getCurrentUserId();
                String orgId = this.baseContext.getCurrentOrgId();
                zone.setCreateTime(LocalDateTime.now());
                zone.setUpdateTime(LocalDateTime.now());
                zone.setCreateBy(userId);
                zone.setCreateOrgId(orgId);
                this.videoZoneManager.saveTreeAndId(zone);
            });
        });
    }

    public List<DeviceVideoPoint> cameras(HaiKangRequest camerasRequest) {
        final String camerasDataApi = "/artemis/api/resource/v1/cameras";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", camerasDataApi);
            }
        };
        List<String> codeList = ((DeviceVideoBaseDao)this.baseMapper).findCodeByPlatform("HK");
        ArrayList list = Lists.newArrayList();
        if (codeList != null && codeList.size() > 0) {
            for (String baseCode : codeList) {
                camerasRequest.setTreeCode(baseCode);
                String body = JSON.toJSONString((Object)camerasRequest);
                String result = ArtemisHttpUtil.doPostStringArtemis((Map)path, (String)body, null, null, (String)"application/json");
                log.info("\u6d77\u5eb7\u76d1\u63a7\u70b9\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)result);
                Assert.hasText((String)result, (String)"\u83b7\u53d6\u6d77\u5eb7\u76d1\u63a7\u70b9\u5931\u8d25");
                HaiKangResult haiKangResult = (HaiKangResult)JSONObject.parseObject((String)result, HaiKangResult.class);
                if (!"0".equals(haiKangResult.getCode())) continue;
                List resourceList = JSONArray.parseArray((String)haiKangResult.getData().getString("list"), JSONObject.class);
                ArrayList warnInfoList = new ArrayList();
                resourceList.forEach(jsonObject -> {
                    DeviceVideoPoint res = new DeviceVideoPoint();
                    res.setCatalogCode(baseCode);
                    res.setZoneCode(jsonObject.getString("unitIndexCode"));
                    res.setCode(jsonObject.getString("cameraIndexCode"));
                    res.setPlatform("HK");
                    res.setName(jsonObject.getString("name"));
                    res.setLgtd(jsonObject.getString("longitude"));
                    res.setLttd(jsonObject.getString("latitude"));
                    res.setAddress(jsonObject.getString("installPlace"));
                    res.setStatus(jsonObject.getString("status"));
                    res.setAisle(jsonObject.getString("chanNum"));
                    res.setId(res.getCode());
                    String userId = this.baseContext.getCurrentUserId();
                    String orgId = this.baseContext.getCurrentOrgId();
                    res.setCreateTime(LocalDateTime.now());
                    res.setUpdateTime(LocalDateTime.now());
                    res.setCreateBy(userId);
                    res.setCreateOrgId(orgId);
                    list.add(res);
                    String code = String.valueOf(jsonObject.getString("cameraIndexCode"));
                    if (jsonObject.getString("status") == null || !jsonObject.getString("status").equals("1")) {
                        this.videoPointManager.updateVideoStatus(code, "2");
                        DeviceWarnInfo warnInfo = this.warnInfoManager.getNewWarnInfo(code, "1");
                        if (warnInfo == null || warnInfo != null && warnInfo.getHandleStatus() == 1) {
                            DeviceVideoPointExtend videoPointExtend;
                            warnInfo = new DeviceWarnInfo();
                            warnInfo.setDeviceCode(code);
                            warnInfo.setWarnName("\u89c6\u9891\u8bbe\u5907\u3010" + jsonObject.getString("name") + "\u3011\u79bb\u7ebf\u544a\u8b66\uff01");
                            warnInfo.setWarnType("1");
                            warnInfo.setDeviceType("5");
                            warnInfo.setWarnReason("\u89c6\u9891\u8bbe\u5907\u3010" + jsonObject.getString("name") + "\u3011\u79bb\u7ebf\uff0c\u53ef\u80fd\u53d1\u751f\u6545\u969c\uff01");
                            warnInfo.setWarnTime(res.getCreateTime());
                            warnInfo.setCreateTime(LocalDateTime.now());
                            warnInfo.setHandleStatus(0);
                            warnInfoList.add(warnInfo);
                            DeviceWarnInfoVo deviceWarnInfoVo = new DeviceWarnInfoVo();
                            deviceWarnInfoVo.setDevName(jsonObject.getString("name"));
                            deviceWarnInfoVo.setDevCode(warnInfo.getDeviceCode());
                            deviceWarnInfoVo.setEventSrcId(warnInfo.getId());
                            deviceWarnInfoVo.setEventTitle(warnInfo.getWarnName());
                            deviceWarnInfoVo.setEventTime(DateUtils.now());
                            deviceWarnInfoVo.setEventSubClass(warnInfo.getDeviceType());
                            deviceWarnInfoVo.setEventDesc(warnInfo.getWarnReason());
                            deviceWarnInfoVo.setEventType(Integer.valueOf(warnInfo.getWarnType()));
                            deviceWarnInfoVo.setEventAddr(jsonObject.getString("installPlace"));
                            if (!org.springframework.util.StringUtils.isEmpty((Object)jsonObject.getString("latitude"))) {
                                deviceWarnInfoVo.setEventLat(new BigDecimal(jsonObject.getString("latitude")));
                            }
                            if (!org.springframework.util.StringUtils.isEmpty((Object)jsonObject.getString("longitude"))) {
                                deviceWarnInfoVo.setEventLng(new BigDecimal(jsonObject.getString("longitude")));
                            }
                            if ((videoPointExtend = this.deviceVideoPointExtendDao.findVideoExtendByCode(warnInfo.getDeviceCode())) != null) {
                                deviceWarnInfoVo.setRegionCode(videoPointExtend.getAreaCode());
                                deviceWarnInfoVo.setRegionName(videoPointExtend.getAreaName());
                            }
                            String warnInfoString = JSON.toJSONString((Object)deviceWarnInfoVo);
                            try {
                                this.rocketMQUtils.send("sssb_device_warn_message_topic", warnInfoString);
                            }
                            catch (Exception e) {
                                log.error("\u53d1\u9001\u5931\u8d25:{}", (Throwable)e);
                            }
                        }
                    }
                    if (jsonObject.getString("status").equals("1")) {
                        this.videoPointManager.updateVideoStatus(code, "1");
                    }
                });
                if (warnInfoList == null || warnInfoList.size() <= 0) continue;
                this.warnInfoManager.saveBatch(warnInfoList);
            }
        }
        return list;
    }

    @Override
    public String hkPreviewURLs(String code, String module) {
        final String previewURLsDataApi = "/artemis/api/video/v1/cameras/previewURLs";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", previewURLsDataApi);
            }
        };
        HaiKangRequest previewURLsRequest = new HaiKangRequest();
        previewURLsRequest.setProtocol(module);
        previewURLsRequest.setCameraIndexCode(code);
        previewURLsRequest.setStreamType(0);
        previewURLsRequest.setTransmode(0);
        String body = JSON.toJSONString((Object)previewURLsRequest);
        String result = ArtemisHttpUtil.doPostStringArtemis((Map)path, (String)body, null, null, (String)"application/json");
        Assert.hasText((String)result, (String)"\u83b7\u53d6\u89c6\u9891\u6d41\u5730\u5740\u5931\u8d25");
        HaiKangResult haiKangResult = (HaiKangResult)JSONObject.parseObject((String)result, HaiKangResult.class);
        if ("0".equals(haiKangResult.getCode())) {
            String url = haiKangResult.getData().getString("url");
            return url;
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u89c6\u9891\u6d41\u5730\u5740\u5931\u8d25");
    }

    @Override
    public PageList<DeviceVideoPoint> findByPage(QueryFilter<DeviceVideoBase> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page((long)pageBean.getPage().intValue(), (long)pageBean.getPageSize().intValue());
        QueryWrapper queryWrapper = this.convert2Wrapper(queryFilter, DeviceVideoBase.class);
        queryWrapper.orderByDesc((Object)"b.CREATE_TIME_");
        IPage<DeviceVideoPoint> pageList = ((DeviceVideoBaseDao)this.baseMapper).findByPage((IPage<DeviceVideoBase>)page, (QueryWrapper<DeviceVideoBase>)queryWrapper);
        return new PageList(pageList);
    }

    @Override
    public List<DeviceVideoZone> getTree(CollectVo t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)t.getZoneCode())) {
            queryWrapper.eq((Object)"base_code_", (Object)t.getZoneCode());
        }
        List baseList = this.videoZoneManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        List zoneList = BeanUtils.listToTree((List)baseList);
        return zoneList;
    }

    @Override
    public List<DeviceVideoBase> getCataLogBase() {
        QueryWrapper queryWrapper = new QueryWrapper();
        List baseList = ((DeviceVideoBaseDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        return baseList;
    }

    @Override
    public List<DeviceVideoPoint> findByZoneCode(QueryFilter<DeviceVideoBase> queryFilter) {
        return ((DeviceVideoBaseDao)this.baseMapper).findByZoneCode(queryFilter.getParams());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void asycCataLog() {
        ((DeviceVideoBaseDao)this.baseMapper).delete(null);
        HaiKangRequest request = new HaiKangRequest();
        List<DeviceVideoBase> baseList = this.getAllTreeCode(request);
        DeviceVideoBase zgVideoBase = new DeviceVideoBase();
        zgVideoBase.setCode("zg001");
        zgVideoBase.setName("\u7d2b\u5149\u534e\u667a\u89c6\u9891\u5e73\u53f0");
        zgVideoBase.setPlatform("ZG");
        zgVideoBase.setSn(baseList.size() + 1);
        baseList.add(zgVideoBase);
        this.saveBatch(baseList);
        request.setPageSize(1);
        ArrayList treeCodes = Lists.newArrayList();
        baseList.forEach(DeviceVideoBase2 -> {
            if (DeviceVideoBase2.getPlatform().equals("HK")) {
                treeCodes.add(DeviceVideoBase2.getCode());
            }
        });
        request.setTreeCodes(treeCodes);
        this.regions(request);
        QueryWrapper zoneWrapper = new QueryWrapper();
        zoneWrapper.eq((Object)"platform_", (Object)"ZG");
        this.videoZoneManager.remove((Wrapper)zoneWrapper);
        this.videoPointManager.asycZGZone(false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void asycCataLogZone(HaiKangRequest haiKangRequest) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"base_code_", (Object)haiKangRequest.getTreeCode());
        this.videoZoneManager.getBaseMapper().delete((Wrapper)queryWrapper);
        ArrayList treeCodes = Lists.newArrayList();
        treeCodes.add(haiKangRequest.getTreeCode());
        haiKangRequest.setTreeCodes(treeCodes);
        this.regions(haiKangRequest);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void asycZoneRes(HaiKangRequest haiKangRequest) {
        QueryWrapper queryWrapper = new QueryWrapper();
        this.videoPointManager.getBaseMapper().delete((Wrapper)queryWrapper);
        List<DeviceVideoPoint> hkResList = this.cameras(haiKangRequest);
        List<DeviceVideoPoint> zgResList = this.videoPointManager.asycZGcameras(false);
        ArrayList resList = Lists.newArrayList();
        resList.addAll(hkResList);
        resList.addAll(zgResList);
        this.videoPointManager.saveBatch(resList);
    }

    @Override
    public List<DeviceVideoZone> getAllTree(CollectVo t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)t.getZoneCode())) {
            queryWrapper.eq((Object)"base_code_", (Object)t.getZoneCode());
        }
        List baseList = this.videoZoneManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        List<DeviceVideoZone> DeviceVideoPoint2 = ((DeviceVideoBaseDao)this.baseMapper).findByRes();
        DeviceVideoPoint2.forEach(videoPoint -> videoPoint.setType("2"));
        Map<String, List<DeviceVideoZone>> resMap = DeviceVideoPoint2.stream().collect(Collectors.groupingBy(BaseTreeModel::getParentId));
        baseList.forEach(videoZone -> {
            videoZone.setType("1");
            if (resMap.containsKey(videoZone.getCode())) {
                videoZone.setChildren((List)resMap.get(videoZone.getCode()));
            }
        });
        List zoneList = BeanUtils.listToTree((List)baseList);
        return zoneList;
    }

    static {
        ArtemisConfig.host = "183.230.114.212:10220";
        ArtemisConfig.appKey = "27900477";
        ArtemisConfig.appSecret = "OTeHSUxGKwFMSKEPdrll";
    }
}

